/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.desc.task;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Class;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Data;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.adapter.TaskProductionAdapter;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.log.ViewpointDslLogger;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.desc.internal.icons.GenerateIconPrecondition;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.exception.ViewpointResourceException;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.resourceimpl.GenmodelProviderImpl;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.resourceimpl.ViewpointResourceProviderRegistry;

public class generateEditToolsIconsTask
extends TaskProductionAdapter {
    private static final String LVPS_ICONS_FOLDER_ = "icons";

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        EMFDomain model = (EMFDomain)productionContext.getInputValue((Object)"vpdesc.model", EMFDomain.class);
        Viewpoint vp = (Viewpoint)model.getContent().get(0);
        try {
            this.generateToolsIcon(vp, LVPS_ICONS_FOLDER_);
        }
        catch (ViewpointResourceException e) {
            throw new InvocationException((Throwable)e);
        }
    }

    public void generateToolsIcon(Viewpoint viewpoint, String dslvpIconFolder) throws ViewpointResourceException {
        if (!GenerateIconPrecondition.generateIcon()) {
            return;
        }
        GenmodelProviderImpl genmodelProvider = ViewpointResourceProviderRegistry.getInstance().getGenmodelProvider();
        GenModel genModel = genmodelProvider.getGenModel();
        GenPackage genPackage = genmodelProvider.getGenPackage();
        String dslvpProjectName = viewpoint.eResource().getURI().segment(1);
        for (GenClass genClass : genPackage.getGenClasses()) {
            if (!genModel.isCreationCommands() || !genModel.isCreationIcons()) continue;
            for (GenFeature feature : genClass.getCreateChildFeaturesIncludingDelegation()) {
                for (GenClass childClass : genClass.getChildrenClasses(feature)) {
                    String iconSrcPath = this.getIconSourcePath(viewpoint, childClass);
                    if (iconSrcPath == null || iconSrcPath.trim().length() <= 0) continue;
                    String srcIconPath = "/" + dslvpProjectName + "/" + dslvpIconFolder + "/" + iconSrcPath;
                    this.CopyImageFromTo(srcIconPath, genClass.getCreateChildIconFileName(feature, childClass));
                }
            }
        }
        if (genModel.isCreationCommands() && genModel.isCreationIcons() && genPackage.isChildCreationExtenders()) {
            Map packages = null;
            try {
                packages = genPackage.getExtendedChildCreationData();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (packages != null) {
                for (Map.Entry packageEntry : packages.entrySet()) {
                    for (Map.Entry classEntry : ((Map)packageEntry.getValue()).entrySet()) {
                        GenClass genClass = (GenClass)classEntry.getKey();
                        for (GenClass.ChildCreationData childCreationData : (List)classEntry.getValue()) {
                            if (!(childCreationData.createClassifier instanceof GenClass) || childCreationData.delegatedFeature != null && !((GenClass)classEntry.getKey()).getAllGenFeatures().contains(childCreationData.delegatedFeature)) continue;
                            GenClass childClass = (GenClass)childCreationData.createClassifier;
                            GenFeature feature = childCreationData.createFeature;
                            String iconSrcPath = this.getIconSourcePath(viewpoint, childClass);
                            if (iconSrcPath == null || iconSrcPath.trim().length() <= 0) continue;
                            String srcIconPath = "/" + dslvpProjectName + "/" + dslvpIconFolder + "/" + iconSrcPath;
                            this.CopyImageFromTo(srcIconPath, genClass.getCreateChildIconFileName(genModel, feature, childClass));
                        }
                    }
                }
            }
        }
    }

    private void CopyImageFromTo(String srcPath, String destPath) {
        Path sourcePath = new Path(srcPath);
        IFile sourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)sourcePath);
        if (sourceFile.exists()) {
            Path destinationPath = new Path(destPath);
            IFile destinationFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)destinationPath);
            try {
                destinationFile.setContents(sourceFile.getContents(), 256, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            ViewpointDslLogger.doLogWarning((String)("Unable to find the icon : " + srcPath));
        }
    }

    private String getIconSourcePath(Viewpoint viewpoint, GenClass childClass) {
        EList classList;
        Data data = viewpoint.getVP_Data();
        if (data != null && (classList = data.getVP_Classes()) != null) {
            for (Class iClass : classList) {
                String ecoreClassName = childClass.getEcoreClass().getName();
                if (!iClass.getName().toLowerCase().equals(ecoreClassName.toLowerCase())) continue;
                return iClass.getIcon();
            }
        }
        return null;
    }
}

