/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.sdk.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.natures.PDE;
import org.eclipse.pde.internal.core.plugin.PluginElement;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.viewpoint.sdk.Messages;
import org.polarsys.kitalpha.ad.viewpoint.sdk.manager.BundleManager;

public class OpenViewsAction
implements IMenuCreator,
IObjectActionDelegate {
    private Shell shell;
    private IProject project;
    private IWorkbenchPage activePage;
    private IWorkbenchPartSite site;
    private List<String> viewIds = new ArrayList<String>();
    private SelectionListener listener = new SelectionListener(){

        public void widgetSelected(SelectionEvent ee) {
            if (BundleManager.INSTANCE.isManaged(OpenViewsAction.this.project)) {
                try {
                    MenuItem menuItem = (MenuItem)ee.getSource();
                    OpenViewsAction.this.activePage.showView((String)menuItem.getData());
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)OpenViewsAction.this.shell, (String)Messages.ManageBundle_error_title3, (String)Messages.ManageBundle_error_message);
                    AD_Log.getDefault().logError(Messages.ManageBundle_error_title3, (Throwable)e);
                }
            } else {
                MessageDialog.openWarning((Shell)OpenViewsAction.this.shell, (String)"Warning", (String)"Install the bundle first!");
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.site = targetPart.getSite();
        this.activePage = this.site.getWorkbenchWindow().getActivePage();
        this.shell = this.site.getShell();
        action.setMenuCreator((IMenuCreator)this);
    }

    public void run(IAction action) {
        if (BundleManager.INSTANCE.isManaged(this.project)) {
            if (this.viewIds.isEmpty()) {
                MessageDialog.openError((Shell)this.shell, (String)Messages.ManageBundle_error_title3, (String)"There is no view to open.");
                return;
            }
            try {
                for (String id : this.viewIds) {
                    this.activePage.showView(id);
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.shell, (String)Messages.ManageBundle_error_title3, (String)Messages.ManageBundle_error_message);
                AD_Log.getDefault().logError(Messages.ManageBundle_error_title3, (Throwable)e);
            }
            return;
        }
        MessageDialog.openWarning((Shell)this.shell, (String)"Warning", (String)"Install the bundle first!");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IPluginModelBase findModel;
        IStructuredSelection sselect;
        this.project = null;
        if (selection instanceof IStructuredSelection && (sselect = (IStructuredSelection)selection).size() == 1) {
            if (sselect.getFirstElement() instanceof IProject) {
                this.project = (IProject)sselect.getFirstElement();
            } else if (sselect.getFirstElement() instanceof IJavaProject) {
                this.project = ((IJavaProject)sselect.getFirstElement()).getProject();
            }
        }
        if ((findModel = PluginRegistry.findModel((IProject)this.project)) != null) {
            this.initViewId(findModel);
            if (this.viewIds.isEmpty()) {
                action.setEnabled(false);
                return;
            }
        }
        if (this.project == null || BundleManager.INSTANCE.isManaged(this.project)) {
            action.setText("Open viewpoint view");
        } else {
            action.setText("[Not loaded] Open viewpoint view");
        }
        action.setEnabled(this.project != null && this.project.isAccessible() && PDE.hasPluginNature((IProject)this.project) && BundleManager.INSTANCE.isManaged(this.project));
    }

    private void initViewId(IPluginModelBase model) {
        this.viewIds.clear();
        IPluginExtension[] iPluginExtensionArray = model.getExtensions().getExtensions();
        int n = iPluginExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            if ("org.eclipse.ui.views".equals(extension.getPoint())) {
                IPluginObject[] iPluginObjectArray = extension.getChildren();
                int n3 = iPluginObjectArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    PluginElement elt;
                    IPluginObject children = iPluginObjectArray[n4];
                    if (children instanceof PluginElement && (elt = (PluginElement)children).getAttribute("resourceId") != null && elt.getAttribute("id") != null) {
                        this.viewIds.add(elt.getAttribute("id").getValue());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        Menu dynamicMenu = new Menu(parent);
        for (String id : this.viewIds) {
            MenuItem mi = new MenuItem(dynamicMenu, 8);
            mi.setText(id);
            mi.setData((Object)id);
            mi.addSelectionListener(this.listener);
            mi.setEnabled(this.activePage.findView(id) == null);
        }
        return dynamicMenu;
    }
}

