/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.polarsys.kitalpha.emde.extension.ExtendedModel;
import org.polarsys.kitalpha.emde.extension.Model;
import org.polarsys.kitalpha.emde.extension.ModelExtensionDescriptor;
import org.polarsys.kitalpha.emde.extension.registry.URIFactory;

public class ExtensibleModel
extends Model<ExtensibleModel> {
    private final Map<String, ExtendedModel> extendedModels = new HashMap<String, ExtendedModel>();
    private List<ExtensibleModel> inheritedExtensibleModels;
    private Map<String, ExtendedModel> inheritedExtendedModels;
    private final String path;
    private final String qualifiedName = this.path = this.getName();

    public ExtensibleModel(String name, URIFactory uriFactory) {
        super(name, uriFactory);
    }

    @Override
    public final String getPath() {
        return this.path;
    }

    public boolean equals(Object other_p) {
        return other_p instanceof ExtensibleModel && ((ExtensibleModel)other_p).getPath().equals(this.getPath());
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public SortedSet<ExtendedModel> getAllExtendedModels() {
        TreeSet<ExtendedModel> extended = new TreeSet<ExtendedModel>(this.extendedModels.values());
        if (this.inheritedExtendedModels == null) {
            this.getInheritedExtendedModels();
        }
        extended.addAll(this.inheritedExtendedModels.values());
        return Collections.unmodifiableSortedSet(extended);
    }

    public SortedSet<ExtendedModel> getExtendedModels() {
        return Collections.unmodifiableSortedSet(new TreeSet<ExtendedModel>(this.extendedModels.values()));
    }

    public SortedSet<ExtensibleModel> getInheritedExtensibleModels() {
        if (this.inheritedExtensibleModels == null) {
            this.inheritedExtensibleModels = new ArrayList<ExtensibleModel>();
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(this.getName());
            if (ePackage != null) {
                ArrayList<String> inheritedNamespaces = new ArrayList<String>();
                for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                    if (!(eClassifier instanceof EClass)) continue;
                    for (EClass superTypeEClass : ((EClass)eClassifier).getEAllSuperTypes()) {
                        String currentNamespace = superTypeEClass.getEPackage().getNsURI();
                        if (currentNamespace.equals(this.getName()) || inheritedNamespaces.contains(currentNamespace)) continue;
                        inheritedNamespaces.add(currentNamespace);
                    }
                }
                for (String inheritedNamespace : inheritedNamespaces) {
                    ExtensibleModel inheritedExtensibleModel = ModelExtensionDescriptor.INSTANCE.getExtensibleModel(inheritedNamespace);
                    if (inheritedExtensibleModel == null || this.inheritedExtensibleModels.contains(inheritedExtensibleModel)) continue;
                    this.inheritedExtensibleModels.add(inheritedExtensibleModel);
                }
            }
        }
        return Collections.unmodifiableSortedSet(new TreeSet<ExtensibleModel>(this.inheritedExtensibleModels));
    }

    public SortedSet<ExtendedModel> getInheritedExtendedModels() {
        if (this.inheritedExtendedModels == null) {
            this.inheritedExtendedModels = new HashMap<String, ExtendedModel>();
            for (ExtensibleModel extensibleModel : this.getInheritedExtensibleModels()) {
                for (ExtendedModel extendedModel : extensibleModel.getExtendedModels()) {
                    if (this.inheritedExtendedModels.containsKey(extendedModel.getName())) continue;
                    this.inheritedExtendedModels.put(extendedModel.getName(), extendedModel);
                }
            }
        }
        return Collections.unmodifiableSortedSet(new TreeSet<ExtendedModel>(this.inheritedExtendedModels.values()));
    }

    public ExtendedModel getExtendedModel(String extendedModelName) {
        if (extendedModelName == null || extendedModelName.trim().length() == 0) {
            return null;
        }
        return this.extendedModels.get(extendedModelName.trim());
    }

    public ExtendedModel getInheritedExtendedModel(String inheritedExtendedModelName) {
        if (inheritedExtendedModelName == null || inheritedExtendedModelName.trim().length() == 0) {
            return null;
        }
        if (this.inheritedExtendedModels == null) {
            this.getInheritedExtendedModels();
        }
        return this.inheritedExtendedModels.get(inheritedExtendedModelName.trim());
    }

    protected void addExtendedModel(ExtendedModel child) {
        if (!this.extendedModels.containsKey(child.getName())) {
            this.extendedModels.put(child.getName(), child);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("ExtensibleModel[name=");
        result.append(this.getName());
        result.append(", adapterFactory=");
        result.append(this.getURIFactory().getAdapterFactoryName());
        result.append(']');
        return result.toString();
    }
}

