/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.product;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.splash.BasicSplashHandler;
import org.osgi.framework.Version;

public class KitalphaSplashHandler
extends BasicSplashHandler {
    public void init(Shell splash) {
        int foregroundColorInteger;
        super.init(splash);
        String progressRectString = null;
        String messageRectString = null;
        String foregroundColorString = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            progressRectString = product.getProperty("startupProgressRect");
            messageRectString = product.getProperty("startupMessageRect");
            foregroundColorString = product.getProperty("startupForegroundColor");
        }
        Rectangle progressRect = StringConverter.asRectangle((String)progressRectString, (Rectangle)new Rectangle(1, 10, 452, 15));
        this.setProgressRect(progressRect);
        Rectangle messageRect = StringConverter.asRectangle((String)messageRectString, (Rectangle)new Rectangle(10, 35, 300, 15));
        this.setMessageRect(messageRect);
        try {
            foregroundColorInteger = Integer.parseInt(foregroundColorString, 16);
        }
        catch (Exception ex) {
            foregroundColorInteger = 7498662;
        }
        this.setForeground(new RGB((foregroundColorInteger & 0xFF0000) >> 16, (foregroundColorInteger & 0xFF00) >> 8, foregroundColorInteger & 0xFF));
        String buildId = "Unknown";
        String version = "Unknown";
        Object bufferedReader = null;
        Version version2 = product.getDefiningBundle().getVersion();
        StringBuilder builder = new StringBuilder();
        builder.append("Version : ");
        builder.append(version2.getMajor()).append('.');
        builder.append(version2.getMinor()).append('.');
        builder.append(version2.getMicro());
        builder.append("\n");
        builder.append("Build id : ");
        builder.append(version2.getQualifier());
        final String text = builder.toString();
        final Point buildIdPoint = new Point(240, 205);
        this.getContent().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(KitalphaSplashHandler.this.getForeground());
                FontData[] fontData = e.gc.getFont().getFontData();
                int i = 0;
                while (i < fontData.length) {
                    fontData[i].setHeight(12);
                    ++i;
                }
                Font newFont = new Font((Device)e.display, fontData);
                e.gc.setFont(newFont);
                e.gc.drawText(text, buildIdPoint.x, buildIdPoint.y, true);
            }
        });
    }
}

