/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.emfscheme;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceHelper;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;
import org.polarsys.kitalpha.resourcereuse.model.Location;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;

public class ModelReuseURIConverter
extends ExtensibleURIConverterImpl {
    private static Map<URI, org.eclipse.emf.ecore.resource.Resource> cache = new HashMap<URI, org.eclipse.emf.ecore.resource.Resource>();
    private static HashMap<URI, URI> logicalToPhysicalHashMapURI = new HashMap();
    private static final Logger logger = Logger.getLogger(ModelReuseURIConverter.class);
    private static final Pattern pattern;

    static {
        String IdPattern = "(Id=([A-Za-z0-9-.-[ \t]]*[A-Za-z0-9-.]))?";
        String whitespacePattern = "[ \t]*";
        String namePattern = "(Name=([A-Za-z0-9-.-[ \t]]*[A-Za-z0-9-.]))?";
        String domainPattern = "(Domain=([A-Za-z0-9-.-[ \t]]*[A-Za-z0-9-.]))?";
        String versionPattern = "(Version=([A-Za-z0-9-.]*))?";
        String tagsPattern = "(Tags=\\[([A-Za-z0-9-.-[ \t]-;]*[A-Za-z0-9-.-[ \t]])?\\])?";
        String globalPattern = "(Id=([A-Za-z0-9-.-[ \t]]*[A-Za-z0-9-.]))?[ \t]*(Name=([A-Za-z0-9-.-[ \t]]*[A-Za-z0-9-.]))?[ \t]*(Domain=([A-Za-z0-9-.-[ \t]]*[A-Za-z0-9-.]))?[ \t]*(Version=([A-Za-z0-9-.]*))?[ \t]*(Tags=\\[([A-Za-z0-9-.-[ \t]-;]*[A-Za-z0-9-.-[ \t]])?\\])?";
        pattern = Pattern.compile("(Id=([A-Za-z0-9-.-[ \t]]*[A-Za-z0-9-.]))?[ \t]*(Name=([A-Za-z0-9-.-[ \t]]*[A-Za-z0-9-.]))?[ \t]*(Domain=([A-Za-z0-9-.-[ \t]]*[A-Za-z0-9-.]))?[ \t]*(Version=([A-Za-z0-9-.]*))?[ \t]*(Tags=\\[([A-Za-z0-9-.-[ \t]-;]*[A-Za-z0-9-.-[ \t]])?\\])?");
    }

    public URI normalize(URI uri) {
        String scheme = uri.scheme();
        if (scheme != null && scheme.equals("modelreuse")) {
            try {
                String decodedURI = URLDecoder.decode(uri.toString(), "UTF-8");
                return this.translateReuseURIToPhysicalURI(URI.createURI((String)decodedURI));
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)new Status(4, "org.polarsys.kitalpha.resourcereuse.emfscheme", e.getMessage(), (Throwable)e));
            }
        }
        return super.normalize(uri);
    }

    private URI translateReuseURIToPhysicalURI(URI uri) {
        Set<URI> uris = cache.keySet();
        for (URI currentURI : uris) {
            org.eclipse.emf.ecore.resource.Resource currentResource = cache.get(currentURI);
            if (currentResource.isLoaded()) continue;
            cache.remove(currentURI);
        }
        if (cache.containsKey(uri)) {
            return logicalToPhysicalHashMapURI.get(uri);
        }
        List<String> criteriaSpecifications = this.findCriteriaSpecifications(uri);
        ResourceHelper resourceHelperPlatform = ResourceReuse.createPlatformHelper();
        ResourceHelper resourceHelperWorkspace = ResourceReuse.createWorkspaceHelper();
        SearchCriteria criteria = new SearchCriteria();
        criteria.setId(criteriaSpecifications.get(0));
        if (criteriaSpecifications.get(1).isEmpty()) {
            criteria.setName(null);
        } else {
            criteria.setName(criteriaSpecifications.get(1));
        }
        if (criteriaSpecifications.get(2).isEmpty()) {
            criteria.setDomain(null);
        } else {
            criteria.setDomain(criteriaSpecifications.get(2));
        }
        if (criteriaSpecifications.get(3).isEmpty()) {
            criteria.setVersion(null);
        } else {
            criteria.setVersion(criteriaSpecifications.get(3));
        }
        criteriaSpecifications.remove(0);
        criteriaSpecifications.remove(0);
        criteriaSpecifications.remove(0);
        criteriaSpecifications.remove(0);
        if (!criteriaSpecifications.isEmpty()) {
            for (String tag : criteriaSpecifications) {
                criteria.getTags().add(tag);
            }
        }
        criteriaSpecifications.clear();
        Resource resourceFoundWithModelreuseProtocol = null;
        URI modelResourceURI = null;
        Resource[] resourceSelectedWorkspace = resourceHelperWorkspace.getResources(criteria);
        Resource[] resourceSelectedPlatform = resourceHelperPlatform.getResources(criteria);
        Boolean resourceFound = false;
        if (resourceSelectedWorkspace.length != 0) {
            resourceFoundWithModelreuseProtocol = resourceSelectedWorkspace[0];
            resourceFound = true;
        } else if (resourceSelectedPlatform.length != 0) {
            Resource resource;
            resourceFoundWithModelreuseProtocol = resource = resourceSelectedPlatform[0];
            resourceFound = true;
        }
        if (resourceFound.booleanValue()) {
            Location location = resourceFoundWithModelreuseProtocol.getProviderLocation();
            String pathString = "";
            pathString = resourceFoundWithModelreuseProtocol.getPath();
            switch (location) {
                case PLATFORM: {
                    modelResourceURI = URI.createPlatformPluginURI((String)pathString, (boolean)true);
                    logicalToPhysicalHashMapURI.put(uri, modelResourceURI);
                    break;
                }
                case WORSPACE: {
                    modelResourceURI = URI.createPlatformResourceURI((String)pathString, (boolean)true);
                    logicalToPhysicalHashMapURI.put(uri, modelResourceURI);
                    break;
                }
            }
        }
        if (modelResourceURI != null) {
            return modelResourceURI;
        }
        throw new RuntimeException("EMF Scheme: Could not translate a logical URI " + uri.toString() + " to physical URI.");
    }

    private List<String> findCriteriaSpecifications(URI abstractURI) {
        ArrayList<String> criteriaSpecifications = new ArrayList<String>();
        String[] uriSegments = abstractURI.segments();
        String abstractURIString = uriSegments[0];
        Matcher m = ModelReuseURIConverter.getPattern().matcher(abstractURIString);
        m.matches();
        String id = m.group(2);
        String name = m.group(4);
        String domain = m.group(6);
        String version = m.group(8);
        String tag = m.group(10);
        int i = -1;
        if (id != null) {
            criteriaSpecifications.add(++i, id);
        }
        if (name != null) {
            criteriaSpecifications.add(++i, name);
        } else {
            criteriaSpecifications.add(++i, "");
        }
        if (domain != null) {
            criteriaSpecifications.add(++i, domain);
        } else {
            criteriaSpecifications.add(++i, "");
        }
        if (version != null) {
            criteriaSpecifications.add(++i, version);
        } else {
            criteriaSpecifications.add(++i, "");
        }
        if (tag != null && !tag.isEmpty()) {
            String[] split = tag.split(";");
            int length = split.length;
            int j = 0;
            while (j < length) {
                criteriaSpecifications.add(split[j]);
                ++j;
            }
        }
        return criteriaSpecifications;
    }

    private static Pattern getPattern() {
        return pattern;
    }
}

