/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.markers.CachedMarkerBuilder;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.Markers;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

class MarkerUpdateJob
extends Job {
    CachedMarkerBuilder builder;
    private boolean clean;
    private long lastUpdateTime = -1L;

    MarkerUpdateJob(CachedMarkerBuilder builder) {
        super(MarkerMessages.MarkerView_searching_for_markers);
        this.builder = builder;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(MarkerMessages.MarkerView_searching_for_markers, -1);
        this.buildMarkers(monitor);
        return Status.OK_STATUS;
    }

    void buildMarkers(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        LinkedList markerEntries = new LinkedList();
        boolean bl = this.clean = !this.clean(markerEntries, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.setTaskName(MarkerMessages.MarkerView_processUpdates);
        if (!this.processMarkerEntries(markerEntries, monitor)) {
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        this.builder.getUpdateScheduler().scheduleUIUpdate(150L);
        if (monitor.isCanceled()) {
            return;
        }
        this.builder.setBuilding(false);
        this.updateDone();
    }

    void updateDone() {
        this.lastUpdateTime = System.currentTimeMillis();
    }

    boolean clean(Collection markerEntries, IProgressMonitor monitor) {
        MarkerContentGenerator generator = this.builder.getGenerator();
        if (monitor.isCanceled() || generator == null) {
            return false;
        }
        this.builder.registerTypesToListener();
        return generator.generateMarkerEntries(markerEntries, monitor);
    }

    boolean processMarkerEntries(Collection markerEntries, IProgressMonitor monitor) {
        Markers markers = this.builder.getMarkers();
        if (monitor.isCanceled()) {
            return false;
        }
        return markers.updateWithNewMarkers(markerEntries, true, monitor);
    }

    public boolean shouldRun() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return false;
        }
        return IDEWorkbenchPlugin.getDefault().getBundle().getState() == 32 && this.builder.isActive();
    }

    public boolean belongsTo(Object family) {
        if (family.equals(this.builder.CACHE_UPDATE_FAMILY)) {
            return true;
        }
        if (family.equals(this.builder.MARKERSVIEW_UPDATE_JOB_FAMILY)) {
            return true;
        }
        return super.belongsTo(family);
    }

    boolean isClean() {
        return this.clean;
    }

    void setClean() {
        this.clean = true;
    }

    long getLastUpdateTime() {
        return this.lastUpdateTime;
    }
}

