/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.TaskFilter;

public class DialogTaskFilter
extends DialogMarkerFilter {
    private DescriptionGroup descriptionGroup;
    private PriorityGroup priorityGroup;
    private StatusGroup statusGroup;

    public DialogTaskFilter(Shell parentShell, TaskFilter[] filters) {
        super(parentShell, filters);
    }

    @Override
    protected void createAttributesArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(5, false);
        layout.verticalSpacing = 7;
        composite.setLayout((Layout)layout);
        this.descriptionGroup = new DescriptionGroup(composite);
        this.priorityGroup = new PriorityGroup(composite);
        this.statusGroup = new StatusGroup(composite);
    }

    @Override
    protected void updateFilterFromUI(MarkerFilter filter) {
        super.updateFilterFromUI(filter);
        TaskFilter taskFilter = (TaskFilter)filter;
        taskFilter.setContains(this.descriptionGroup.getContains());
        taskFilter.setDescription(this.descriptionGroup.getDescription().trim());
        taskFilter.setSelectByPriority(this.priorityGroup.isPriorityEnabled());
        int priority = 0;
        if (this.priorityGroup.isHighSelected()) {
            priority |= 4;
        }
        if (this.priorityGroup.isNormalSelected()) {
            priority |= 2;
        }
        if (this.priorityGroup.isLowSelected()) {
            priority |= 1;
        }
        taskFilter.setPriority(priority);
        taskFilter.setSelectByDone(this.statusGroup.isStatusEnabled());
        taskFilter.setDone(this.statusGroup.getDone());
    }

    @Override
    protected void updateUIWithFilter(MarkerFilter filter) {
        TaskFilter taskFilter = (TaskFilter)filter;
        this.descriptionGroup.setContains(taskFilter.getContains());
        this.descriptionGroup.setDescription(taskFilter.getDescription());
        this.priorityGroup.setEnabled(taskFilter.getSelectByPriority());
        int priority = taskFilter.getPriority();
        this.priorityGroup.setHighSelected((priority & 4) > 0);
        this.priorityGroup.setNormalSelected((priority & 2) > 0);
        this.priorityGroup.setLowSelected((priority & 1) > 0);
        this.statusGroup.setEnabled(taskFilter.getSelectByDone());
        this.statusGroup.setDone(taskFilter.getDone());
        super.updateUIWithFilter(filter);
    }

    @Override
    protected void updateEnabledState(boolean enabled) {
        super.updateEnabledState(enabled);
        this.descriptionGroup.updateEnablement(enabled);
        this.priorityGroup.updateEnablement(enabled);
        this.statusGroup.updateEnablement(enabled);
    }

    @Override
    protected void resetPressed() {
        this.descriptionGroup.setContains(true);
        this.descriptionGroup.setDescription("");
        this.priorityGroup.setEnabled(false);
        this.priorityGroup.setHighSelected(false);
        this.priorityGroup.setNormalSelected(false);
        this.priorityGroup.setLowSelected(false);
        this.statusGroup.setEnabled(false);
        this.statusGroup.setDone(false);
        super.resetPressed();
    }

    @Override
    protected MarkerFilter newFilter(String newName) {
        return new TaskFilter(newName);
    }

    private class DescriptionGroup {
        private Label descriptionLabel;
        private Combo combo;
        private Text description;
        private String contains = MarkerMessages.filtersDialog_contains;
        private String doesNotContain = MarkerMessages.filtersDialog_doesNotContain;

        public DescriptionGroup(Composite parent) {
            this.descriptionLabel = new Label(parent, 0);
            this.descriptionLabel.setFont(parent.getFont());
            this.descriptionLabel.setText(MarkerMessages.filtersDialog_descriptionLabel);
            this.combo = new Combo(parent, 8);
            this.combo.setFont(parent.getFont());
            this.combo.add(this.contains);
            this.combo.add(this.doesNotContain);
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DialogTaskFilter.this.updateForSelection();
                }
            });
            this.combo.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2 || e.detail == 4) {
                        e.doit = false;
                    }
                }
            });
            this.description = new Text(parent, 2052);
            this.description.setFont(parent.getFont());
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            this.description.setLayoutData((Object)data);
            this.description.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DialogTaskFilter.this.markDirty();
                }
            });
        }

        public boolean getContains() {
            return this.combo.getSelectionIndex() == this.combo.indexOf(this.contains);
        }

        public void setContains(boolean value) {
            if (value) {
                this.combo.select(this.combo.indexOf(this.contains));
            } else {
                this.combo.select(this.combo.indexOf(this.doesNotContain));
            }
        }

        public void setDescription(String text) {
            if (text == null) {
                this.description.setText("");
            } else {
                this.description.setText(text);
            }
        }

        public String getDescription() {
            return this.description.getText();
        }

        public void updateEnablement(boolean enabled) {
            this.descriptionLabel.setEnabled(enabled);
            this.combo.setEnabled(enabled);
            this.description.setEnabled(enabled);
        }
    }

    private class PriorityGroup {
        private Button enablementButton;
        private Button highButton;
        private Button normalButton;
        private Button lowButton;

        public PriorityGroup(Composite parent) {
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PriorityGroup.this.updateEnablement(true);
                    DialogTaskFilter.this.markDirty();
                }
            };
            this.enablementButton = new Button(parent, 32);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            this.enablementButton.setLayoutData((Object)data);
            this.enablementButton.setFont(parent.getFont());
            this.enablementButton.setText(MarkerMessages.filtersDialog_priorityLabel);
            this.enablementButton.addSelectionListener((SelectionListener)listener);
            this.highButton = new Button(parent, 32);
            this.highButton.setFont(parent.getFont());
            this.highButton.setText(MarkerMessages.filtersDialog_priorityHigh);
            this.highButton.setLayoutData((Object)new GridData(768));
            this.highButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DialogTaskFilter.this.updateForSelection();
                }
            });
            this.normalButton = new Button(parent, 32);
            this.normalButton.setFont(parent.getFont());
            this.normalButton.setText(MarkerMessages.filtersDialog_priorityNormal);
            this.normalButton.setLayoutData((Object)new GridData(768));
            this.normalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DialogTaskFilter.this.updateForSelection();
                }
            });
            this.lowButton = new Button(parent, 32);
            this.lowButton.setFont(parent.getFont());
            this.lowButton.setText(MarkerMessages.filtersDialog_priorityLow);
            this.lowButton.setLayoutData((Object)new GridData(768));
            this.lowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DialogTaskFilter.this.updateForSelection();
                }
            });
        }

        public boolean isPriorityEnabled() {
            return this.enablementButton.getSelection();
        }

        public void setEnabled(boolean enabled) {
            this.enablementButton.setSelection(enabled);
        }

        public boolean isHighSelected() {
            return this.highButton.getSelection();
        }

        public void setHighSelected(boolean selected) {
            this.highButton.setSelection(selected);
        }

        public boolean isNormalSelected() {
            return this.normalButton.getSelection();
        }

        public void setNormalSelected(boolean selected) {
            this.normalButton.setSelection(selected);
        }

        public boolean isLowSelected() {
            return this.lowButton.getSelection();
        }

        public void setLowSelected(boolean selected) {
            this.lowButton.setSelection(selected);
        }

        public void updateEnablement(boolean enabled) {
            this.enablementButton.setEnabled(enabled);
            this.highButton.setEnabled(enabled && this.isPriorityEnabled());
            this.normalButton.setEnabled(enabled && this.isPriorityEnabled());
            this.lowButton.setEnabled(enabled && this.isPriorityEnabled());
        }
    }

    private class StatusGroup {
        private Button enablementButton;
        private Button completeButton;
        private Button incompleteButton;

        public StatusGroup(Composite parent) {
            SelectionAdapter enablementListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StatusGroup.this.updateEnablement(true);
                    DialogTaskFilter.this.markDirty();
                }
            };
            this.enablementButton = new Button(parent, 32);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            this.enablementButton.setLayoutData((Object)data);
            this.enablementButton.setFont(parent.getFont());
            this.enablementButton.setText(MarkerMessages.filtersDialog_statusLabel);
            this.enablementButton.addSelectionListener((SelectionListener)enablementListener);
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            data = new GridData(768);
            data.horizontalSpan = 3;
            composite.setLayoutData((Object)data);
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StatusGroup.this.completeButton.setSelection(!StatusGroup.this.incompleteButton.getSelection());
                    StatusGroup.this.incompleteButton.setSelection(!StatusGroup.this.completeButton.getSelection());
                    DialogTaskFilter.this.markDirty();
                }
            };
            this.completeButton = new Button(composite, 16);
            this.completeButton.setFont(composite.getFont());
            this.completeButton.setText(MarkerMessages.filtersDialog_statusComplete);
            this.completeButton.addSelectionListener((SelectionListener)listener);
            this.incompleteButton = new Button(composite, 16);
            this.incompleteButton.setFont(composite.getFont());
            this.incompleteButton.setText(MarkerMessages.filtersDialog_statusIncomplete);
            this.incompleteButton.addSelectionListener((SelectionListener)listener);
        }

        public boolean isStatusEnabled() {
            return this.enablementButton.getSelection();
        }

        public void setEnabled(boolean enabled) {
            this.enablementButton.setSelection(enabled);
        }

        public boolean getDone() {
            return this.completeButton.getSelection();
        }

        public void setDone(boolean done) {
            this.completeButton.setSelection(done);
            this.incompleteButton.setSelection(!done);
        }

        public void updateEnablement(boolean enabled) {
            this.enablementButton.setEnabled(enabled);
            this.completeButton.setEnabled(this.isStatusEnabled() && enabled);
            this.incompleteButton.setEnabled(this.isStatusEnabled() && enabled);
        }
    }
}

