/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.importexport.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.equinox.internal.p2.importexport.IUDetail;
import org.eclipse.equinox.internal.p2.importexport.VersionIncompatibleException;
import org.eclipse.equinox.internal.p2.importexport.internal.Messages;
import org.eclipse.equinox.internal.p2.importexport.persistence.P2FConstants;
import org.eclipse.equinox.internal.p2.persistence.XMLParser;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2FParser
extends XMLParser
implements P2FConstants {
    static final VersionRange XML_TOLERANCE = new VersionRange(Version.createOSGi((int)1, (int)0, (int)0), true, Version.createOSGi((int)2, (int)0, (int)0), false);
    List<IUDetail> iusListed;

    public P2FParser(BundleContext context, String pluginId) {
        super(context, pluginId);
    }

    public void parse(File file) throws IOException {
        if (this.errorContext == null) {
            this.setErrorContext(file.getAbsolutePath());
        }
        this.parse(new FileInputStream(file));
    }

    public synchronized void parse(InputStream stream) throws IOException {
        this.status = null;
        try {
            try {
                this.getParser();
                P2FHandler p2fHandler = new P2FHandler();
                this.xmlReader.setContentHandler((ContentHandler)((Object)new P2FDocHandler("p2f", p2fHandler)));
                this.xmlReader.parse(new InputSource(stream));
            }
            catch (SAXException e) {
                throw new IOException(e.getMessage());
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e.getMessage());
            }
        }
        finally {
            stream.close();
        }
    }

    public List<IUDetail> getIUs() {
        if (this.iusListed == null) {
            this.iusListed = new ArrayList<IUDetail>();
        }
        return this.iusListed;
    }

    protected Object getRootObject() {
        return null;
    }

    protected String getErrorMessage() {
        return Messages.io_parseError;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class IUHandler
    extends XMLParser.AbstractHandler {
        private final String[] required;
        private final String[] optional;
        IInstallableUnit iu;
        private RepositoriesHandler repositoriesHandler;
        private List<IUDetail> ius;

        public IUHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List<IUDetail> ius) {
            super((XMLParser)P2FParser.this, (ContentHandler)parentHandler, "iu");
            this.required = new String[]{"id", "name", "version"};
            this.optional = new String[0];
            this.iu = null;
            String[] values = this.parseAttributes(attributes, this.required, this.optional);
            if (values[0] == null) {
                return;
            }
            MetadataFactory.InstallableUnitDescription desc = new MetadataFactory.InstallableUnitDescription();
            desc.setId(values[0]);
            desc.setProperty("org.eclipse.equinox.p2.name", values[1]);
            desc.setVersion(Version.create((String)values[2]));
            this.iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)desc);
            this.ius = ius;
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("repositories")) {
                this.repositoriesHandler = new RepositoriesHandler(this, attributes);
            }
        }

        protected void finished() {
            if (P2FParser.this.isValidXML()) {
                this.ius.add(new IUDetail(this.iu, this.repositoriesHandler.getRepositories()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class IUsHandler
    extends XMLParser.AbstractHandler {
        private final List<IUDetail> ius;

        public IUsHandler(ContentHandler parentHandler, Attributes attributes) {
            super((XMLParser)P2FParser.this, parentHandler, "ius");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.ius = size != null ? new ArrayList(new Integer(size)) : new ArrayList();
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("iu")) {
                new IUHandler(this, attributes, this.ius);
            } else {
                this.invalidElement(name, attributes);
            }
        }

        public List<IUDetail> getIUs() {
            return this.ius;
        }
    }

    private final class P2FDocHandler
    extends XMLParser.DocHandler {
        public P2FDocHandler(String rootName, XMLParser.RootHandler rootHandler) {
            super((XMLParser)P2FParser.this, rootName, rootHandler);
        }

        public void processingInstruction(String target, String data) {
            Version repositoryVersion;
            if ("p2f".equals(target) && !XML_TOLERANCE.isIncluded(repositoryVersion = P2FParser.this.extractPIVersion(target, data))) {
                throw new VersionIncompatibleException(NLS.bind((String)Messages.io_IncompatibleVersion, (Object)repositoryVersion, (Object)XML_TOLERANCE));
            }
        }
    }

    final class P2FHandler
    extends XMLParser.RootHandler {
        private final String[] required;
        private final String[] optional;
        private IUsHandler iusHandler;

        P2FHandler() {
            super((XMLParser)P2FParser.this);
            this.required = new String[0];
            this.optional = new String[0];
        }

        protected void handleRootAttributes(Attributes attributes) {
            this.parseAttributes(attributes, this.required, this.optional);
        }

        public void startElement(String name, Attributes attributes) {
            if ("ius".equals(name)) {
                if (this.iusHandler == null) {
                    this.iusHandler = new IUsHandler((ContentHandler)((Object)this), attributes);
                } else {
                    P2FParser.this.duplicateElement((XMLParser.AbstractHandler)this, name, attributes);
                }
            } else {
                this.invalidElement(name, attributes);
            }
        }

        protected void finished() {
            if (P2FParser.this.isValidXML() && this.iusHandler != null) {
                P2FParser.this.iusListed = this.iusHandler.getIUs();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RepositoriesHandler
    extends XMLParser.AbstractHandler {
        List<URI> uris;

        public RepositoriesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)P2FParser.this, (ContentHandler)parentHandler, "repositories");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.uris = size == null ? new ArrayList<URI>() : new ArrayList(new Integer(size));
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("repository")) {
                new RepositoryHandler(this, attributes, this.uris);
            }
        }

        public List<URI> getRepositories() {
            return this.uris;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RepositoryHandler
    extends XMLParser.AbstractHandler {
        private final String[] required;
        private final String[] optional;
        private URI referredRepo;
        private List<URI> uri;

        public RepositoryHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List<URI> uri) {
            super((XMLParser)P2FParser.this, (ContentHandler)parentHandler, "repository");
            this.required = new String[]{"location"};
            this.optional = new String[0];
            String[] values = this.parseAttributes(attributes, this.required, this.optional);
            if (values[0] == null) {
                return;
            }
            this.uri = uri;
            this.referredRepo = P2FParser.this.checkURI("repository", "location", values[0]);
        }

        public void startElement(String name, Attributes attributes) {
            P2FParser.this.checkCancel();
        }

        protected void finished() {
            if (this.referredRepo != null) {
                this.uri.add(this.referredRepo);
            }
        }
    }
}

