/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.ui.internal.interpreters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.IInterpreterInstallExtensionContainer;
import org.eclipse.dltk.internal.launching.InterpreterDefinitionsContainer;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LuaInterpreterDefinitionsContainer
extends InterpreterDefinitionsContainer {
    private static final String PATH_ATTR = "path";
    private static final String INTERPRETER_NAME_ATTR = "name";
    private static final String INTERPRETER_TAG = "interpreter";
    private static final String INTERPRETER_TYPE_TAG = "interpreterType";
    private static final String ID_ATTR = "id";
    private static final String NATURE_ATTR = "nature";
    private static final String ENVIRONMENT_ATTR = "environment";
    private static final String DEFAULT_INTERPRETER_TAG = "defaultInterpreter";
    private static final String INTERPRETER_SETTINGS_TAG = "interpreterSettings";
    private static final String VARIABLE_VALUE_ATTR = "variableValue";
    private static final String VARIABLE_NAME_ATTR = "variableName";
    private static final String LIBRARY_PATH_ATTR = "libraryPath";
    private static final String IARGS_ATTR = "iargs";
    private static final String ENVIRONMENT_VARIABLES_TAG = "environmentVariables";
    private static final String ENVIRONMENT_VARIABLE_TAG = "environmentVariable";
    private static final String LIBRARY_LOCATIONS_TAG = "libraryLocations";
    private static final String LIBRARY_LOCATION_TAG = "libraryLocation";
    private static final String ENVIRONMENT_ID = "environmentId";
    private static final String EXTENSIONS_TAG = "extensions";
    private List<IInterpreterInstall> fInterpreterList;
    private Map<ScriptRuntime.DefaultInterpreterEntry, String> fDefaultInterpreterInstallCompositeID;
    private Map<ScriptRuntime.DefaultInterpreterEntry, String> fDefaultInterpreterInstallConnectorTypeID;

    public LuaInterpreterDefinitionsContainer() {
        new ArrayList(10);
        this.fInterpreterList = new ArrayList<IInterpreterInstall>(10);
        this.fDefaultInterpreterInstallCompositeID = new HashMap<ScriptRuntime.DefaultInterpreterEntry, String>();
        this.fDefaultInterpreterInstallConnectorTypeID = new HashMap<ScriptRuntime.DefaultInterpreterEntry, String>();
    }

    public ScriptRuntime.DefaultInterpreterEntry[] getInterpreterNatures() {
        HashSet<ScriptRuntime.DefaultInterpreterEntry> s = new HashSet<ScriptRuntime.DefaultInterpreterEntry>(this.fDefaultInterpreterInstallCompositeID.keySet());
        for (IInterpreterInstall install : this.fInterpreterList) {
            s.add(new ScriptRuntime.DefaultInterpreterEntry(install.getNatureId(), install.getEnvironmentId()));
        }
        return s.toArray(new ScriptRuntime.DefaultInterpreterEntry[s.size()]);
    }

    public String getDefaultInterpreterInstallCompositeID(ScriptRuntime.DefaultInterpreterEntry nature) {
        return this.fDefaultInterpreterInstallCompositeID.get(nature);
    }

    public String[] getDefaultInterpreterInstallCompositeID() {
        Collection<String> ids = this.fDefaultInterpreterInstallCompositeID.values();
        return ids.toArray(new String[ids.size()]);
    }

    public void setDefaultInterpreterInstallCompositeID(ScriptRuntime.DefaultInterpreterEntry nature, String id) {
        if (id != null) {
            this.fDefaultInterpreterInstallCompositeID.put(nature, id);
        } else {
            this.fDefaultInterpreterInstallCompositeID.remove(nature);
        }
    }

    public String getDefaultInterpreterInstallConnectorTypeID(ScriptRuntime.DefaultInterpreterEntry nature) {
        return this.fDefaultInterpreterInstallConnectorTypeID.get(nature);
    }

    public void setDefaultInterpreterInstallConnectorTypeID(ScriptRuntime.DefaultInterpreterEntry nature, String id) {
        this.fDefaultInterpreterInstallConnectorTypeID.put(nature, id);
    }

    public String getAsXML() throws ParserConfigurationException, IOException, TransformerException {
        Document doc = DLTKLaunchingPlugin.getDocument();
        Element config = doc.createElement(INTERPRETER_SETTINGS_TAG);
        doc.appendChild(config);
        ArrayList<ScriptRuntime.DefaultInterpreterEntry> keys = new ArrayList<ScriptRuntime.DefaultInterpreterEntry>();
        keys.addAll(this.fDefaultInterpreterInstallCompositeID.keySet());
        Collections.sort(keys, new DefaultInterpreterComparator());
        for (ScriptRuntime.DefaultInterpreterEntry entry : keys) {
            Element defaulte = doc.createElement(DEFAULT_INTERPRETER_TAG);
            config.appendChild(defaulte);
            defaulte.setAttribute(NATURE_ATTR, entry.getNature());
            defaulte.setAttribute(ENVIRONMENT_ATTR, entry.getEnvironment());
            defaulte.setAttribute(ID_ATTR, this.fDefaultInterpreterInstallCompositeID.get(entry));
        }
        ArrayList<ScriptRuntime.DefaultInterpreterEntry> keys2 = new ArrayList<ScriptRuntime.DefaultInterpreterEntry>();
        keys2.addAll(this.fDefaultInterpreterInstallConnectorTypeID.keySet());
        Collections.sort(keys2, new DefaultInterpreterComparator());
        for (ScriptRuntime.DefaultInterpreterEntry entry : keys2) {
            Element defaulte = doc.createElement("defaultInterpreterConnector");
            config.appendChild(defaulte);
            defaulte.setAttribute(NATURE_ATTR, entry.getNature());
            defaulte.setAttribute(ENVIRONMENT_ATTR, entry.getEnvironment());
            defaulte.setAttribute(ID_ATTR, this.fDefaultInterpreterInstallConnectorTypeID.get(entry));
        }
        Set InterpreterInstallTypeSet = this.getInterpreterTypeToInterpreterMap().keySet();
        for (IInterpreterInstallType InterpreterInstallType : InterpreterInstallTypeSet) {
            Element InterpreterTypeElement = this.interpreterTypeAsElement(doc, InterpreterInstallType);
            config.appendChild(InterpreterTypeElement);
        }
        return DLTKLaunchingPlugin.serializeDocument((Document)doc);
    }

    private Element interpreterTypeAsElement(Document doc, IInterpreterInstallType InterpreterType) {
        Element element = doc.createElement(INTERPRETER_TYPE_TAG);
        element.setAttribute(ID_ATTR, InterpreterType.getId());
        List InterpreterList = (List)this.getInterpreterTypeToInterpreterMap().get(InterpreterType);
        for (IInterpreterInstall Interpreter : InterpreterList) {
            Element InterpreterElement = this.interpreterAsElement(doc, Interpreter);
            element.appendChild(InterpreterElement);
        }
        return element;
    }

    private Element interpreterAsElement(Document doc, IInterpreterInstall interpreter) {
        String extensions;
        String interpreterArgs;
        EnvironmentVariable[] environmentVariables;
        Element element = doc.createElement(INTERPRETER_TAG);
        element.setAttribute(ID_ATTR, interpreter.getId());
        element.setAttribute(INTERPRETER_NAME_ATTR, interpreter.getName());
        element.setAttribute(ENVIRONMENT_ID, interpreter.getInstallLocation().getEnvironmentId());
        String installPath = "";
        IFileHandle installLocation = interpreter.getRawInstallLocation();
        if (installLocation != null) {
            installPath = installLocation.getPath().toPortableString();
        }
        element.setAttribute(PATH_ATTR, installPath);
        LibraryLocation[] libraryLocations = interpreter.getLibraryLocations();
        if (libraryLocations != null) {
            Element libLocationElement = LuaInterpreterDefinitionsContainer.libraryLocationsAsElement(doc, libraryLocations);
            element.appendChild(libLocationElement);
        }
        if ((environmentVariables = interpreter.getEnvironmentVariables()) != null) {
            Element environmentVariableElement = LuaInterpreterDefinitionsContainer.environmentVariablesAsElement(doc, environmentVariables);
            element.appendChild(environmentVariableElement);
        }
        if ((interpreterArgs = interpreter.getInterpreterArgs()) != null && interpreterArgs.length() > 0) {
            element.setAttribute(IARGS_ATTR, interpreterArgs);
        }
        if (interpreter instanceof IInterpreterInstallExtensionContainer && (extensions = ((IInterpreterInstallExtensionContainer)interpreter).saveExtensions()) != null && extensions.length() != 0) {
            Element extensionsElement = doc.createElement(EXTENSIONS_TAG);
            extensionsElement.appendChild(doc.createCDATASection(extensions));
            element.appendChild(extensionsElement);
        }
        return element;
    }

    private static Element libraryLocationsAsElement(Document doc, LibraryLocation[] locations) {
        Element root = doc.createElement(LIBRARY_LOCATIONS_TAG);
        int i = 0;
        while (i < locations.length) {
            Element element = doc.createElement(LIBRARY_LOCATION_TAG);
            element.setAttribute(LIBRARY_PATH_ATTR, locations[i].getLibraryPath().toString());
            root.appendChild(element);
            ++i;
        }
        return root;
    }

    private static Element environmentVariablesAsElement(Document doc, EnvironmentVariable[] variables) {
        Element root = doc.createElement(ENVIRONMENT_VARIABLES_TAG);
        int i = 0;
        while (i < variables.length) {
            Element element = doc.createElement(ENVIRONMENT_VARIABLE_TAG);
            element.setAttribute(VARIABLE_NAME_ATTR, variables[i].getName());
            element.setAttribute(VARIABLE_VALUE_ATTR, variables[i].getValue());
            root.appendChild(element);
            ++i;
        }
        return root;
    }

    private final class DefaultInterpreterComparator
    implements Comparator<ScriptRuntime.DefaultInterpreterEntry> {
        private DefaultInterpreterComparator() {
        }

        @Override
        public int compare(ScriptRuntime.DefaultInterpreterEntry entry0, ScriptRuntime.DefaultInterpreterEntry entry1) {
            String k0 = String.valueOf(entry0.getEnvironment()) + ":" + entry0.getNature();
            String k1 = String.valueOf(entry1.getEnvironment()) + ":" + entry1.getNature();
            return k0.compareTo(k1);
        }
    }
}

