/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.internal.ui.search.SearchMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.actions.FindDeclarationsAction;
import org.eclipse.dltk.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.ui.search.QuerySpecification;
import org.eclipse.ui.IWorkbenchSite;

public class FindDeclarationsInProjectAction
extends FindDeclarationsAction {
    public FindDeclarationsInProjectAction(IDLTKLanguageToolkit toolkit, IWorkbenchSite site) {
        super(toolkit, site);
    }

    public FindDeclarationsInProjectAction(IDLTKLanguageToolkit toolkit, ScriptEditor editor) {
        super(toolkit, editor);
    }

    void init() {
        this.setText(SearchMessages.Search_FindDeclarationsInProjectAction_label);
        this.setToolTipText(SearchMessages.Search_FindDeclarationsInProjectAction_tooltip);
        this.setImageDescriptor(DLTKPluginImages.DESC_OBJS_SEARCH_DECL);
        if (DLTKCore.DEBUG) {
            System.out.println("TODO: Add help support here...");
        }
    }

    QuerySpecification createQuery(IModelElement element) throws ModelException {
        String description;
        IDLTKSearchScope scope;
        DLTKSearchScopeFactory factory = DLTKSearchScopeFactory.getInstance();
        ScriptEditor editor = this.getEditor();
        boolean isInsideInterpreterEnvironment = true;
        if (editor != null) {
            scope = factory.createProjectSearchScope(editor.getEditorInput(), isInsideInterpreterEnvironment);
            description = factory.getProjectScopeDescription(editor.getEditorInput(), isInsideInterpreterEnvironment);
        } else {
            scope = factory.createProjectSearchScope(element.getScriptProject(), isInsideInterpreterEnvironment);
            description = factory.getProjectScopeDescription(element.getScriptProject(), isInsideInterpreterEnvironment);
        }
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

