/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class ProvUIActivator
extends AbstractUIPlugin {
    private static BundleContext context;
    private static PackageAdmin packageAdmin;
    private static ServiceReference<?> packageAdminRef;
    private static ProvUIActivator plugin;
    public static final String PLUGIN_ID = "org.eclipse.equinox.p2.ui";
    private ProvisioningSession session;
    private ProvisioningUI ui;

    static {
        packageAdmin = null;
        packageAdminRef = null;
    }

    public static BundleContext getContext() {
        return context;
    }

    public static ProvUIActivator getDefault() {
        return plugin;
    }

    public static Bundle getBundle(String symbolicName) {
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        context = bundleContext;
        packageAdminRef = bundleContext.getServiceReference(PackageAdmin.class.getName());
        packageAdmin = (PackageAdmin)bundleContext.getService(packageAdminRef);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            Job.getJobManager().cancel(LoadMetadataRepositoryJob.LOAD_FAMILY);
            Job.getJobManager().join(LoadMetadataRepositoryJob.LOAD_FAMILY, (IProgressMonitor)new NullProgressMonitor());
            plugin = null;
            context = null;
            this.ui = null;
        }
        finally {
            super.stop(bundleContext);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        this.createImageDescriptor("obj/metadata_repo_obj.gif", reg);
        this.createImageDescriptor("obj/artifact_repo_obj.gif", reg);
        this.createImageDescriptor("obj/iu_obj.gif", reg);
        this.createImageDescriptor("obj/iu_disabled_obj.gif", reg);
        this.createImageDescriptor("obj/iu_update_obj.gif", reg);
        this.createImageDescriptor("obj/added_overlay.gif", reg);
        this.createImageDescriptor("obj/removed_overlay.gif", reg);
        this.createImageDescriptor("obj/iu_upgraded.png", reg);
        this.createImageDescriptor("obj/iu_downgraded.png", reg);
        this.createImageDescriptor("obj/iu_patch_obj.gif", reg);
        this.createImageDescriptor("obj/iu_disabled_patch_obj.gif", reg);
        this.createImageDescriptor("obj/category_obj.gif", reg);
        this.createImageDescriptor("obj/profile_obj.gif", reg);
        this.createImageDescriptor("obj/iu_info.gif", reg);
        this.createImageDescriptor("obj/iu_add.gif", reg);
        this.createImageDescriptor("obj/iu_remove.gif", reg);
        this.createImageDescriptor("obj/iu_update_obj.gif", reg);
        this.createImageDescriptor("obj/iu_notadd.gif", reg);
        this.createImageDescriptor("wizban/install_wiz.gif", reg);
        this.createImageDescriptor("wizban/revert_wiz.gif", reg);
        this.createImageDescriptor("wizban/uninstall_wiz.gif", reg);
        this.createImageDescriptor("wizban/update_wiz.gif", reg);
    }

    private void createImageDescriptor(String id, ImageRegistry reg) {
        URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path("$nl$/icons/" + id), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(id, desc);
    }

    public ProvisioningUI getProvisioningUI() {
        if (Tracing.DEBUG_DEFAULT_UI) {
            Tracing.debug((String)"Falling back to default provisioning UI");
        }
        if (this.ui == null) {
            IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)ProvUIActivator.getContext(), (String)IProvisioningAgent.SERVICE_NAME);
            this.session = new ProvisioningSession(agent);
            Policy policy = (Policy)ServiceHelper.getService((BundleContext)ProvUIActivator.getContext(), (String)Policy.class.getName());
            if (policy == null) {
                policy = new Policy();
            }
            this.ui = new ProvisioningUI(this.session, "_SELF_", policy);
        }
        return this.ui;
    }
}

