/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.commons.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.koneki.commons.ui.ColorRegistry;
import org.eclipse.koneki.commons.ui.UIUtil;
import org.eclipse.koneki.commons.ui.dialogs.IShellTitleBarListener;
import org.eclipse.koneki.commons.ui.dialogs.ShellFollower;
import org.eclipse.koneki.commons.ui.dialogs.ShellTitleBar;
import org.eclipse.koneki.commons.ui.dialogs.ShellTitleBarSettings;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CDialog
extends Dialog
implements IShellTitleBarListener {
    public static final String BACKGROUND_COLOR = "255,255,255";
    public static final String SHELL_BACKGROUND_COLOR = "74,75,73";
    public static final String TITLE_BAR_COLOR = "255, 255, 255";
    private static final int DEFAULT_STYLE = 557064;
    private static final int TITLE_HEIGHT = 24;
    private Shell shell;
    private UIUtil.FadeJob fadeJob;
    private boolean supportsFading;
    private boolean fadingEnabled;
    private boolean isMoveable;
    private boolean isCloseable = true;
    private boolean isParentFollower;
    private int relativeLocation = 0x1000000;
    private ShellFollower parentFollower;
    private int verticalOffset = 0;
    private int horizontalOffset = 0;
    private Image titleImage;
    private int finalAlpha = 255;
    private ShellTitleBar titleBar;

    public CDialog(Display display) {
        this(display, 557064);
    }

    public CDialog(Display display, int style) {
        this(new Shell(display), style);
    }

    public CDialog(Shell parentShell) {
        this(parentShell, 557064);
    }

    public CDialog(Shell parentShell, int style) {
        super(parentShell);
        this.setShellStyle(style);
    }

    public boolean isFadingEnabled() {
        return this.fadingEnabled;
    }

    public void setFadingEnabled(boolean fadingEnabled) {
        this.fadingEnabled = fadingEnabled;
    }

    public void setMoveable(boolean moveable) {
        this.isMoveable = moveable;
    }

    public boolean isMoveable() {
        return this.isMoveable;
    }

    public void setParentFollower(boolean parentFollower) {
        this.isParentFollower = parentFollower;
    }

    public boolean isParentFollower() {
        return this.isParentFollower;
    }

    public void setRelativeLocation(int relativeLocation) {
        this.relativeLocation = relativeLocation;
    }

    public int getRelativeLocation() {
        return this.relativeLocation;
    }

    public void setVerticalOffset(int offset) {
        this.verticalOffset = offset;
    }

    public int getVerticalOffset() {
        return this.verticalOffset;
    }

    public void setHorizontalOffset(int offset) {
        this.horizontalOffset = offset;
    }

    public int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setTitleImage(Image image) {
        this.titleImage = image;
    }

    public Image getTitleImage() {
        return this.titleImage;
    }

    public void setFinalAlpha(int finalAlpha) {
        this.finalAlpha = finalAlpha;
    }

    public int getFinalAlpha() {
        return this.finalAlpha;
    }

    protected void createContentArea(Composite parent) {
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.shell = newShell;
    }

    public void create() {
        super.create();
        this.titleBar.initilize();
    }

    public int open() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.shell = null;
            this.create();
        }
        this.constrainShellSize();
        this.supportsFading = this.isFadingEnabled() ? UIUtil.setAlpha(this.shell, 0) : false;
        this.shell.setVisible(true);
        if (this.supportsFading) {
            this.fadeJob = UIUtil.fadeIn(this.shell, this.getFinalAlpha(), new UIUtil.IFadeListener(){

                @Override
                public void faded(Shell fShell, int alpha) {
                    if (fShell.isDisposed()) {
                        return;
                    }
                }
            });
        }
        if (this.isParentFollower()) {
            this.followParent();
        }
        this.setDefaultLocation();
        return super.open();
    }

    protected void setDefaultLocation() {
        UIUtil.setDefaultLocation(this.getParentShell(), this.getShell(), this.getRelativeLocation(), this.getHorizontalOffset(), this.getVerticalOffset());
    }

    private void followParent() {
        this.parentFollower = new ShellFollower(this.getParentShell(), this.getShell());
    }

    protected Control createContents(Composite parent) {
        ShellTitleBarSettings settings = new ShellTitleBarSettings(ColorRegistry.COLOR_WHITE, ColorRegistry.getInstance().get(SHELL_BACKGROUND_COLOR), ColorRegistry.getInstance().get(TITLE_BAR_COLOR), ColorRegistry.getInstance().get(TITLE_BAR_COLOR), 24);
        settings.setMoveable(this.isMoveable());
        settings.setMinimizeable(false);
        settings.setCloseable(this.isCloseable());
        settings.setTitleImage(this.getTitleImage());
        this.titleBar = new ShellTitleBar(this.shell, settings, this);
        Composite contentComposite = new Composite(parent, 524288);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)contentComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(contentComposite);
        this.createContentArea(contentComposite);
        return contentComposite;
    }

    public boolean close() {
        if (this.parentFollower != null) {
            this.parentFollower.dispose();
        }
        if (this.fadeJob != null) {
            this.fadeJob.cancelAndWait(false);
        }
        return super.close();
    }

    @Override
    public void maximizeSelected() {
        this.shell.setMaximized(true);
    }

    @Override
    public void minimizeSelected() {
        this.shell.setMinimized(true);
    }

    @Override
    public void closeSelected() {
        this.close();
        this.setReturnCode(1);
    }

    @Override
    public void showHelpSelected() {
    }

    public void setCloseable(boolean closeable) {
        this.isCloseable = closeable;
    }

    public boolean isCloseable() {
        return this.isCloseable;
    }

    public ShellTitleBar getTitleBar() {
        return this.titleBar;
    }
}

