/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.dashboard.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.koneki.commons.ui.ANWRTToolkit;
import org.eclipse.koneki.commons.ui.ColorRegistry;
import org.eclipse.koneki.dashboard.ui.AbstractDashboardPage;
import org.eclipse.koneki.dashboard.ui.Dashboard;
import org.eclipse.koneki.dashboard.ui.DashboardOutlineItem;
import org.eclipse.koneki.dashboard.ui.extension.DashboardInstance;
import org.eclipse.koneki.dashboard.ui.extension.DashboardsManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class DashboardOutline
implements IContentOutlinePage {
    private ANWRTToolkit toolkit;
    private Composite baseComposite;
    private Map<AbstractDashboardPage, DashboardOutlineItem> items4Pages;
    private DashboardOutlineItem lastSelection;
    private Dashboard dashboard;
    private List<ISelectionChangedListener> listeners;
    private ItemSelectionListener itemSelectionListener;
    private ScrolledComposite scrolledComposite;

    public DashboardOutline(Dashboard dashboard) {
        this.dashboard = dashboard;
        this.toolkit = dashboard.getToolkit();
        this.items4Pages = new HashMap<AbstractDashboardPage, DashboardOutlineItem>();
        this.listeners = new ArrayList<ISelectionChangedListener>();
        this.itemSelectionListener = new ItemSelectionListener();
    }

    public void createControl(Composite parent) {
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setShowFocusedControl(true);
        this.baseComposite = this.toolkit.createComposite((Composite)this.scrolledComposite);
        this.baseComposite.setBackground(ColorRegistry.COLOR_WHITE);
        GridLayoutFactory.swtDefaults().spacing(5, 30).applyTo(this.baseComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.baseComposite);
        String productId = Platform.getProduct().getId();
        DashboardInstance dashboardInstance = DashboardsManager.getInstance().getDashboard4Product(productId);
        for (AbstractDashboardPage page : dashboardInstance.getPages()) {
            DashboardOutlineItem dashboardOutlineItem = new DashboardOutlineItem(this.baseComposite, page);
            dashboardOutlineItem.addSelectionListener((SelectionListener)this.itemSelectionListener);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)dashboardOutlineItem);
            this.items4Pages.put(page, dashboardOutlineItem);
        }
        this.scrolledComposite.setContent((Control)this.baseComposite);
        Point point = this.baseComposite.computeSize(-1, -1);
        this.baseComposite.setSize(point);
        this.scrolledComposite.setMinSize(point);
    }

    public void dispose() {
        this.scrolledComposite.dispose();
    }

    public Control getControl() {
        return this.scrolledComposite;
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        this.baseComposite.setFocus();
        this.setSelection(this.dashboard.getSelection());
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public ISelection getSelection() {
        if (this.lastSelection == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this.lastSelection.getDashboardPage());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        AbstractDashboardPage page;
        DashboardOutlineItem outlineItem;
        Object firstElement = ((IStructuredSelection)selection).getFirstElement();
        if (firstElement instanceof AbstractDashboardPage && (outlineItem = this.items4Pages.get(page = (AbstractDashboardPage)firstElement)) != null) {
            if (this.lastSelection != null) {
                this.lastSelection.setSelected(false);
            }
            outlineItem.setSelected(true);
            this.lastSelection = outlineItem;
            this.lastSelection.setFocus();
        }
    }

    public void fireSelectionChanged(AbstractDashboardPage page) {
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection((Object)page)));
        }
    }

    private class ItemSelectionListener
    extends SelectionAdapter {
        private ItemSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            DashboardOutlineItem item = (DashboardOutlineItem)e.widget;
            AbstractDashboardPage page = item.getDashboardPage();
            DashboardOutline.this.fireSelectionChanged(page);
        }
    }
}

