/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.tema.core;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class I18N {
    private static I18N I18N_INSTANCE;
    private ResourceBundle _resourceBundle;

    private I18N() {
        try {
            this._resourceBundle = ResourceBundle.getBundle("org.eclipse.koneki.tema.core.resources");
        }
        catch (MissingResourceException missingResourceException) {
            this._resourceBundle = null;
        }
    }

    public static I18N getDefault() {
        if (I18N_INSTANCE == null) {
            I18N_INSTANCE = new I18N();
        }
        return I18N_INSTANCE;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = I18N.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getResourceString(String key, String[] args) {
        String text = I18N.getResourceString(key);
        return MessageFormat.format(text, args);
    }

    public static String getResourceString(String key, String arg) {
        return I18N.getResourceString(key, new String[]{arg});
    }

    public ResourceBundle getResourceBundle() {
        return this._resourceBundle;
    }
}

