/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.tema.core.internal.model;

import java.util.regex.Pattern;
import org.eclipse.koneki.tema.core.I18N;
import org.eclipse.koneki.tema.core.model.IParameter;

public class Parameter
implements IParameter {
    private String _name;
    private String _displayName;
    private String _value;
    private String _default;
    private String _description;
    private Pattern _pattern;
    private String _type;

    public Parameter(String name) {
        this.setName(name);
    }

    public Parameter(String name, String defaultValue, String description) {
        this(name);
        this.setDefaultValue(defaultValue);
        this.setDescription(description);
    }

    public Parameter(String name, String displayName, String defaultValue, String description) {
        this(name, defaultValue, description);
        this.setDisplayName(displayName);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException(I18N.getResourceString("exceptions.attribute.mandatory", new String[]{this.getClass().toString(), "name"}));
        }
        this._name = name;
    }

    @Override
    public String getDisplayName() {
        return this._displayName != null ? this._displayName : this.getName();
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    @Override
    public String getValue() {
        return this._value;
    }

    @Override
    public void setValue(String value) {
        this._value = value;
    }

    @Override
    public String getDefaultValue() {
        return this._default;
    }

    public void setDefaultValue(String value) {
        this._default = value;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setRegExp(String regExp) {
        if (regExp != null && regExp.length() != 0) {
            this._pattern = Pattern.compile(regExp);
        }
    }

    @Override
    public boolean isValid(String value) {
        if (this._pattern != null) {
            return this._pattern.matcher(value).matches();
        }
        return true;
    }

    @Override
    public void setType(String type) {
        this._type = type;
    }

    @Override
    public String getType() {
        return this._type;
    }
}

