/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.tema.core.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.koneki.tema.core.TemaCoreActivator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class SPath {
    public static final String INDEXES_NODE_TAG = "indexes";
    public static final String TEMPLATE_NODE_TAG = "template";

    private SPath() {
    }

    public static Element getElementAt(Node fromElt, String name, int index) {
        Element result = null;
        NamedElementIterator iter = new NamedElementIterator(fromElt, name);
        int curIndex = 0;
        while (iter.hasNext() && curIndex != index) {
            ++curIndex;
            result = (Element)iter.next();
        }
        if (curIndex != index) {
            result = null;
        }
        return result;
    }

    public static Node getNode(Element fromElt, String path) {
        StringTokenizer st = new StringTokenizer(path, "/");
        Element elt = fromElt;
        while (st.hasMoreTokens() && elt != null) {
            String part = st.nextToken();
            if ("..".equals(part)) {
                elt = (Element)elt.getParentNode();
                continue;
            }
            if (part.charAt(0) == '@') {
                part = part.substring(1);
                return elt.getAttributeNode(part);
            }
            if (part.indexOf(91) != -1) {
                if (part.endsWith("]")) {
                    Integer index;
                    String indexStr = part.substring(part.indexOf(91) + 1, part.length() - 1);
                    part = part.substring(0, part.indexOf(91));
                    try {
                        index = new Integer(indexStr);
                    }
                    catch (NumberFormatException ex) {
                        TemaCoreActivator.log(ex);
                        return null;
                    }
                    if (index <= 0) {
                        TemaCoreActivator.log(new Exception(" Values <= 0 are not allowed for XPath indexes : " + part));
                        return null;
                    }
                    elt = SPath.getElementAt(elt, part, index);
                    continue;
                }
                return null;
            }
            NamedElementIterator iter = new NamedElementIterator((Node)elt, part);
            elt = iter.hasNext() ? (Element)iter.next() : null;
        }
        return elt;
    }

    public static Iterator<?> getIterator(Element contextElt, String path) {
        String lastPath;
        if (path == null) {
            return new ElementIterator(contextElt);
        }
        int pos = path.lastIndexOf(47);
        if (pos >= 0) {
            contextElt = (Element)SPath.getNode(contextElt, path.substring(0, pos));
            lastPath = path.substring(pos + 1);
        } else {
            lastPath = path;
        }
        if (contextElt != null) {
            if ("*".equals(lastPath)) {
                return new ElementIterator(contextElt);
            }
            return new NamedElementIterator((Node)contextElt, lastPath);
        }
        return new EmptyIterator();
    }

    public static String getValue(Element contextElt, String path) {
        return SPath.getValue(contextElt, path, null);
    }

    public static String getValue(Element contextElt, String path, String defaultValue) {
        Node node = SPath.getNode(contextElt, path);
        if (node != null) {
            if (node.getNodeType() == 1) {
                return SPath.getValue((Element)node);
            }
            return node.getNodeValue();
        }
        return defaultValue;
    }

    public static String getValue(Element element) {
        TextIterator iter = new TextIterator(element);
        if (iter.hasNext()) {
            return ((Node)iter.next()).getNodeValue();
        }
        return null;
    }

    public static void setValue(Node element, String path, String value) {
        String elementPath;
        String attributePath;
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            if (path.charAt(0) == '@') {
                attributePath = path.substring(1);
                elementPath = null;
            } else {
                attributePath = null;
                elementPath = path;
            }
        } else if (path.charAt(pos + 1) == '@') {
            attributePath = path.substring(pos + 2);
            elementPath = path.substring(0, pos);
        } else {
            attributePath = null;
            elementPath = path;
        }
        Node currentElt = element;
        boolean elementIsNew = false;
        if (elementPath != null) {
            StringTokenizer stok = new StringTokenizer(elementPath, "/");
            while (stok.hasMoreTokens()) {
                String name = stok.nextToken();
                int index = 1;
                if (name.indexOf(91) != -1 && name.endsWith("]")) {
                    String indexStr = name.substring(name.indexOf(91) + 1, name.length() - 1);
                    name = name.substring(0, name.indexOf(91));
                    try {
                        Integer indexObject = new Integer(indexStr);
                        if (indexObject <= 0) {
                            TemaCoreActivator.log(new Exception("Values <= 0 are not allowed for XPath indexes : " + name));
                        } else {
                            index = indexObject;
                        }
                    }
                    catch (NumberFormatException ex) {
                        TemaCoreActivator.log(ex);
                    }
                }
                Element newElt = null;
                if (!elementIsNew) {
                    newElt = SPath.getElementAt(currentElt, name, index);
                }
                if (newElt == null) {
                    if (index > 1) {
                        int brotherIndex = 1;
                        while (brotherIndex < index) {
                            Element brotherElt = SPath.getElementAt(currentElt, name, brotherIndex);
                            if (brotherElt == null) {
                                brotherElt = currentElt.getOwnerDocument().createElement(name);
                                currentElt.appendChild(brotherElt);
                            }
                            ++brotherIndex;
                        }
                    }
                    newElt = currentElt.getOwnerDocument().createElement(name);
                    currentElt.appendChild(newElt);
                    currentElt = newElt;
                    elementIsNew = true;
                    continue;
                }
                currentElt = newElt;
            }
        }
        if (attributePath == null) {
            if (!elementIsNew) {
                NodeList list = currentElt.getChildNodes();
                while (list.getLength() != 0) {
                    currentElt.removeChild(list.item(0));
                }
            }
            if (value != null) {
                Text text = currentElt.getOwnerDocument().createTextNode(value);
                currentElt.appendChild(text);
            }
        } else if (value != null) {
            ((Element)currentElt).setAttribute(attributePath, value);
        } else if (!elementIsNew) {
            ((Element)currentElt).removeAttribute(attributePath);
        }
    }

    public static void computeIndexedDefaultData(Node defaultData) {
        Element indexes = null;
        Element template = null;
        NodeListIterator iter = new NamedElementIterator(defaultData, INDEXES_NODE_TAG);
        if (iter.hasNext()) {
            indexes = (Element)iter.next();
            defaultData.removeChild(indexes);
        }
        if ((iter = new NamedElementIterator(defaultData, TEMPLATE_NODE_TAG)).hasNext()) {
            template = (Element)iter.next();
            defaultData.removeChild(template);
        }
        if (template != null) {
            if (indexes == null) {
                defaultData.appendChild(template);
            } else {
                Element result = SPath.createIndexedElement(template, indexes);
                iter = new ElementIterator(result);
                while (iter.hasNext()) {
                    defaultData.appendChild((Element)iter.next());
                }
            }
        }
    }

    private static Element createIndexedElement(Element templateFragment, Element indexes) {
        Element result;
        ElementIterator iter = new ElementIterator(templateFragment);
        if (iter.hasNext()) {
            result = templateFragment;
            while (iter.hasNext()) {
                int amount;
                Element oldChild = (Element)iter.next();
                String strAmount = SPath.getValue(indexes, oldChild.getTagName());
                if (strAmount != null) {
                    try {
                        amount = new Integer(strAmount.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        amount = 1;
                    }
                } else {
                    amount = 1;
                }
                Element newChild = SPath.createIndexedElement(oldChild, indexes);
                int cloneIndex = 0;
                while (cloneIndex < amount) {
                    result.insertBefore(newChild.cloneNode(true), oldChild);
                    ++cloneIndex;
                }
                result.removeChild(oldChild);
            }
        } else {
            result = templateFragment;
        }
        return result;
    }

    public static Element findNamedElement(Node sourceNode, String name) {
        Element result = null;
        if (name != null) {
            result = name.equals(sourceNode.getNodeName()) && sourceNode.getNodeType() == 1 ? (Element)sourceNode : SPath.findNamedChild(sourceNode, name);
        }
        return result;
    }

    private static Element findNamedChild(Node sourceNode, String name) {
        Element result = null;
        boolean found = false;
        ElementIterator iter = new ElementIterator(sourceNode);
        while (iter.hasNext() && !found) {
            result = (Element)iter.next();
            if (name.equals(result.getNodeName())) {
                found = true;
                continue;
            }
            boolean bl = found = (result = SPath.findNamedChild(result, name)) != null;
        }
        if (!found) {
            result = null;
        }
        return result;
    }

    public static class ElementIterator
    extends NodeListIterator {
        public ElementIterator(Node start) {
            super(start);
        }

        public ElementIterator(NodeList list) {
            super(list);
        }

        @Override
        public boolean match(Node n) {
            return n.getNodeType() == 1;
        }
    }

    public static class EmptyIterator
    implements Iterator {
        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("Empty iterator");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Empty iterator");
        }
    }

    public static class NamedElementIterator
    extends NodeListIterator {
        private String _childName;

        public NamedElementIterator(NodeList list, String childName) {
            super(list, false);
            this._childName = childName;
            this.init();
        }

        public NamedElementIterator(Node start, String childName) {
            super(start, false);
            this._childName = childName;
            this.init();
        }

        @Override
        public boolean match(Node node) {
            return node.getNodeType() == 1 && this._childName.equals(node.getNodeName());
        }
    }

    public static class NodeListIterator
    implements Iterator {
        private NodeList _list;
        private Node _nextResult;
        private Node _lastResult;
        private int _nextPos;
        private Node _node;

        public NodeListIterator(Node start) {
            this(start, true);
        }

        protected NodeListIterator(Node start, boolean doInit) {
            this._list = start.getChildNodes();
            this._node = start;
            if (doInit) {
                this.init();
            }
        }

        public NodeListIterator(NodeList list) {
            this(list, true);
        }

        protected NodeListIterator(NodeList list, boolean doInit) {
            this._list = list;
            if (doInit) {
                this.init();
            }
        }

        protected final void init() {
            if (this._list.item(0) != null) {
                this._nextPos = 0;
                this._fetchNextResult();
            } else {
                this._nextResult = null;
            }
        }

        public boolean match(Node node) {
            return true;
        }

        private void _fetchNextResult() {
            while ((this._nextResult = this._list.item(this._nextPos++)) != null && !this.match(this._nextResult)) {
            }
        }

        public final Object next() {
            if (this._nextResult == null) {
                throw new NoSuchElementException();
            }
            this._lastResult = this._nextResult;
            this._fetchNextResult();
            return this._lastResult;
        }

        @Override
        public final boolean hasNext() {
            return this._nextResult != null;
        }

        @Override
        public final void remove() {
            if (this._node == null) {
                throw new UnsupportedOperationException("Cannot remove if constructed with a NodeList");
            }
            if (this._lastResult == null) {
                throw new IllegalStateException("Last element already removed");
            }
            this._node.removeChild(this._lastResult);
            this._lastResult = null;
            --this._nextPos;
        }
    }

    public static class TextIterator
    extends NodeListIterator {
        public TextIterator(Node start) {
            super(start);
        }

        public TextIterator(NodeList list) {
            super(list);
        }

        @Override
        public boolean match(Node n) {
            return n.getNodeType() == 3;
        }
    }
}

