/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.codeassist;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.codeassist.CompletionNameProviders;
import org.eclipse.dltk.codeassist.ICompletionEngine;
import org.eclipse.dltk.codeassist.ICompletionNameProvider;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.problem.CategorizedProblem;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISearchableEnvironment;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.codeassist.impl.Engine;
import org.eclipse.dltk.internal.compiler.lookup.LookupEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptCompletionEngine
extends Engine
implements ICompletionEngine {
    protected static final boolean DEBUG;
    protected static final boolean VERBOSE;
    @Deprecated
    protected IScriptProject scriptProject;
    protected CompletionRequestor requestor;
    @Deprecated
    protected int startPosition;
    @Deprecated
    protected int endPosition;
    protected int actualCompletionPosition;
    protected int offset;
    protected boolean noProposal = true;
    protected CategorizedProblem problem = null;
    protected char[] source;
    private IProgressMonitor progressMonitor;

    static {
        VERBOSE = DEBUG = DLTKCore.DEBUG_COMPLETION;
    }

    public ScriptCompletionEngine() {
        super(null);
    }

    protected CompletionProposal createProposal(int kind, int completionOffset) {
        CompletionProposal proposal = CompletionProposal.create(kind, completionOffset - this.offset);
        return proposal;
    }

    protected void printDebug(CategorizedProblem error) {
        if (DEBUG) {
            System.out.print("COMPLETION - completionFailure(");
            System.out.print(error);
            System.out.println(")");
        }
    }

    protected void printDebug(CompletionProposal proposal) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("COMPLETION - ");
        switch (proposal.getKind()) {
            case 1: {
                buffer.append("FIELD_REF");
                break;
            }
            case 2: {
                buffer.append("KEYWORD");
                break;
            }
            case 3: {
                buffer.append("LABEL_REF");
                break;
            }
            case 4: {
                buffer.append("LOCAL_VARIABLE_REF");
                break;
            }
            case 6: {
                buffer.append("METHOD_DECLARATION");
                break;
            }
            case 5: {
                buffer.append("METHOD_REF");
                break;
            }
            case 11: {
                buffer.append("PACKAGE_REF");
                break;
            }
            case 7: {
                buffer.append("TYPE_REF");
                break;
            }
            case 8: {
                buffer.append("VARIABLE_DECLARATION");
                break;
            }
            case 9: {
                buffer.append("POTENTIAL_METHOD_DECLARATION");
                break;
            }
            case 10: {
                buffer.append("METHOD_NAME_REFERENCE");
                break;
            }
            default: {
                buffer.append("PROPOSAL");
            }
        }
        if (VERBOSE) {
            buffer.append("{\n");
            buffer.append("\tCompletion[").append(proposal.getCompletion() == null ? "null" : proposal.getCompletion()).append("]\n");
            buffer.append("\tDeclarationKey[").append(proposal.getDeclarationKey() == null ? "null" : proposal.getDeclarationKey()).append("]\n");
            buffer.append("\tKey[").append(proposal.getKey() == null ? "null" : proposal.getKey()).append("]\n");
            buffer.append("\tName[").append(proposal.getName() == null ? "null" : proposal.getName()).append("]\n");
            buffer.append("\tCompletionLocation[").append(proposal.getCompletionLocation()).append("]\n");
            int start = proposal.getReplaceStart();
            int end = proposal.getReplaceEnd();
            buffer.append("\tReplaceStart[").append(start).append("]");
            buffer.append("-ReplaceEnd[").append(end).append("]\n");
            if (this.source != null) {
                buffer.append("\tReplacedText[").append(this.source, start, end - start).append("]\n");
            }
            buffer.append("\tTokenStart[").append(proposal.getTokenStart()).append("]");
            buffer.append("-TokenEnd[").append(proposal.getTokenEnd()).append("]\n");
            buffer.append("\tRelevance[").append(proposal.getRelevance()).append("]\n");
            buffer.append("}\n");
        } else if (proposal.getCompletion() != null) {
            buffer.append(' ').append('\"').append(proposal.getCompletion()).append('\"');
        }
        System.out.println(buffer.toString());
    }

    public void setSourceRange(int start, int end) {
        this.setSourceRange(start, end, true);
    }

    protected void setSourceRange(int start, int end, boolean emptyTokenAdjstment) {
        int endOfEmptyToken;
        this.startPosition = start;
        this.endPosition = emptyTokenAdjstment ? ((endOfEmptyToken = this.getEndOfEmptyToken()) > end ? endOfEmptyToken : end) : end;
    }

    protected int getEndOfEmptyToken() {
        return 0;
    }

    protected String processMethodName(IMethod method, String token) {
        return method.getElementName();
    }

    protected String processTypeName(IType type, String token) {
        return type.getElementName();
    }

    @Deprecated
    protected final String processFieldName(IField field, String token) {
        return field.getElementName();
    }

    public void findKeywords(char[] keyword, String[] choices, boolean canCompleteEmptyToken) {
        if (choices == null || choices.length == 0) {
            return;
        }
        int length = keyword.length;
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < choices.length) {
                if (length <= choices[i].length() && CharOperation.prefixEquals(keyword, choices[i], false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(keyword, choices[i]);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(2)) {
                        CompletionProposal proposal = this.createProposal(2, this.actualCompletionPosition);
                        proposal.setName(choices[i]);
                        proposal.setCompletion(choices[i]);
                        proposal.setRelevance(relevance);
                        this.accept(proposal);
                    }
                }
                ++i;
            }
        }
    }

    protected void findLocalVariables(char[] token, String[] choices, boolean canCompleteEmptyToken, boolean provideDollar) {
        int kind = 4;
        this.findElements(token, choices, canCompleteEmptyToken, provideDollar, kind);
    }

    protected void findElements(char[] token, String[] choices, boolean canCompleteEmptyToken, boolean provideDollar, int kind) {
        if (choices == null || choices.length == 0) {
            return;
        }
        int length = token.length;
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < choices.length) {
                String co = choices[i];
                if (!provideDollar && co.length() > 1 && co.charAt(0) == '$') {
                    co = co.substring(1);
                }
                if (length <= co.length() && CharOperation.prefixEquals(token, co, false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(token, co);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(kind)) {
                        CompletionProposal proposal = this.createProposal(kind, this.actualCompletionPosition);
                        proposal.setName(co);
                        proposal.setCompletion(co);
                        proposal.setRelevance(relevance);
                        this.accept(proposal);
                    }
                }
                ++i;
            }
        }
    }

    public void findMethods(char[] token, boolean canCompleteEmptyToken, List<IMethod> methods, List methodNames) {
        if (methods == null || methods.size() == 0) {
            return;
        }
        int length = token.length;
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < methods.size()) {
                String qname;
                IMethod method = methods.get(i);
                String name = qname = (String)methodNames.get(i);
                if (DEBUG) {
                    System.out.println("Completion:" + qname);
                }
                if (length <= name.length() && CharOperation.prefixEquals(token, name, false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(token, name);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(5)) {
                        String[] arguments;
                        CompletionProposal proposal;
                        block10: {
                            proposal = this.createProposal(5, this.actualCompletionPosition);
                            proposal.setModelElement(method);
                            arguments = null;
                            if (method != null) {
                                try {
                                    proposal.setFlags(method.getFlags());
                                    arguments = method.getParameterNames();
                                }
                                catch (ModelException e) {
                                    if (!DLTKCore.DEBUG) break block10;
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (arguments != null && arguments.length > 0) {
                            proposal.setParameterNames(arguments);
                        }
                        proposal.setName(name);
                        proposal.setCompletion(name);
                        proposal.setRelevance(relevance);
                        this.accept(proposal);
                    }
                }
                ++i;
            }
        }
    }

    protected void findLocalMethods(char[] token, boolean canCompleteEmptyToken, List methods, List methodNames) {
        if (methods == null || methods.size() == 0) {
            return;
        }
        int length = token.length;
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < methods.size()) {
                MethodDeclaration method = (MethodDeclaration)methods.get(i);
                String name = (String)methodNames.get(i);
                if (length <= name.length() && CharOperation.prefixEquals(token, name, false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(token, name);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(5)) {
                        CompletionProposal proposal = this.createProposal(5, this.actualCompletionPosition);
                        List arguments = method.getArguments();
                        if (arguments != null && arguments.size() > 0) {
                            String[] args = new String[arguments.size()];
                            int j = 0;
                            while (j < arguments.size()) {
                                args[j] = ((Argument)arguments.get(j)).getName();
                                ++j;
                            }
                            proposal.setParameterNames(args);
                        }
                        proposal.setName(name);
                        proposal.setCompletion(name);
                        proposal.setRelevance(relevance);
                        this.accept(proposal);
                    }
                }
                ++i;
            }
        }
    }

    protected void findMethods(char[] token, boolean canCompleteEmptyToken, List<IMethod> methods) {
        this.findMethods(token, canCompleteEmptyToken, methods, 5);
    }

    public void findFields(char[] token, boolean canCompleteEmptyToken, List<IField> fields, ICompletionNameProvider<IField> nameProvider) {
        this.findFields(token, canCompleteEmptyToken, fields, 1, nameProvider);
    }

    protected void findMethods(char[] token, boolean canCompleteEmptyToken, List<IMethod> methods, int kind) {
        if (methods == null || methods.size() == 0) {
            return;
        }
        int length = token.length;
        String tok = new String(token);
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < methods.size()) {
                String qname;
                IMethod method = methods.get(i);
                String name = qname = this.processMethodName(method, tok);
                if (DEBUG) {
                    System.out.println("Completion:" + qname);
                }
                if (length <= name.length() && CharOperation.prefixEquals(token, name, false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(token, name);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(kind)) {
                        String[] arguments;
                        CompletionProposal proposal;
                        block12: {
                            block11: {
                                proposal = this.createProposal(kind, this.actualCompletionPosition);
                                proposal.setModelElement(method);
                                try {
                                    proposal.setFlags(method.getFlags());
                                }
                                catch (ModelException e1) {
                                    if (!DLTKCore.DEBUG) break block11;
                                    e1.printStackTrace();
                                }
                            }
                            arguments = null;
                            try {
                                arguments = method.getParameterNames();
                            }
                            catch (ModelException e) {
                                if (!DLTKCore.DEBUG) break block12;
                                e.printStackTrace();
                            }
                        }
                        if (arguments != null && arguments.length > 0) {
                            proposal.setParameterNames(arguments);
                        }
                        proposal.setName(name);
                        proposal.setCompletion(name);
                        proposal.setRelevance(relevance);
                        this.accept(proposal);
                    }
                }
                ++i;
            }
        }
    }

    public void findFields(char[] token, boolean canCompleteEmptyToken, List<IField> fields, int kind, ICompletionNameProvider<IField> nameProvider) {
        if (fields == null || fields.size() == 0) {
            return;
        }
        if (nameProvider == null) {
            nameProvider = CompletionNameProviders.defaultProvider();
        }
        int length = token.length;
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < fields.size()) {
                String qname;
                IField field = fields.get(i);
                String name = qname = nameProvider.getName(field);
                if (DEBUG) {
                    System.out.println("Completion:" + qname);
                }
                if (length <= name.length() && CharOperation.prefixEquals(token, name, false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(token, name);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(kind)) {
                        CompletionProposal proposal = this.createProposal(kind, this.actualCompletionPosition);
                        proposal.setModelElement(field);
                        proposal.setName(name);
                        proposal.setCompletion(nameProvider.getCompletion(field));
                        proposal.setRelevance(relevance);
                        this.accept(proposal);
                    }
                }
                ++i;
            }
        }
    }

    private void findFields(char[] token, boolean canCompleteEmptyToken, List<IField> fields, int kind, List names) {
        if (fields == null || fields.size() == 0) {
            return;
        }
        int length = token.length;
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < fields.size()) {
                String qname;
                IField field = fields.get(i);
                String name = qname = (String)names.get(i);
                if (DEBUG) {
                    System.out.println("Completion:" + qname);
                }
                if (length <= name.length() && CharOperation.prefixEquals(token, name, false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(token, name);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(kind)) {
                        CompletionProposal proposal = this.createProposal(kind, this.actualCompletionPosition);
                        proposal.setModelElement(field);
                        proposal.setName(name);
                        proposal.setCompletion(qname);
                        proposal.setRelevance(relevance);
                        this.accept(proposal);
                    }
                }
                ++i;
            }
        }
    }

    public void findTypes(char[] token, boolean canCompleteEmptyToken, List<IType> types) {
        if (types == null || types.size() == 0) {
            return;
        }
        int length = token.length;
        String tok = new String(token);
        if (canCompleteEmptyToken || length > 0) {
            int i = 0;
            while (i < types.size()) {
                String qname;
                IType type = types.get(i);
                String name = qname = this.processTypeName(type, tok);
                if (DEBUG) {
                    System.out.println("Completion:" + qname);
                }
                if (length <= name.length() && CharOperation.prefixEquals(token, name, false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(token, name);
                    relevance += this.computeRelevanceForRestrictions(0);
                    this.noProposal = false;
                    if (!this.requestor.isIgnored(7)) {
                        CompletionProposal proposal = this.createProposal(7, this.actualCompletionPosition);
                        proposal.setModelElement(type);
                        proposal.setName(name);
                        proposal.setCompletion(name);
                        proposal.setRelevance(relevance);
                        this.accept(proposal);
                    }
                }
                ++i;
            }
        }
    }

    public int computeBaseRelevance() {
        return 0;
    }

    public int computeRelevanceForInterestingProposal() {
        return 5;
    }

    public int computeRelevanceForCaseMatching(char[] token, String proposalNameStr) {
        char[] proposalName = proposalNameStr.toCharArray();
        if (this.options.camelCaseMatch) {
            if (CharOperation.equals(token, proposalName, true)) {
                return 14;
            }
            if (CharOperation.prefixEquals(token, proposalName, true)) {
                return 10;
            }
            if (CharOperation.camelCaseMatch(token, proposalName)) {
                return 5;
            }
            if (CharOperation.equals(token, proposalName, false)) {
                return 4;
            }
        } else {
            if (CharOperation.prefixEquals(token, proposalName, true)) {
                if (CharOperation.equals(token, proposalName, true)) {
                    return 14;
                }
                return 10;
            }
            if (CharOperation.equals(token, proposalName, false)) {
                return 4;
            }
        }
        return 0;
    }

    public int computeRelevanceForRestrictions(int accessRuleKind) {
        if (accessRuleKind == 0) {
            return 3;
        }
        return 0;
    }

    public void setEnvironment(ISearchableEnvironment environment) {
        this.nameEnvironment = environment;
        this.lookupEnvironment = new LookupEnvironment(this, this.nameEnvironment);
    }

    @Override
    public void setOptions(Map options) {
    }

    public void accept(CompletionProposal proposal) {
        proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
        this.requestor.accept(proposal);
        if (DEBUG) {
            this.printDebug(proposal);
        }
    }

    @Override
    public void setProject(IScriptProject project) {
        this.scriptProject = project;
    }

    @Override
    public void setRequestor(CompletionRequestor requestor) {
        this.requestor = requestor;
    }

    @Override
    public void setProgressMonitor(IProgressMonitor monitor) {
        this.progressMonitor = monitor;
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = new NullProgressMonitor();
        }
        return this.progressMonitor;
    }
}

