/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.remote.debug.ui.internal.launch;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.koneki.ldt.debug.ui.internal.launchconfiguration.local.LuaApplicationLaunchShortcut;
import org.eclipse.koneki.ldt.remote.core.internal.RSEUtil;
import org.eclipse.koneki.ldt.remote.core.internal.lua.LuaSubSystem;
import org.eclipse.koneki.ldt.remote.debug.core.internal.launch.LuaRemoteLaunchConfigurationUtil;
import org.eclipse.koneki.ldt.remote.debug.ui.internal.Activator;
import org.eclipse.koneki.ldt.remote.debug.ui.internal.launch.Messages;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.view.SystemViewLabelAndContentProvider;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class LuaRemoteLaunchShortcut
extends LuaApplicationLaunchShortcut {
    protected ILaunchConfigurationType getConfigurationType() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.koneki.ldt.remote.debug.core.luaremotedebug");
    }

    public ILaunchConfiguration createLaunchConfiguration(IFile script) {
        IHost host;
        ILaunchConfigurationType configType;
        ILaunchConfigurationWorkingCopy wc;
        ILaunchConfiguration config;
        block8: {
            config = null;
            wc = null;
            configType = this.getConfigurationType();
            RSEUtil.waitForRSEInitialization();
            host = null;
            List<IHost> hosts = this.findHosts();
            if (hosts.isEmpty()) {
                if (MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.LuaRemoteLaunchShortcut_notargetdialog_title, (String)Messages.LuaRemoteLaunchShortcut_notargetdialog_message)) {
                    SystemNewConnectionAction newConnectionAction = new SystemNewConnectionAction(this.getShell(), false, null);
                    newConnectionAction.run();
                    host = (IHost)newConnectionAction.getValue();
                }
            } else if (hosts.size() == 1) {
                host = hosts.get(0);
            } else {
                ElementListSelectionDialog selectHostDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new SystemViewLabelAndContentProvider());
                selectHostDialog.setElements(hosts.toArray());
                selectHostDialog.setTitle(Messages.LuaRemoteLaunchShortcut_selectHostDialog_title);
                selectHostDialog.setMessage(Messages.LuaRemoteLaunchShortcut_selectHost_message);
                selectHostDialog.open();
                host = (IHost)selectHostDialog.getFirstResult();
            }
            if (host != null) break block8;
            return null;
        }
        try {
            String fileNameWithoutExtension = script.getLocation().removeFileExtension().lastSegment();
            String configNamePrefix = MessageFormat.format("{0}_{1}_{2}", script.getProject().getName(), fileNameWithoutExtension, host);
            wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(configNamePrefix));
            wc.setAttribute("nature", this.getNatureId());
            wc.setAttribute("project", script.getProject().getName());
            wc.setAttribute("mainScript", script.getProjectRelativePath().toPortableString());
            LuaRemoteLaunchConfigurationUtil.setConnectionId((ILaunchConfigurationWorkingCopy)wc, (IHost)host);
            wc.setMappedResources(new IResource[]{script});
            config = wc.doSave();
        }
        catch (CoreException e) {
            Activator.logError("Unable to create a launch configuration from a LaunchShortcut", e);
        }
        return config;
    }

    private List<IHost> findHosts() {
        IHost[] hosts = RSECorePlugin.getTheSystemRegistry().getHosts();
        ArrayList<IHost> newHostList = new ArrayList<IHost>();
        IHost[] iHostArray = hosts;
        int n = hosts.length;
        int n2 = 0;
        while (n2 < n) {
            IHost host = iHostArray[n2];
            boolean isFileSubSystem = false;
            boolean isLuaSubSystem = false;
            ISubSystem[] iSubSystemArray = host.getSubSystems();
            int n3 = iSubSystemArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ISubSystem subsystem = iSubSystemArray[n4];
                if (subsystem instanceof IRemoteFileSubSystem) {
                    isFileSubSystem = true;
                }
                if (subsystem instanceof LuaSubSystem) {
                    isLuaSubSystem = true;
                }
                ++n4;
            }
            if (isFileSubSystem && isLuaSubSystem) {
                newHostList.add(host);
            }
            ++n2;
        }
        return newHostList;
    }
}

