/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing.core;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IProjectIndexer;
import org.eclipse.dltk.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.core.search.indexing.core.IndexRequest;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalProjectFragmentRequest
extends IndexRequest {
    protected final IProjectFragment fragment;
    protected final IDLTKLanguageToolkit toolkit;

    public ExternalProjectFragmentRequest(IProjectIndexer indexer, IProjectFragment fragment, IDLTKLanguageToolkit toolkit) {
        super(indexer);
        this.fragment = fragment;
        this.toolkit = toolkit;
    }

    @Override
    protected String getName() {
        return this.fragment.getElementName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void run() throws CoreException, IOException {
        IEnvironment environment = EnvironmentManager.getEnvironment(this.fragment.getScriptProject());
        if (environment == null) return;
        if (!environment.connect()) {
            return;
        }
        Set<ISourceModule> modules = this.getExternalSourceModules();
        Index index = this.getIndexer().getProjectFragmentIndex(this.fragment);
        if (index == null) {
            return;
        }
        IPath containerPath = this.fragment.getPath();
        HashSet<IFileHandle> parentFolders = new HashSet<IFileHandle>();
        List<Object> changes = this.checkChanges(index, modules, containerPath, this.getEnvironment(), parentFolders);
        if (changes.isEmpty()) {
            return;
        }
        ReadWriteMonitor imon = index.monitor;
        imon.enterWrite();
        try {
            try {
                Iterator<Object> i = changes.iterator();
                while (!this.isCancelled) {
                    IFileHandle parentHandle;
                    if (!i.hasNext()) {
                        return;
                    }
                    Object change = i.next();
                    if (change instanceof String) {
                        index.remove((String)change);
                        continue;
                    }
                    if (!(change instanceof ISourceModule)) continue;
                    ISourceModule module = (ISourceModule)change;
                    IFileHandle file = EnvironmentPathUtils.getFile(module, false);
                    if (file != null && changes.size() > 1 && (parentHandle = file.getParent()) != null && parentFolders.add(parentHandle.getParent())) {
                        ModelManager.getModelManager().getCoreCache().updateFolderTimestamps(parentHandle);
                    }
                    this.getIndexer().indexSourceModule(index, this.toolkit, module, containerPath);
                }
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
                try {
                    try {
                        index.save();
                        return;
                    }
                    catch (IOException e2) {
                        DLTKCore.error("error saving index", e2);
                        imon.exitWrite();
                        return;
                    }
                }
                finally {
                    imon.exitWrite();
                }
            }
        }
        finally {
            block26: {
                try {
                    try {
                        index.save();
                    }
                    catch (IOException e) {
                        DLTKCore.error("error saving index", e);
                        imon.exitWrite();
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    imon.exitWrite();
                    throw throwable;
                }
                imon.exitWrite();
            }
        }
    }

    protected IEnvironment getEnvironment() {
        return EnvironmentManager.getEnvironment(this.fragment);
    }

    private Set<ISourceModule> getExternalSourceModules() throws ModelException {
        ExternalModuleVisitor visitor = new ExternalModuleVisitor();
        this.fragment.accept(visitor);
        return visitor.modules;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalProjectFragmentRequest other = (ExternalProjectFragmentRequest)obj;
        return !(this.fragment == null ? other.fragment != null : !this.fragment.equals(other.fragment));
    }

    static class ExternalModuleVisitor
    implements IModelElementVisitor {
        final Set<ISourceModule> modules = new HashSet<ISourceModule>();

        ExternalModuleVisitor() {
        }

        public boolean visit(IModelElement element) {
            if (element.getElementType() == 5) {
                if (element instanceof IExternalSourceModule || element instanceof BuiltinSourceModule || ((ISourceModule)element).isBinary()) {
                    this.modules.add((ISourceModule)element);
                }
                return false;
            }
            return true;
        }
    }
}

