/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import com.ibm.icu.text.MessageFormat;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.InterpreterRuntimeBuildpathEntryResolver;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterRunner;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntry;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.launching.debug.DebuggingEngineManager;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScriptLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private IProject[] fOrderedProjects;

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected CoreException abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.launching", code, message, exception));
    }

    protected CoreException abort(String message, Throwable exception) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.launching", 100, message, exception));
    }

    public IInterpreterInstall getInterpreterInstall(ILaunchConfiguration configuration) throws CoreException {
        return ScriptRuntime.computeInterpreterInstall(configuration);
    }

    public IInterpreterInstall verifyInterpreterInstall(ILaunchConfiguration configuration) throws CoreException {
        IInterpreterInstall interpreter = this.getInterpreterInstall(configuration);
        if (interpreter == null) {
            throw this.abort(LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_The_specified_InterpreterEnvironment_installation_does_not_exist_4, null, 105);
        }
        IFileHandle location = interpreter.getInstallLocation();
        if (location == null) {
            throw this.abort(MessageFormat.format((String)LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_InterpreterEnvironment_home_directory_not_specified_for__0__5, (Object[])new String[]{interpreter.getName()}), null, 105);
        }
        if (!location.exists()) {
            this.abort(MessageFormat.format((String)LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_InterpreterEnvironment_home_directory_for__0__does_not_exist___1__6, (Object[])new String[]{interpreter.getName(), location.toURI().toString()}), null, 105);
        }
        return interpreter;
    }

    public String getDebugConnectorId(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("debugConnector", null);
    }

    public String[] getBuildpath(ILaunchConfiguration configuration) throws CoreException {
        return this.getBuildpath(configuration, this.getScriptEnvironment(configuration));
    }

    public String[] getBuildpath(ILaunchConfiguration configuration, IEnvironment environment) throws CoreException {
        IRuntimeBuildpathEntry[] entries = ScriptRuntime.computeUnresolvedRuntimeBuildpath(configuration);
        entries = ScriptRuntime.resolveRuntimeBuildpath(entries, configuration);
        ArrayList<String> userEntries = new ArrayList<String>();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getBuildpathProperty() == 3) {
                IFileHandle handle;
                URI uri;
                IPath path = entries[i].getPath();
                String userPath = EnvironmentPathUtils.isFull((IPath)path) ? EnvironmentPathUtils.getFile((IPath)path).toOSString() : ((uri = entries[i].getLocationURI()) != null ? ((handle = environment.getFile(uri)) != null ? handle.toOSString() : null) : null);
                if (userPath != null && !userEntries.contains(userPath)) {
                    userEntries.add(userPath);
                }
            }
            ++i;
        }
        return userEntries.toArray(new String[userEntries.size()]);
    }

    public String[] getBootpath(ILaunchConfiguration configuration) throws CoreException {
        String[][] paths = this.getBootpathExt(configuration);
        String[] pre = paths[0];
        String[] main = paths[1];
        String[] app = paths[2];
        if (pre == null && main == null && app == null) {
            return null;
        }
        IRuntimeBuildpathEntry[] entries = ScriptRuntime.computeUnresolvedRuntimeBuildpath(configuration);
        entries = ScriptRuntime.resolveRuntimeBuildpath(entries, configuration);
        ArrayList<String> bootEntries = new ArrayList<String>(entries.length);
        boolean empty = true;
        boolean allStandard = true;
        int i = 0;
        while (i < entries.length) {
            String location;
            if (entries[i].getBuildpathProperty() != 3 && (location = entries[i].getLocation()) != null) {
                empty = false;
                bootEntries.add(location);
                allStandard = allStandard && entries[i].getBuildpathProperty() == 1;
            }
            ++i;
        }
        if (empty) {
            return new String[0];
        }
        if (allStandard) {
            return null;
        }
        return bootEntries.toArray(new String[bootEntries.size()]);
    }

    public String[][] getBootpathExt(ILaunchConfiguration configuration) throws CoreException {
        String[][] bootpathInfo = new String[3][];
        IRuntimeBuildpathEntry[] entries = ScriptRuntime.computeUnresolvedRuntimeBuildpath(configuration);
        ArrayList<IRuntimeBuildpathEntry> bootEntriesPrepend = new ArrayList<IRuntimeBuildpathEntry>();
        int index = 0;
        IRuntimeBuildpathEntry interpreterEnvironmentEntry = null;
        IScriptProject project = AbstractScriptLaunchConfigurationDelegate.getScriptProject(configuration);
        IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)project);
        while (interpreterEnvironmentEntry == null && index < entries.length) {
            IRuntimeBuildpathEntry entry;
            if ((entry = entries[index++]).getBuildpathProperty() != 2 && entry.getBuildpathProperty() != 1) continue;
            if (ScriptRuntime.isInterpreterInstallReference(this.getLanguageId(), environment.getId(), entry)) {
                interpreterEnvironmentEntry = entry;
                continue;
            }
            bootEntriesPrepend.add(entry);
        }
        IRuntimeBuildpathEntry[] bootEntriesPrep = ScriptRuntime.resolveRuntimeBuildpath(bootEntriesPrepend.toArray(new IRuntimeBuildpathEntry[bootEntriesPrepend.size()]), configuration);
        String[] entriesPrep = null;
        if (bootEntriesPrep.length > 0) {
            entriesPrep = new String[bootEntriesPrep.length];
            int i = 0;
            while (i < bootEntriesPrep.length) {
                entriesPrep[i] = bootEntriesPrep[i].getLocation();
                ++i;
            }
        }
        if (interpreterEnvironmentEntry != null) {
            IInterpreterInstall install;
            LibraryLocation[] libraryLocations;
            ArrayList<IRuntimeBuildpathEntry> bootEntriesAppend = new ArrayList<IRuntimeBuildpathEntry>();
            while (index < entries.length) {
                IRuntimeBuildpathEntry entry = entries[index];
                if (entry.getBuildpathProperty() == 2) {
                    bootEntriesAppend.add(entry);
                }
                ++index;
            }
            bootpathInfo[0] = entriesPrep;
            IRuntimeBuildpathEntry[] bootEntriesApp = ScriptRuntime.resolveRuntimeBuildpath(bootEntriesAppend.toArray(new IRuntimeBuildpathEntry[bootEntriesAppend.size()]), configuration);
            if (bootEntriesApp.length > 0) {
                bootpathInfo[2] = new String[bootEntriesApp.length];
                int i = 0;
                while (i < bootEntriesApp.length) {
                    bootpathInfo[2][i] = bootEntriesApp[i].getLocation();
                    ++i;
                }
            }
            if ((libraryLocations = (install = this.getInterpreterInstall(configuration)).getLibraryLocations()) != null && !InterpreterRuntimeBuildpathEntryResolver.isSameArchives(libraryLocations, install.getInterpreterInstallType().getDefaultLibraryLocations(install.getInstallLocation(), install.getEnvironmentVariables(), null))) {
                IRuntimeBuildpathEntry[] bootEntries = null;
                if (interpreterEnvironmentEntry.getType() == 4) {
                    IRuntimeBuildpathEntry bootEntry = ScriptRuntime.newRuntimeContainerBuildpathEntry(interpreterEnvironmentEntry.getPath(), 2, AbstractScriptLaunchConfigurationDelegate.getScriptProject(configuration));
                    bootEntries = ScriptRuntime.resolveRuntimeBuildpathEntry(bootEntry, configuration);
                } else {
                    bootEntries = ScriptRuntime.resolveRuntimeBuildpathEntry(interpreterEnvironmentEntry, configuration);
                }
                String[] bootpath = new String[bootEntriesPrep.length + bootEntries.length + bootEntriesApp.length];
                if (bootEntriesPrep.length > 0) {
                    System.arraycopy(bootpathInfo[0], 0, bootpath, 0, bootEntriesPrep.length);
                }
                int dest = bootEntriesPrep.length;
                int i = 0;
                while (i < bootEntries.length) {
                    bootpath[dest] = bootEntries[i].getLocation();
                    ++dest;
                    ++i;
                }
                if (bootEntriesApp.length > 0) {
                    System.arraycopy(bootpathInfo[2], 0, bootpath, dest, bootEntriesApp.length);
                }
                bootpathInfo[0] = null;
                bootpathInfo[1] = bootpath;
                bootpathInfo[2] = null;
            }
        } else {
            bootpathInfo[1] = entriesPrep == null ? new String[0] : entriesPrep;
        }
        return bootpathInfo;
    }

    public static IScriptProject getScriptProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IScriptProject scriptProject;
        String projectName = AbstractScriptLaunchConfigurationDelegate.getScriptProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (scriptProject = DLTKCore.create((IProject)(project = AbstractScriptLaunchConfigurationDelegate.getWorkspaceRoot().getProject(projectName)))) != null && scriptProject.exists()) {
            return scriptProject;
        }
        return null;
    }

    public static IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        String projectName = AbstractScriptLaunchConfigurationDelegate.getScriptProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (project = AbstractScriptLaunchConfigurationDelegate.getWorkspaceRoot().getProject(projectName)) != null && project.exists()) {
            return project;
        }
        return null;
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static String getScriptProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("project", null);
    }

    public static String getMainScriptName(ILaunchConfiguration configuration) throws CoreException {
        String script = configuration.getAttribute("mainScript", null);
        if (script == null) {
            return null;
        }
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(script);
    }

    public String[] getScriptArguments(ILaunchConfiguration configuration) throws CoreException {
        String arguments = configuration.getAttribute("scriptArguments", "");
        String args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arguments);
        return DebugPlugin.parseArguments((String)args);
    }

    protected final String[] getInterpreterArguments(ILaunchConfiguration configuration) throws CoreException {
        String arguments = configuration.getAttribute("interpreterArguments", "");
        String args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arguments);
        return DebugPlugin.parseArguments((String)args);
    }

    public Map<String, String> getInterpreterSpecificAttributesMap(ILaunchConfiguration configuration) throws CoreException {
        Map map = configuration.getAttribute("interpreterTypeSpecificAttrs", null);
        return map;
    }

    public String getWorkingDirectory(ILaunchConfiguration configuration, IEnvironment environment) throws CoreException {
        return this.verifyWorkingDirectory(configuration, environment);
    }

    public IPath getWorkingDirectoryPath(ILaunchConfiguration configuration) throws CoreException {
        String path = configuration.getAttribute("workingDir", null);
        if (path != null) {
            if (path.trim().length() == 0) {
                return null;
            }
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                path = manager.performStringSubstitution(path, false);
                return new Path(path);
            }
            catch (CoreException e) {
                DLTKLaunchingPlugin.log(e);
            }
        }
        return null;
    }

    public String verifyWorkingDirectory(ILaunchConfiguration configuration, IEnvironment environment) throws CoreException {
        IPath path = this.getWorkingDirectoryPath(configuration);
        if (path == null) {
            IPath dirPath = this.getDefaultWorkingDirectory(configuration);
            IFileHandle dir = environment.getFile(dirPath);
            if (dir != null) {
                if (!dir.isDirectory()) {
                    this.abort(MessageFormat.format((String)LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_Working_directory_does_not_exist___0__12, (Object[])new String[]{dir.toString()}), null, 108);
                }
                return dir.toOSString();
            }
        } else if (path.isAbsolute()) {
            IFileHandle dir = environment.getFile(path);
            if (dir.isDirectory()) {
                return dir.toOSString();
            }
            IResource res = AbstractScriptLaunchConfigurationDelegate.getWorkspaceRoot().findMember(path);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocation().toOSString();
            }
            this.abort(MessageFormat.format((String)LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_Working_directory_does_not_exist___0__12, (Object[])new String[]{path.toString()}), null, 108);
        } else {
            IResource res = AbstractScriptLaunchConfigurationDelegate.getWorkspaceRoot().findMember(path);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocation().toOSString();
            }
            this.abort(MessageFormat.format((String)LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_Working_directory_does_not_exist___0__12, (Object[])new String[]{path.toString()}), null, 108);
        }
        return null;
    }

    public String verifyMainScriptName(ILaunchConfiguration configuration) throws CoreException {
        String name = AbstractScriptLaunchConfigurationDelegate.getMainScriptName(configuration);
        if (name == null) {
            this.abort(LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_Main_type_not_specified_11, null, 106);
        }
        return name;
    }

    protected String getScriptLaunchPath(ILaunchConfiguration configuration, IEnvironment scriptEnvironment) throws CoreException {
        IEnvironment environment;
        IProject project;
        IFile mainScript;
        URI scriptURI;
        String mainScriptName = this.verifyMainScriptName(configuration);
        if (mainScriptName.length() != 0 && (scriptURI = (mainScript = (project = AbstractScriptLaunchConfigurationDelegate.getProject(configuration)).getFile((IPath)new Path(mainScriptName))).getLocationURI()) != null && (environment = EnvironmentManager.getEnvironment((IProject)project)) != null) {
            IFileHandle file = environment.getFile(scriptURI);
            if (file != null) {
                if (!file.exists()) {
                    this.abort(NLS.bind((String)LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_Main_script_not_exist, (Object)file.toOSString()), null, 106);
                }
                return file.getPath().toOSString();
            }
            this.abort(NLS.bind((String)LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_Main_script_not_resolved, (Object)mainScriptName), null, 106);
        }
        return null;
    }

    protected InterpreterConfig createInterpreterConfig(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        Map envVars;
        IEnvironment scriptEnvironment = this.getScriptEnvironment(configuration);
        IExecutionEnvironment scriptExecEnvironment = (IExecutionEnvironment)scriptEnvironment.getAdapter(IExecutionEnvironment.class);
        String scriptLaunchPath = this.getScriptLaunchPath(configuration, scriptEnvironment);
        Path workingDirectory = new Path(this.getWorkingDirectory(configuration, scriptEnvironment));
        Path mainScript = null;
        if (scriptLaunchPath != null) {
            mainScript = new Path(scriptLaunchPath);
        }
        InterpreterConfig config = new InterpreterConfig(scriptEnvironment, (IPath)mainScript, (IPath)workingDirectory);
        String[] scriptArgs = this.getScriptArguments(configuration);
        config.addScriptArgs(scriptArgs);
        String[] interpreterArgs = this.getInterpreterArguments(configuration);
        config.addInterpreterArgs(interpreterArgs);
        boolean append = configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        Map configEnv = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
        HashMap<String, String> env = new HashMap<String, String>();
        if ((append || configEnv == null) && (envVars = scriptExecEnvironment.getEnvironmentVariables(false)) != null) {
            env.putAll(envVars);
        }
        if (configEnv != null) {
            for (Map.Entry entry : configEnv.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value != null) {
                    value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value);
                }
                env.put(key, value);
            }
        }
        config.addEnvVars(env);
        return config;
    }

    private IEnvironment getScriptEnvironment(ILaunchConfiguration configuration) throws CoreException {
        IScriptProject scriptProject = AbstractScriptLaunchConfigurationDelegate.getScriptProject(configuration);
        return EnvironmentManager.getEnvironment((IModelElement)scriptProject);
    }

    protected void validateLaunchConfiguration(ILaunchConfiguration configuration, String mode, IProject project) throws CoreException {
        if ("debug".equals(mode) && !DebuggingEngineManager.getInstance().hasSelectedDebuggingEngine(project, this.getNatureId(configuration))) {
            this.abort(LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_debuggingEngineNotSelected, null, 510);
        }
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        Launch launch = new Launch(configuration, mode, null);
        if ("debug".equals(mode)) {
            this.setDebugConsoleAttributes(launch, configuration);
            this.setDebugOptions(launch, configuration);
        }
        return launch;
    }

    protected void setDebugOptions(Launch launch, ILaunchConfiguration configuration) throws CoreException {
        if (configuration.getAttribute("enableBreakOnFirstLine", false)) {
            launch.setAttribute("org.eclipse.dltk.debug.breakOnFirstLine", "true");
        }
    }

    protected void setDebugConsoleAttributes(Launch launch, ILaunchConfiguration configuration) throws CoreException {
        if (!configuration.getAttribute("org.eclipse.dltk.launching.debugConsole", true)) {
            launch.setAttribute("org.eclipse.dltk.debug.debugConsole", "false");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        launch.setAttribute("org.eclipse.debug.core.capture_output", null);
        try {
            IProject project = ScriptRuntime.getScriptProject(configuration).getProject();
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(MessageFormat.format((String)LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_startingLaunchConfiguration, (Object[])new Object[]{configuration.getName()}), 10);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask(MessageFormat.format((String)LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_validatingLaunchConfiguration, (Object[])new Object[]{configuration.getName()}));
            this.validateLaunchConfiguration(configuration, mode, project);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask(LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_generatingInterpreterConfiguration);
            InterpreterConfig config = this.createInterpreterConfig(configuration, launch);
            if (config == null) {
                monitor.setCanceled(true);
                return;
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            monitor.subTask(LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_gettingInterpreterRunner);
            IInterpreterRunner runner = this.getInterpreterRunner(configuration, mode);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            monitor.subTask(LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_executingRunner);
            this.runRunner(configuration, runner, config, launch, (IProgressMonitor)new SubProgressMonitor(monitor, 7));
            return;
        }
        catch (CoreException e) {
            AbstractScriptLaunchConfigurationDelegate.tryHandleStatus(e, (Object)this);
            return;
        }
        catch (AssertionFailedException e) {
            AbstractScriptLaunchConfigurationDelegate.tryHandleStatus(new CoreException((IStatus)new Status(4, "org.eclipse.dltk.launching", 100, e.getMessage(), (Throwable)e)), (Object)this);
            return;
        }
        catch (IllegalArgumentException e) {
            AbstractScriptLaunchConfigurationDelegate.tryHandleStatus(new CoreException((IStatus)new Status(4, "org.eclipse.dltk.launching", 100, e.getMessage(), (Throwable)e)), (Object)this);
            return;
        }
        finally {
            monitor.done();
        }
    }

    protected static void tryHandleStatus(CoreException e, Object source) throws CoreException {
        IStatus status = e.getStatus();
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler == null) {
            throw e;
        }
        handler.handleStatus(status, source);
    }

    protected void runRunner(ILaunchConfiguration configuration, IInterpreterRunner runner, InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            runner.run(config, launch, monitor);
        }
        catch (CoreException e) {
            AbstractScriptLaunchConfigurationDelegate.tryHandleStatus(e, runner);
        }
    }

    protected String getWorkingDir(ILaunchConfiguration configuration, IEnvironment environment) throws CoreException {
        return this.verifyWorkingDirectory(configuration, environment);
    }

    protected IPath[] createBuildPath(ILaunchConfiguration configuration) throws CoreException {
        return this.createBuildPath(configuration, this.getScriptEnvironment(configuration));
    }

    protected IPath[] createBuildPath(ILaunchConfiguration configuration, IEnvironment environment) throws CoreException {
        ArrayList<Path> paths = new ArrayList<Path>();
        String[] buildpath = this.getBuildpath(configuration, environment);
        int i = 0;
        while (i < buildpath.length) {
            paths.add(new Path(buildpath[i]));
            ++i;
        }
        String[] bootpath = this.getBootpath(configuration);
        if (bootpath != null) {
            int i2 = 0;
            while (i2 < bootpath.length) {
                paths.add(new Path(bootpath[i2]));
                ++i2;
            }
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.fOrderedProjects;
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.fOrderedProjects;
    }

    protected boolean isLaunchProblem(IMarker problemMarker) throws CoreException {
        return super.isLaunchProblem(problemMarker) && problemMarker.getType().equals("org.eclipse.dltk.core.problem");
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.subTask(LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_20);
        }
        this.fOrderedProjects = null;
        IScriptProject scriptProject = ScriptRuntime.getScriptProject(configuration);
        if (scriptProject != null) {
            this.fOrderedProjects = this.computeReferencedBuildOrder(new IProject[]{scriptProject.getProject()});
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    protected IBreakpoint[] getBreakpoints(ILaunchConfiguration configuration) {
        return new IBreakpoint[0];
    }

    public IInterpreterRunner getInterpreterRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        IInterpreterInstall install = this.verifyInterpreterInstall(configuration);
        IInterpreterRunner runner = install.getInterpreterRunner(mode);
        if (runner == null) {
            this.abort(MessageFormat.format((String)LaunchingMessages.InterpreterRunnerDoesntExist, (Object[])new String[]{install.getName(), mode}), null, 107);
        }
        return runner;
    }

    public String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
    }

    protected IPath getDefaultWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IEnvironment environment;
        IProject project = AbstractScriptLaunchConfigurationDelegate.getProject(configuration);
        if (project != null && (environment = EnvironmentManager.getEnvironment((IProject)project)) != null) {
            String mainScriptName = this.verifyMainScriptName(configuration);
            if (mainScriptName.length() == 0) {
                IFileHandle file;
                URI projectURI = project.getLocationURI();
                if (projectURI != null && (file = environment.getFile(projectURI)) != null) {
                    return file.getPath();
                }
            } else {
                IFileHandle file;
                Path scriptPath = new Path(mainScriptName);
                IFile mainScript = project.getFile((IPath)scriptPath);
                URI scriptURI = mainScript.getLocationURI();
                if (scriptURI != null && (file = environment.getFile(scriptURI)) != null) {
                    return file.getPath().removeLastSegments(scriptPath.segmentCount());
                }
            }
        }
        return null;
    }

    protected String getProjectLocation(ILaunchConfiguration configuration) throws CoreException {
        IProject project = AbstractScriptLaunchConfigurationDelegate.getScriptProject(configuration).getProject();
        String loc = null;
        URI location = project.getLocationURI();
        if (location == null) {
            loc = project.getLocation().toOSString();
            return null;
        }
        loc = location.getPath();
        return loc;
    }

    protected String getNatureId(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("nature", null);
    }

    public abstract String getLanguageId();

    public static ISourceModule getSourceModule(ILaunchConfiguration configuration) throws CoreException {
        String projectName = AbstractScriptLaunchConfigurationDelegate.getScriptProjectName(configuration);
        String mainScriptName = AbstractScriptLaunchConfigurationDelegate.getMainScriptName(configuration);
        IProject project = AbstractScriptLaunchConfigurationDelegate.getWorkspaceRoot().getProject(projectName);
        IFile script = project.getFile(mainScriptName);
        ISourceModule module = (ISourceModule)DLTKCore.create((IFile)script);
        return module;
    }
}

