/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.core.internal.interpreter.generic;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.koneki.ldt.core.IProjectSourceRootFolderVisitor2;
import org.eclipse.koneki.ldt.core.LuaUtils;
import org.eclipse.koneki.ldt.debug.core.interpreter.LuaInterpreterUtil;

public class LuaGenericInterpreterConfigurer {
    private static final String LUA_INIT_PATTERN = "?" + File.separator + "init.lua;";
    private static final String LUAC_INIT_PATTERN = "?" + File.separator + "init.luac;";

    public InterpreterConfig alterConfig(ILaunch launch, InterpreterConfig config, IInterpreterInstall interpreterinstall) throws CoreException {
        Map configEnvs = launch.getLaunchConfiguration().getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
        EnvironmentVariable[] interEnvs = interpreterinstall.getEnvironmentVariables();
        if (interEnvs != null) {
            EnvironmentVariable[] environmentVariableArray = interEnvs;
            int n = interEnvs.length;
            int n2 = 0;
            while (n2 < n) {
                EnvironmentVariable envVar = environmentVariableArray[n2];
                if (configEnvs == null || !configEnvs.containsKey(envVar.getName())) {
                    config.addEnvVar(envVar.getName(), envVar.getValue());
                }
                ++n2;
            }
        }
        for (Map.Entry<String, String> entry : this.addEnvironmentVariables(launch, config).entrySet()) {
            config.addEnvVar(entry.getKey(), entry.getValue());
        }
        List<String> commandList = this.addCommands(launch, config);
        if (!commandList.isEmpty() && LuaInterpreterUtil.interpreterHandlesExecuteOption(interpreterinstall)) {
            StringBuilder commands = new StringBuilder();
            for (String cmd : commandList) {
                commands.append(cmd);
            }
            config.addInterpreterArg("-e");
            config.addInterpreterArg(commands.toString());
        }
        return config;
    }

    protected List<String> addCommands(ILaunch launch, InterpreterConfig config) throws CoreException {
        return new ArrayList<String>();
    }

    protected Map<String, String> addEnvironmentVariables(ILaunch launch, InterpreterConfig config) throws CoreException {
        HashMap<String, String> envVars = new HashMap<String, String>();
        String envLuaPath = config.getEnvVar("LUA_PATH");
        String interpreterPath = this.createLuaPath(launch, config);
        if (envLuaPath != null) {
            envVars.put("LUA_PATH", String.valueOf(interpreterPath) + envLuaPath);
        } else {
            envVars.put("LUA_PATH", ";;" + interpreterPath);
        }
        return envVars;
    }

    protected String createLuaPath(ILaunch launch, InterpreterConfig config) throws CoreException {
        List<IPath> luaPath = this.getLuaPath(launch, config);
        StringBuilder command = new StringBuilder();
        for (IPath iPath : luaPath) {
            command.append(iPath.toOSString());
            command.append(File.separatorChar);
            command.append("?.lua;");
            command.append(iPath.toOSString());
            command.append(File.separatorChar);
            command.append(LUA_INIT_PATTERN);
            command.append(iPath.toOSString());
            command.append(File.separatorChar);
            command.append("?.luac;");
            command.append(iPath.toOSString());
            command.append(File.separatorChar);
            command.append(LUAC_INIT_PATTERN);
        }
        return command.toString();
    }

    protected List<IPath> getLuaPath(ILaunch launch, InterpreterConfig config) throws CoreException {
        String projectName = launch.getLaunchConfiguration().getAttribute("project", null);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        final ArrayList<IPath> luaPath = new ArrayList<IPath>();
        LuaUtils.visitRootSourceFolder((IScriptProject)DLTKCore.create((IProject)project), EnumSet.complementOf(EnumSet.of(LuaUtils.ProjectFragmentFilter.ARCHIVE, LuaUtils.ProjectFragmentFilter.EXECUTION_ENVIRONMENT)), (IProjectSourceRootFolderVisitor2)new IProjectSourceRootFolderVisitor2(){

            public void processSourceRootFolder(IProjectFragment scriptFolder, IPath absolutePath, IProgressMonitor monitor) throws CoreException {
                luaPath.add(absolutePath);
            }
        }, (IProgressMonitor)new NullProgressMonitor());
        return luaPath;
    }
}

