/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.text;

import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ui.editor.highlighting.AbortSemanticHighlightingException;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlighter;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlighterExtension;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingRequestor;
import org.eclipse.dltk.ui.editor.highlighting.SemanticHighlighting;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Item;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.LuaFileAPI;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Identifier;
import org.eclipse.koneki.ldt.ui.internal.Activator;
import org.eclipse.koneki.ldt.ui.internal.editor.text.LuaSemanticHighlighting;

public class LuaSemanticUpdateWorker
extends ASTVisitor
implements ISemanticHighlighter,
ISemanticHighlighterExtension {
    private static final String HL_LOCAL_VARIABLE = "variable.local";
    private static final String HL_GLOBAL_VARIABLE = "variable.global";
    private ISemanticHighlightingRequestor requestor;

    public SemanticHighlighting[] getSemanticHighlightings() {
        return new SemanticHighlighting[]{new LuaSemanticHighlighting(HL_LOCAL_VARIABLE, null), new LuaSemanticHighlighting(HL_GLOBAL_VARIABLE, null)};
    }

    public boolean visitGeneral(ASTNode node) throws Exception {
        if (node instanceof LuaSourceRoot) {
            return !((LuaSourceRoot)node).hasError();
        }
        if (node instanceof LuaFileAPI) {
            return false;
        }
        if (node instanceof Identifier) {
            Item item = ((Identifier)node).getDefinition();
            if (item != null) {
                if (LuaASTUtils.isLocalVariable((Item)item)) {
                    this.requestor.addPosition(node.sourceStart(), node.sourceEnd(), HL_LOCAL_VARIABLE);
                } else if (LuaASTUtils.isUnresolvedGlobal((Item)item) || LuaASTUtils.isGlobalVariable((Item)item)) {
                    this.requestor.addPosition(node.sourceStart(), node.sourceEnd(), HL_GLOBAL_VARIABLE);
                }
            } else {
                String formattedMessage = MessageFormat.format("{0} starting at offset {1} with length {2} has no definition.", node.getClass().getName(), node.matchStart(), node.matchLength());
                Activator.logWarning(formattedMessage);
            }
        }
        return true;
    }

    public String[] getHighlightingKeys() {
        HashSet<String> result = new HashSet<String>();
        SemanticHighlighting[] semanticHighlightingArray = this.getSemanticHighlightings();
        int n = semanticHighlightingArray.length;
        int n2 = 0;
        while (n2 < n) {
            SemanticHighlighting highlighting = semanticHighlightingArray[n2];
            result.add(highlighting.getPreferenceKey());
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    public void process(IModuleSource code, ISemanticHighlightingRequestor req) {
        this.requestor = req;
        try {
            ((ModuleDeclaration)this.parseCode(code)).traverse((ASTVisitor)this);
        }
        catch (ModelException modelException) {
            throw new AbortSemanticHighlightingException();
        }
        catch (Exception exception) {
            throw new AbortSemanticHighlightingException();
        }
    }

    protected IModuleDeclaration parseCode(IModuleSource code) throws ModelException {
        if (code instanceof ISourceModule) {
            return this.parseSourceModule((ISourceModule)code);
        }
        return this.parseSourceCode(code);
    }

    private IModuleDeclaration parseSourceCode(IModuleSource code) {
        return SourceParserUtil.parse((IModuleSource)code, (String)"org.eclipse.koneki.ldt.nature", null);
    }

    private IModuleDeclaration parseSourceModule(ISourceModule sourceModule) {
        return SourceParserUtil.parse((ISourceModule)sourceModule, null);
    }
}

