/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public final class LuaWordFinder {
    private LuaWordFinder() {
    }

    public static IRegion findWord(IDocument document, int offset) {
        int start = -2;
        int end = -1;
        try {
            start = LuaWordFinder.findWordStart(document, offset);
            end = LuaWordFinder.findWordEnd(document, offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    private static int findWordEnd(IDocument document, int offset) throws BadLocationException {
        int length = document.getLength();
        int pos = offset;
        while (pos < length) {
            char c = document.getChar(pos);
            if (!Character.isJavaIdentifierPart(c)) break;
            ++pos;
        }
        return pos;
    }

    private static int findWordStart(IDocument document, int offset) throws BadLocationException {
        int pos = offset;
        while (pos >= 0 && offset < document.getLength()) {
            char c = document.getChar(pos);
            if (!Character.isJavaIdentifierPart(c)) break;
            --pos;
        }
        return pos;
    }
}

