/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.preferences;

import java.util.ArrayList;
import org.eclipse.dltk.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class LuaCodeAssistConfigurationBlock
extends AbstractConfigurationBlock {
    private Control autoActivation;

    public LuaCodeAssistConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store) {
        super(store, mainPreferencePage);
        this.getPreferenceStore().addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        this.getOverlayKeys(overlayKeys);
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    protected void getOverlayKeys(ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys) {
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoactivation"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "content_assist_autoactivation_delay"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoinsert"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_insert_completion"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_sorter"));
    }

    public Control createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        Composite composite = this.createSubsection(control, null, PreferencesMessages.CodeAssistConfigurationBlock_insertionSection_title);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.addInsertionSection(composite);
        composite = this.createSubsection(control, null, PreferencesMessages.CodeAssistConfigurationBlock_autoactivationSection_title);
        composite.setLayout((Layout)layout);
        this.addAutoActivationSection(composite);
        return control;
    }

    protected void addAutoActivationSection(Composite composite) {
        String label = PreferencesMessages.DLTKEditorPreferencePage_enableAutoActivation;
        Button autoactivation = this.addCheckBox(composite, label, "content_assist_autoactivation", 2);
        autoactivation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LuaCodeAssistConfigurationBlock.this.updateAutoactivationControls();
            }
        });
        label = PreferencesMessages.DLTKEditorPreferencePage_autoActivationDelay;
        Control[] ctrl = this.addLabelledTextField(composite, label, "content_assist_autoactivation_delay", 4, 2, true);
        this.autoActivation = ctrl[1];
    }

    private void updateAutoactivationControls() {
        boolean autoactivation = this.getPreferenceStore().getBoolean("content_assist_autoactivation");
        if (this.autoActivation != null) {
            this.autoActivation.setEnabled(autoactivation);
        }
    }

    protected void addInsertionSection(Composite composite) {
        String label = PreferencesMessages.DLTKEditorPreferencePage_insertSingleProposalsAutomatically;
        this.addCheckBox(composite, label, "content_assist_autoinsert", 2);
    }

    protected void initializeFields() {
        super.initializeFields();
        this.updateAutoactivationControls();
    }
}

