/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.ast.models;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.koneki.ldt.core.internal.Activator;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.ExternalTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.FunctionTypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.InternalTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Item;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.LuaFileAPI;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.PrimitiveTypeRef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.RecordTypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.TypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaASTNode;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.core.internal.ast.models.dltk.FakeField;
import org.eclipse.koneki.ldt.core.internal.ast.models.dltk.FakeMethod;
import org.eclipse.koneki.ldt.core.internal.ast.models.dltk.IFakeElement;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LocalVar;

public final class LuaASTModelUtils {
    private LuaASTModelUtils() {
    }

    public static LuaSourceRoot getLuaSourceRoot(ISourceModule module) {
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)module);
        if (moduleDeclaration instanceof LuaSourceRoot) {
            return (LuaSourceRoot)moduleDeclaration;
        }
        return null;
    }

    public static ASTNode getASTNode(IModelElement modelElement) {
        if (modelElement instanceof IFakeElement) {
            return ((IFakeElement)modelElement).getLuaASTNode();
        }
        if (modelElement instanceof ISourceModule) {
            return LuaASTModelUtils.getLuaSourceRoot((ISourceModule)modelElement);
        }
        if (modelElement instanceof IType) {
            return LuaASTModelUtils.getTypeDef((IType)modelElement);
        }
        if (modelElement instanceof IField) {
            return LuaASTModelUtils.getItem((IField)modelElement);
        }
        if (modelElement instanceof IMethod) {
            return LuaASTModelUtils.getItem((IMethod)modelElement);
        }
        return null;
    }

    public static TypeDef getTypeDef(IType type) {
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(type.getSourceModule());
        LuaFileAPI fileapi = luaSourceRoot.getFileapi();
        return fileapi.getTypes().get(type.getElementName());
    }

    public static Item getItem(IField field) {
        block7: {
            IModelElement parent = field.getParent();
            if (parent instanceof IType) {
                RecordTypeDef typeDef = (RecordTypeDef)LuaASTModelUtils.getTypeDef((IType)parent);
                return typeDef.getFields().get(field.getElementName());
            }
            if (parent instanceof ISourceModule) {
                LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot((ISourceModule)parent);
                try {
                    if (Flags.isPrivate((int)field.getFlags())) {
                        List<LocalVar> localVars = luaSourceRoot.getInternalContent().getContent().getLocalVars();
                        for (LocalVar localVar : localVars) {
                            if (!localVar.getVar().getName().equals(field.getElementName())) continue;
                            return localVar.getVar();
                        }
                        break block7;
                    }
                    return luaSourceRoot.getFileapi().getGlobalvars().get(field.getElementName());
                }
                catch (ModelException e) {
                    Activator.logError("unable to get item from field " + field, e);
                    return null;
                }
            }
            if (parent instanceof IField) {
                Activator.logWarning("inline type is not managed by LuaASTModelUtils.getItem(IField) : unable to find item for " + field, null);
                return null;
            }
        }
        return null;
    }

    public static Item getItem(IMethod method) {
        block7: {
            IModelElement parent = method.getParent();
            if (parent instanceof IType) {
                RecordTypeDef typeDef = (RecordTypeDef)LuaASTModelUtils.getTypeDef((IType)parent);
                return typeDef.getFields().get(method.getElementName());
            }
            if (parent instanceof ISourceModule) {
                LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot((ISourceModule)parent);
                try {
                    if (Flags.isPrivate((int)method.getFlags())) {
                        List<LocalVar> localVars = luaSourceRoot.getInternalContent().getContent().getLocalVars();
                        for (LocalVar localVar : localVars) {
                            if (!localVar.getVar().getName().equals(method.getElementName())) continue;
                            return localVar.getVar();
                        }
                        break block7;
                    }
                    return luaSourceRoot.getFileapi().getGlobalvars().get(method.getElementName());
                }
                catch (ModelException e) {
                    Activator.logError("unable to get item from method " + method, e);
                    return null;
                }
            }
            if (parent instanceof IField) {
                Activator.logWarning("inline type is not managed by LuaASTModelUtils.getItem(IMethod) : unable to find item for " + method, null);
                return null;
            }
        }
        return null;
    }

    public static IType getIType(ISourceModule module, RecordTypeDef recordtypeDef) {
        if (LuaASTUtils.isInlineTypeDef(recordtypeDef)) {
            Activator.logWarning("inline type is not managed by LuaASTModelUtils.getIType() : unable to find IType for " + recordtypeDef, null);
            return null;
        }
        IType type = module.getType(recordtypeDef.getName());
        return type;
    }

    public static List<IMember> getIMembers(ISourceModule sourceModule, Item item) {
        ArrayList<IMember> results = new ArrayList<IMember>();
        LuaASTNode parent = item.getParent();
        if (LuaASTUtils.isTypeField(item) && !LuaASTUtils.isInlineTypeField(item)) {
            IType iType = LuaASTModelUtils.getIType(sourceModule, (RecordTypeDef)parent);
            if (iType != null) {
                try {
                    IModelElement[] iModelElementArray = iType.getChildren();
                    int n = iModelElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelElement child = iModelElementArray[n2];
                        if (child.getElementName().equals(item.getName()) && child instanceof IMember) {
                            results.add((IMember)child);
                            return results;
                        }
                        ++n2;
                    }
                }
                catch (ModelException e) {
                    Activator.logWarning("unable to get IMember corresponding to the given item " + item, e);
                }
            }
        } else {
            if (LuaASTUtils.isLocalVariable(item) || LuaASTUtils.isInlineTypeField(item) || LuaASTUtils.isGlobalVariable(item)) {
                LuaASTUtils.TypeResolution typeResolution;
                LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(sourceModule);
                int modifier = 0;
                if (LuaASTUtils.isModule(luaSourceRoot.getFileapi(), item)) {
                    modifier |= 0x400;
                } else if (LuaASTUtils.isPublic(item)) {
                    modifier |= 0x40;
                } else if (LuaASTUtils.isPrivate(item)) {
                    modifier |= 0x10;
                }
                LuaASTUtils.TypeResolution resolvedtype = LuaASTUtils.resolveType(sourceModule, item.getType());
                if (resolvedtype != null && resolvedtype.getTypeDef() instanceof FunctionTypeDef) {
                    FunctionTypeDef functionResolvedType = (FunctionTypeDef)resolvedtype.getTypeDef();
                    String[] parametersName = new String[functionResolvedType.getParameters().size()];
                    int i = 0;
                    while (i < parametersName.length) {
                        parametersName[i] = functionResolvedType.getParameters().get(i).getName();
                        ++i;
                    }
                    results.add((IMember)new FakeMethod(sourceModule, item.getName(), item.sourceStart(), item.getName().length(), parametersName, modifier, item));
                    return results;
                }
                String type = null;
                if (item.getType() instanceof PrimitiveTypeRef || item.getType() instanceof InternalTypeRef || item.getType() instanceof ExternalTypeRef) {
                    type = item.getType().toReadableString();
                }
                if ((typeResolution = LuaASTUtils.resolveType(sourceModule, item.getType())) != null && typeResolution.getTypeDef() instanceof RecordTypeDef) {
                    results.add((IMember)new FakeField(sourceModule, item.getName(), type, item.sourceStart(), item.getName().length(), modifier |= 8, item));
                    LuaASTUtils.TypeResolution resolvedCallType = LuaASTUtils.resolveType(typeResolution.getModule(), ((RecordTypeDef)typeResolution.getTypeDef()).getCallTypeRef());
                    if (resolvedCallType != null && resolvedCallType.getTypeDef() instanceof FunctionTypeDef) {
                        FunctionTypeDef functionResolvedType = (FunctionTypeDef)resolvedCallType.getTypeDef();
                        if (functionResolvedType.getParameters().size() > 1) {
                            String[] parametersName = new String[functionResolvedType.getParameters().size() - 1];
                            int i = 0;
                            while (i < parametersName.length) {
                                parametersName[i] = functionResolvedType.getParameters().get(i + 1).getName();
                                ++i;
                            }
                            results.add((IMember)new FakeMethod(resolvedCallType.getModule(), item.getName(), item.sourceStart(), item.getName().length(), parametersName, modifier, functionResolvedType));
                        } else {
                            results.add((IMember)new FakeMethod(resolvedCallType.getModule(), item.getName(), item.sourceStart(), item.getName().length(), new String[0], modifier, functionResolvedType));
                        }
                    }
                    return results;
                }
                results.add((IMember)new FakeField(sourceModule, item.getName(), type, item.sourceStart(), item.getName().length(), modifier, item));
                return results;
            }
            if (LuaASTUtils.isUnresolvedGlobal(item)) {
                results.add((IMember)new FakeField(sourceModule, item.getName(), null, item.sourceStart(), item.getName().length(), 8192, item));
                return results;
            }
        }
        return null;
    }

    public static IMember getIMember(ISourceModule sourceModule, Item item) {
        List<IMember> iMembers = LuaASTModelUtils.getIMembers(sourceModule, item);
        if (iMembers != null && iMembers.size() > 0) {
            return iMembers.get(0);
        }
        return null;
    }

    public static IModelElement getIModelElement(ISourceModule sourcemodule, LuaASTNode astNode) {
        if (astNode instanceof RecordTypeDef) {
            return LuaASTModelUtils.getIType(sourcemodule, (RecordTypeDef)astNode);
        }
        if (astNode instanceof Item) {
            return LuaASTModelUtils.getIMember(sourcemodule, (Item)astNode);
        }
        return null;
    }
}

