/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.ast.models;

import com.naef.jnlua.LuaState;
import com.naef.jnlua.NamedJavaFunction;
import java.util.ArrayList;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.LuaFileAPI;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaInternalContent;

public final class ModelFactory {
    private ModelFactory() {
    }

    public static final void registerModelFactory(LuaState l) {
        NamedJavaFunction[] namedJavaFunctions = ModelFactory.createFunctions();
        l.register("javamodelfactory", namedJavaFunctions);
    }

    private static NamedJavaFunction[] createFunctions() {
        ArrayList<NamedJavaFunction> javaFunctions = new ArrayList<NamedJavaFunction>();
        javaFunctions.add(ModelFactory.newSourceRoot());
        javaFunctions.add(ModelFactory.sourceRootSetProblem());
        javaFunctions.add(ModelFactory.sourceRootAddContent());
        return javaFunctions.toArray(new NamedJavaFunction[javaFunctions.size()]);
    }

    private static NamedJavaFunction newSourceRoot() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                int length = l.checkInteger(1);
                LuaSourceRoot sourceRoot = new LuaSourceRoot(length, true);
                l.pushJavaObject((Object)sourceRoot);
                return 1;
            }

            public String getName() {
                return "newsourceroot";
            }
        };
    }

    private static NamedJavaFunction sourceRootSetProblem() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                LuaSourceRoot sourceRoot = (LuaSourceRoot)((Object)l.checkJavaObject(1, LuaSourceRoot.class));
                int line = l.checkInteger(2);
                int column = l.checkInteger(3);
                int soffset = l.checkInteger(4);
                int eoffset = l.checkInteger(5);
                String message = l.checkString(6);
                sourceRoot.setProblem(line, column, soffset, eoffset, message);
                return 0;
            }

            public String getName() {
                return "setproblem";
            }
        };
    }

    private static NamedJavaFunction sourceRootAddContent() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                LuaSourceRoot sourceRoot = (LuaSourceRoot)((Object)l.checkJavaObject(1, LuaSourceRoot.class));
                LuaFileAPI fileAPI = (LuaFileAPI)((Object)l.checkJavaObject(2, LuaFileAPI.class));
                LuaInternalContent internalContent = (LuaInternalContent)((Object)l.checkJavaObject(3, LuaInternalContent.class));
                sourceRoot.setLuaFileApi(fileAPI);
                sourceRoot.setInternalContent(internalContent);
                return 0;
            }

            public String getName() {
                return "addcontent";
            }
        };
    }
}

