/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.commons.ui.dialogs;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.koneki.commons.ui.Activator;
import org.eclipse.koneki.commons.ui.dialogs.CDialog;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class CMessageDialog
extends CDialog {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int INFORMATION = 2;
    public static final int QUESTION = 3;
    public static final int WARNING = 4;
    private String message;
    private FormText messageFormText;
    private Label imageLabel;
    private String[] buttonLabels;
    private Button[] buttons;
    private int defaultButtonIndex;
    private String title;
    private Image titleImage;
    private Image image = null;
    private Control customArea;

    public CMessageDialog(Shell parentShell) {
        super(parentShell);
    }

    public CMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        this(parentShell);
        this.title = dialogTitle;
        this.titleImage = dialogTitleImage;
        this.message = dialogMessage;
        switch (dialogImageType) {
            case 1: {
                this.image = this.getErrorImage();
                break;
            }
            case 2: {
                this.image = this.getInfoImage();
                break;
            }
            case 3: {
                this.image = this.getQuestionImage();
                break;
            }
            case 4: {
                this.image = this.getWarningImage();
                break;
            }
        }
        this.buttonLabels = dialogButtonLabels;
        this.defaultButtonIndex = defaultIndex;
    }

    protected Control createMessageArea(Composite composite) {
        Image img = this.getImage();
        if (img != null) {
            this.imageLabel = new Label(composite, 0);
            img.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(img);
            this.addAccessibleListeners(this.imageLabel, img);
            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.imageLabel);
        }
        if (this.message != null) {
            this.messageFormText = new FormText(composite, this.getMessageLabelStyle());
            this.messageFormText.setWhitespaceNormalized(true);
            this.messageFormText.setText(this.message, true, true);
            this.messageFormText.setLayoutData((Object)new TableWrapData(128));
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.messageFormText);
            this.messageFormText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL((String)e.getHref()));
                    }
                    catch (PartInitException e1) {
                        Activator.log(e1);
                    }
                    catch (MalformedURLException e1) {
                        Activator.log(e1);
                    }
                }
            });
        }
        return composite;
    }

    private String getAccessibleMessageFor(Image img) {
        if (img.equals((Object)this.getErrorImage())) {
            return JFaceResources.getString((String)"error");
        }
        if (img.equals((Object)this.getWarningImage())) {
            return JFaceResources.getString((String)"warning");
        }
        if (img.equals((Object)this.getInfoImage())) {
            return JFaceResources.getString((String)"info");
        }
        if (img.equals((Object)this.getQuestionImage())) {
            return JFaceResources.getString((String)"question");
        }
        return null;
    }

    private void addAccessibleListeners(Label label, final Image img) {
        label.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                String accessibleMessage = CMessageDialog.this.getAccessibleMessageFor(img);
                if (accessibleMessage == null) {
                    return;
                }
                event.result = accessibleMessage;
            }
        });
    }

    protected int getMessageLabelStyle() {
        return 64;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(0).equalWidth(true).applyTo(composite);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).span(2, 1).applyTo((Control)composite);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    @Override
    protected void createContentArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Point defaultSpacing = LayoutConstants.getSpacing();
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).spacing(defaultSpacing.x * 2, defaultSpacing.y).numColumns(this.getColumnCount()).applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.createDialogAndButtonArea(parent);
    }

    int getColumnCount() {
        return 2;
    }

    protected void createDialogAndButtonArea(Composite parent) {
        this.dialogArea = this.createDialogArea(parent);
        this.buttonBar = this.createButtonBar(parent);
        CMessageDialog.applyDialogFont((Control)parent);
    }

    public Image getErrorImage() {
        return this.getSWTImage(1);
    }

    public Image getWarningImage() {
        return this.getSWTImage(8);
    }

    public Image getInfoImage() {
        return this.getSWTImage(2);
    }

    public Image getQuestionImage() {
        return this.getSWTImage(4);
    }

    private Image getSWTImage(final int imageID) {
        Shell shell = this.getShell();
        if (shell == null) {
            shell = this.getParentShell();
        }
        final Display display = shell == null ? Display.getCurrent() : shell.getDisplay();
        final Image[] img = new Image[1];
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                img[0] = display.getSystemImage(imageID);
            }
        });
        return img[0];
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
        if (this.titleImage != null) {
            shell.setImage(this.titleImage);
        }
        this.setMoveable(true);
        this.setBlockOnOpen(true);
        this.setTitleImage(null);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.buttons = new Button[this.buttonLabels.length];
        int i = 0;
        while (i < this.buttonLabels.length) {
            Button button;
            String label = this.buttonLabels[i];
            this.buttons[i] = button = this.createButton(parent, i, label, this.defaultButtonIndex == i);
            ++i;
        }
    }

    protected Control createCustomArea(Composite parent) {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        this.customArea = this.createCustomArea(composite);
        if (this.customArea == null) {
            this.customArea = new Label(composite, 0);
        }
        return composite;
    }

    protected Button getButton(int index) {
        return this.buttons[index];
    }

    protected int getMinimumMessageWidth() {
        return this.convertHorizontalDLUsToPixels(300);
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.setReturnCode(-1);
    }

    public static boolean openConfirm(Shell parent, String title, String message) {
        CMessageDialog dialog = new CMessageDialog(parent, title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        return dialog.open() == 0;
    }

    public static void openError(Shell parent, String title, String message) {
        CMessageDialog dialog = new CMessageDialog(parent, title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    public static void openInformation(Shell parent, String title, String message) {
        CMessageDialog dialog = new CMessageDialog(parent, title, null, message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    public static boolean openQuestion(Shell parent, String title, String message) {
        CMessageDialog dialog = new CMessageDialog(parent, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        return dialog.open() == 0;
    }

    public static void openWarning(Shell parent, String title, String message) {
        CMessageDialog dialog = new CMessageDialog(parent, title, null, message, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (defaultButton && !this.customShouldTakeFocus()) {
            button.setFocus();
        }
        return button;
    }

    protected boolean customShouldTakeFocus() {
        if (this.customArea instanceof Label) {
            return false;
        }
        if (this.customArea instanceof CLabel) {
            return (this.customArea.getStyle() & 0x80000) > 0;
        }
        return true;
    }

    public Image getImage() {
        return this.image;
    }

    protected String[] getButtonLabels() {
        return this.buttonLabels;
    }

    protected int getDefaultButtonIndex() {
        return this.defaultButtonIndex;
    }

    protected void setButtons(Button[] buttons) {
        if (buttons == null) {
            throw new NullPointerException("The array of buttons cannot be null.");
        }
        this.buttons = buttons;
    }

    protected void setButtonLabels(String[] buttonLabels) {
        if (buttonLabels == null) {
            throw new NullPointerException("The array of button labels cannot be null.");
        }
        this.buttonLabels = buttonLabels;
    }
}

