/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.editor.internal.dashboard;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.koneki.protocols.omadm.DMItem;
import org.eclipse.koneki.protocols.omadm.DMNode;
import org.eclipse.koneki.protocols.omadm.ProtocolListener;
import org.eclipse.koneki.protocols.omadm.Status;
import org.eclipse.koneki.simulators.omadm.editor.internal.Activator;
import org.eclipse.koneki.simulators.omadm.editor.internal.dashboard.DashboardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

final class ConnectProtocolListener
implements ProtocolListener {
    private final DashboardPage page;
    private TreeItem sessionCommandItem;
    private TreeItem sessionMessageItem;
    private TreeItem phaseMessageItem;
    private boolean isSetupPhase;
    private boolean isManagementPhase;

    public ConnectProtocolListener(DashboardPage page) {
        this.page = page;
    }

    public void sessionBegin(final String sessionID) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ConnectProtocolListener.this.sessionCommandItem = new TreeItem(ConnectProtocolListener.this.page.getCommandsViewTree(), 0);
                ConnectProtocolListener.this.sessionCommandItem.setText(new String[]{"Session " + sessionID, "", ""});
                Image[] imageArray = new Image[3];
                imageArray[0] = Activator.getDefault().getImage("icons/obj16/session.png");
                ConnectProtocolListener.this.sessionCommandItem.setImage(imageArray);
                ConnectProtocolListener.this.sessionMessageItem = new TreeItem(ConnectProtocolListener.this.page.getMessagesViewTree(), 0);
                ConnectProtocolListener.this.sessionMessageItem.setText("Session " + sessionID);
                ConnectProtocolListener.this.sessionMessageItem.setImage(Activator.getDefault().getImage("icons/obj16/session.png"));
            }
        });
    }

    public void sessionEnd() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ConnectProtocolListener.this.page.getConnectIcon().setEnabled(true);
            }
        });
    }

    public void sessionEnd(final Throwable t) {
        this.sessionEnd();
        Activator.log(t);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)ConnectProtocolListener.this.page.getEditor().getSite().getShell(), (String)"Simulation", (String)t.getMessage());
            }
        });
    }

    public void setupPhaseBegin() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ConnectProtocolListener.this.phaseMessageItem = new TreeItem(ConnectProtocolListener.this.sessionMessageItem, 0);
                ConnectProtocolListener.this.phaseMessageItem.setText("Setup phase");
                ConnectProtocolListener.this.phaseMessageItem.setImage(Activator.getDefault().getImage("icons/obj16/phase.png"));
                ConnectProtocolListener.this.expandIfNot(ConnectProtocolListener.this.sessionMessageItem);
            }
        });
        this.isSetupPhase = true;
    }

    public void setupPhaseEnd() {
        this.isSetupPhase = false;
    }

    public void managementPhaseBegin() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ConnectProtocolListener.this.phaseMessageItem = new TreeItem(ConnectProtocolListener.this.sessionMessageItem, 0);
                ConnectProtocolListener.this.phaseMessageItem.setText("Management phase");
                ConnectProtocolListener.this.phaseMessageItem.setImage(Activator.getDefault().getImage("icons/obj16/phase.png"));
                ConnectProtocolListener.this.expandIfNot(ConnectProtocolListener.this.sessionMessageItem);
            }
        });
        this.isManagementPhase = true;
    }

    public void managementPhaseEnd() {
        this.isManagementPhase = false;
    }

    public void newClientPackage(String message) {
        this.newPackage("Package " + this.getClientPackageNumber(), message, Activator.getDefault().getImage("icons/obj16/client_package.png"));
    }

    public void newServerPackage(String message) {
        this.newPackage("Package " + this.getServerPackageNumber(), message, Activator.getDefault().getImage("icons/obj16/server_package.png"));
    }

    private void newPackage(final String text, final String message, final Image image) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TreeItem item = new TreeItem(ConnectProtocolListener.this.phaseMessageItem, 0);
                item.setText(text);
                item.setData((Object)ConnectProtocolListener.prettyPrint(message));
                item.setImage(image);
                ConnectProtocolListener.this.expandIfNot(ConnectProtocolListener.this.phaseMessageItem);
            }
        });
    }

    public void clientAlert(String alertCode, String correlator, DMItem[] items, Status status) {
        StringBuffer sb = new StringBuffer();
        sb.append("Alert - Code: ").append(alertCode);
        if (correlator != null) {
            sb.append(", Correlator: ").append(correlator);
        }
        if (alertCode.equals("1226")) {
            this.genericAlert(sb, items[0]);
        }
        this.clientCommand(sb.toString(), Activator.getDefault().getImage("icons/obj16/alert_command.png"), status);
    }

    private void genericAlert(StringBuffer sb, DMItem item) {
        sb.append(", Type: ").append(item.getMeta().getType()).append(", Result: ").append(item.getData());
    }

    public void get(String target, Status status) {
        this.serverCommand("Get - Target: " + target, Activator.getDefault().getImage("icons/obj16/get_command.png"), status);
    }

    public void add(String target, String data, Status status) {
        this.serverCommand("Add - Target: " + target + ", Data: " + data, Activator.getDefault().getImage("icons/obj16/add_command.png"), status);
    }

    public void copy(String target, String source, Status status) {
        this.serverCommand("Copy - Target: " + target + ", Source: " + source, Activator.getDefault().getImage("icons/obj16/copy_command.png"), status);
    }

    public void delete(String target, Status status) {
        this.serverCommand("Delete - Target: " + target, Activator.getDefault().getImage("icons/obj16/delete_command.png"), status);
    }

    public void exec(String target, String correlator, String data, Status status) {
        StringBuffer sb = new StringBuffer();
        sb.append("Exec - Target: ").append(target);
        if (correlator != null) {
            sb.append(", Correlator: ").append(correlator);
        }
        if (data != null) {
            sb.append(", Data: ").append(data);
        }
        this.serverCommand(sb.toString(), Activator.getDefault().getImage("icons/obj16/exec_command.png"), status);
    }

    public void replace(String target, String data, Status status) {
        this.serverCommand("Replace - Target: " + target + ", Data: " + data, Activator.getDefault().getImage("icons/obj16/replace_command.png"), status);
    }

    private void clientCommand(String commandText, Image commandImage, Status status) {
        this.command(ConnectProtocolListener.getTextStatus(status), commandText, ConnectProtocolListener.getImageStatus(status), commandImage);
    }

    private void serverCommand(String commandText, Image commandImage, Status status) {
        this.command(commandText, ConnectProtocolListener.getTextStatus(status), commandImage, ConnectProtocolListener.getImageStatus(status));
    }

    private static String getTextStatus(Status status) {
        StringBuffer sb = new StringBuffer();
        sb.append("Status - Code: ").append(status.getCode()).append(" ").append(status.getDescription());
        DMNode results = status.getResult();
        if (results != null) {
            sb.append(", Result: ").append(results.getData());
        }
        return sb.toString();
    }

    private static Image getImageStatus(Status status) {
        return Activator.getDefault().getImage(status.getCode() < 300 ? "icons/obj16/status_ok.png" : "icons/obj16/status_fail.png");
    }

    private void command(final String textCol1, final String textCol2, final Image imageCol1, final Image imageCol2) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TreeItem item = new TreeItem(ConnectProtocolListener.this.sessionCommandItem, 0);
                String[] stringArray = new String[3];
                stringArray[1] = textCol1;
                stringArray[2] = textCol2;
                item.setText(stringArray);
                Image[] imageArray = new Image[3];
                imageArray[1] = imageCol1;
                imageArray[2] = imageCol2;
                item.setImage(imageArray);
                ConnectProtocolListener.this.expandIfNot(ConnectProtocolListener.this.sessionCommandItem);
            }
        });
    }

    private void expandIfNot(TreeItem item) {
        if (!item.getExpanded()) {
            item.setExpanded(true);
        }
    }

    private String getClientPackageNumber() {
        if (this.isSetupPhase) {
            return "1";
        }
        if (this.isManagementPhase) {
            return "3";
        }
        return null;
    }

    private String getServerPackageNumber() {
        if (this.isSetupPhase) {
            return "2";
        }
        if (this.isManagementPhase) {
            return "4";
        }
        return null;
    }

    private static String prettyPrint(String xml) {
        StreamSource xmlInput = new StreamSource(new StringReader(xml));
        StreamResult xmlOutput = new StreamResult(new StringWriter());
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (TransformerException ex) {
            Activator.log(ex);
            return xml;
        }
    }
}

