/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.simulators.omadm.editor.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.koneki.simulators.omadm.editor.Messages;
import org.eclipse.koneki.simulators.omadm.editor.wizards.NewOMADMSimulationWizard;
import org.eclipse.koneki.simulators.omadm.model.Device;
import org.eclipse.koneki.simulators.omadm.model.OMADMSimulatorFactory;
import org.eclipse.koneki.simulators.omadm.model.util.DeviceHelpers;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class DevCreationWizardPage
extends WizardPage
implements IWizardPage {
    private final Device device = OMADMSimulatorFactory.eINSTANCE.createDevice();
    private Text deviceIDText;
    private Text serverPasswordText;
    private Text serverLoginText;
    private Text serverURIText;

    public DevCreationWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite devCreationComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(devCreationComposite);
        Label serverURILabel = new Label(devCreationComposite, 0);
        serverURILabel.setText(Messages.ConfigurationPage_ServerURI);
        GridDataFactory.fillDefaults().grab(false, false).span(0, 0).applyTo((Control)serverURILabel);
        this.serverURIText = new Text(devCreationComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 0).applyTo((Control)this.serverURIText);
        Label label = new Label(devCreationComposite, 0);
        label.setText(Messages.ConfigurationPage_ServerLogin);
        GridDataFactory.fillDefaults().grab(false, false).span(0, 0).applyTo((Control)label);
        this.serverLoginText = new Text(devCreationComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 0).applyTo((Control)this.serverLoginText);
        label = new Label(devCreationComposite, 0);
        label.setText(Messages.ConfigurationPage_ServerPassword);
        GridDataFactory.fillDefaults().grab(false, false).span(0, 0).applyTo((Control)label);
        this.serverPasswordText = new Text(devCreationComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 0).applyTo((Control)this.serverPasswordText);
        label = new Label(devCreationComposite, 0);
        label.setText(Messages.ConfigurationPage_DeviceID);
        GridDataFactory.fillDefaults().grab(false, false).span(0, 0).applyTo((Control)label);
        this.deviceIDText = new Text(devCreationComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 0).applyTo((Control)this.deviceIDText);
        this.hookListeners();
        this.setControl((Control)devCreationComposite);
    }

    protected IContainer getSelectedContainer() {
        return ((NewOMADMSimulationWizard)this.getWizard()).getProject();
    }

    protected void validatePage() {
        this.device.setDeviceId(this.deviceIDText.getText());
        if (!DeviceHelpers.isValidDeviceId((Device)this.device)) {
            this.setMessage(Messages.Wizard_DeviceID_Is_Invalid, 3);
            this.setPageComplete(false);
        } else {
            this.setMessage(null);
            this.setPageComplete(true);
        }
    }

    protected void hookListeners() {
        this.deviceIDText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DevCreationWizardPage.this.validatePage();
            }
        });
    }

    public Device getDevice() {
        this.device.setServerUrl(this.serverURIText.getText());
        this.device.setLogin(this.serverLoginText.getText());
        this.device.setPassword(this.serverPasswordText.getText());
        this.device.setDeviceId(this.deviceIDText.getText());
        return this.device;
    }
}

