/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.emfforms.editor;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.util.JFaceProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.AcceptAllFilter;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.emfforms.editor.EmfActionBarContributor;
import org.eclipse.pde.emfforms.editor.EmfFormEditor;
import org.eclipse.pde.emfforms.editor.PDEFormToolkit;
import org.eclipse.pde.emfforms.editor.actions.RemoveAction;
import org.eclipse.pde.emfforms.internal.Activator;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EmfMasterDetailBlock
extends MasterDetailsBlock
implements IDetailsPageProvider,
IMenuListener {
    public static final int DEFAULT_SECTION_OPTIONS = 384;
    public static final int DEFAULT_VIEWER_OPTIONS = 2816;
    protected EmfFormEditor<?> parentEditor;
    public static final int NO_BUTTONS = 0;
    public static final int USE_GENERIC_TOOLBAR_BUTTONS = 1;
    public static final int USE_GENERIC_PUSH_BUTTONS = 2;
    public static final int USE_CUSTOM_PUSH_BUTTONS = 4;
    public static final int USE_EXPAND_COLLAPSE_BUTTONS = 8;
    protected int buttonOption = 1;
    private String title;
    private TreeViewer treeViewer;
    private Button addButton;
    private Button removeButton;
    protected ToolBarManager toolBarManager;
    private IAction removeAction;
    private Section section;

    public EmfMasterDetailBlock(EmfFormEditor<?> editor, String title) {
        this.title = title;
        this.parentEditor = editor;
    }

    public EmfMasterDetailBlock(EmfFormEditor<?> editor, String title, int buttonOption) {
        this(editor, title);
        this.buttonOption = buttonOption;
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = this.parentEditor.getToolkit();
        this.section = toolkit.createSection(parent, this.getSectionOptions());
        this.section.setText(this.title);
        this.section.setDescription("Edit " + this.title);
        this.section.marginWidth = 5;
        this.section.setLayout((Layout)new FillLayout());
        this.section.marginHeight = 5;
        Composite client = toolkit.createComposite((Composite)this.section, 64);
        GridLayoutFactory.fillDefaults().numColumns(this.showPushButtons() ? 2 : 1).applyTo(client);
        FilteredTree ft = new FilteredTree(client, this.getViewerOptions(), new PatternFilter());
        this.treeViewer = ft.getViewer();
        GridDataFactory.fillDefaults().grab(true, true).hint(50, 50).applyTo((Control)this.treeViewer.getTree());
        if (this.showPushButtons()) {
            Composite buttonComposite = new Composite(client, 0);
            GridLayoutFactory.fillDefaults().numColumns(1).applyTo(buttonComposite);
            if (this.showGenericPushButtons()) {
                this.addButton = this.createButton(buttonComposite, "Add");
            }
            if (this.showCustomPushButtons()) {
                this.createCustomButtons(buttonComposite);
            }
            if (this.showGenericPushButtons()) {
                this.removeButton = this.createButton(buttonComposite, "Remove");
            }
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)buttonComposite);
        }
        this.removeAction = this.createCustomToolbarRemoveAction();
        if (this.showToolbarButtons()) {
            this.toolBarManager = PDEFormToolkit.createSectionToolBarManager((Composite)this.section);
            Action addAction = this.createCustomToolbarAddAction();
            if (addAction != null) {
                this.toolBarManager.add((IAction)addAction);
            }
            if (this.removeAction != null) {
                this.toolBarManager.add(this.removeAction);
            }
            if (this.showExpandCollapseButtons()) {
                this.toolBarManager.add((IContributionItem)new Separator());
                this.toolBarManager.add((IAction)new Action("Expand All", Activator.getImageDescriptor("icons/obj16/expand.gif")){

                    public void run() {
                        EmfMasterDetailBlock.this.treeViewer.getTree().setRedraw(false);
                        EmfMasterDetailBlock.this.treeViewer.expandAll();
                        EmfMasterDetailBlock.this.treeViewer.getTree().setRedraw(true);
                    }
                });
                this.toolBarManager.add((IAction)new Action("Collapse All", Activator.getImageDescriptor("icons/obj16/collapse.gif")){

                    public void run() {
                        EmfMasterDetailBlock.this.treeViewer.getTree().setRedraw(false);
                        EmfMasterDetailBlock.this.treeViewer.collapseAll();
                        EmfMasterDetailBlock.this.treeViewer.getTree().setRedraw(true);
                    }
                });
            }
            this.toolBarManager.update(true);
            this.section.setTextClient((Control)this.toolBarManager.getControl());
        }
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.parentEditor.getAdapterFactory()));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.parentEditor.getAdapterFactory()), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.treeViewer.addFilter(this.getTreeFilter());
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        this.treeViewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)this.treeViewer));
        this.treeViewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter(this.parentEditor.getEditingDomain(), (Viewer)this.treeViewer));
        final SectionPart spart = new SectionPart(this.section);
        managedForm.addPart((IFormPart)spart);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
            }
        });
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                EmfMasterDetailBlock.this.detailsPart.setFocus();
            }
        });
        this.configureActionBarManagement();
        if (this.getRemoveButton() != null) {
            DataBindingContext bindingContext = new DataBindingContext();
            IValueProperty p = JFaceProperties.value(IAction.class, (String)"enabled", (String)"enabled");
            bindingContext.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.getRemoveButton()), p.observe((Object)this.removeAction));
            this.getRemoveButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (EmfMasterDetailBlock.this.removeAction != null) {
                        EmfMasterDetailBlock.this.removeAction.run();
                    }
                }
            });
        }
        this.createContextMenuFor((StructuredViewer)this.treeViewer);
        this.getEditor().addViewerToListenTo((StructuredViewer)this.getTreeViewer());
        this.section.setClient((Control)client);
    }

    protected int getSectionOptions() {
        return 384;
    }

    protected int getViewerOptions() {
        return 2816;
    }

    protected void configureActionBarManagement() {
        final IEditorActionBarContributor actionBarContributor = this.getEditor().getEditorSite().getActionBarContributor();
        if (actionBarContributor != null && actionBarContributor instanceof EmfActionBarContributor) {
            this.treeViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ((EmfActionBarContributor)actionBarContributor).enableGlobalHandlers();
                }

                public void focusLost(FocusEvent e) {
                    ((EmfActionBarContributor)actionBarContributor).disableGlobalHandlers();
                }
            });
        }
    }

    private boolean showPushButtons() {
        return this.showCustomPushButtons() || this.showGenericPushButtons();
    }

    private boolean showCustomPushButtons() {
        return (this.buttonOption & 4) > 0;
    }

    private boolean showGenericPushButtons() {
        return (this.buttonOption & 2) > 0;
    }

    private boolean showToolbarButtons() {
        return (this.buttonOption & 1) > 0;
    }

    private boolean showExpandCollapseButtons() {
        return this.showToolbarButtons() && (this.buttonOption & 8) > 0;
    }

    protected Action createCustomToolbarAddAction() {
        return null;
    }

    protected Action createCustomToolbarRemoveAction() {
        return new RemoveAction(this);
    }

    protected Button createButton(Composite parent, String btnText) {
        Button btn = new Button(parent, 0x800008);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)btn);
        btn.setText(btnText);
        return btn;
    }

    protected ViewerFilter getTreeFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return true;
            }
        };
    }

    protected void createToolBarActions(IManagedForm managedForm) {
    }

    protected void registerPages(DetailsPart detailsPart) {
        detailsPart.setPageProvider((IDetailsPageProvider)this);
    }

    public Object getPageKey(Object object) {
        return AdapterFactoryEditingDomain.unwrap((Object)object).getClass();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public Button getGenericAddButton() {
        return this.addButton;
    }

    protected void createCustomButtons(Composite parent) {
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public void setAddButton(Button addButton) {
        this.addButton = addButton;
    }

    public void setRemoveButton(Button removeButton) {
        this.removeButton = removeButton;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        IEditorActionBarContributor actionBarContributor = this.parentEditor.getEditorSite().getActionBarContributor();
        if (actionBarContributor != null && actionBarContributor instanceof EmfActionBarContributor) {
            ((EmfActionBarContributor)actionBarContributor).setCreateChildMenuFilter(this.getCreateChildContextMenuFilter());
            ((EmfActionBarContributor)actionBarContributor).setCreateSiblingMenuFilter(this.getCreateSiblingContextMenuFilter());
        }
        this.parentEditor.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
    }

    protected IFilter getCreateChildContextMenuFilter() {
        return AcceptAllFilter.getInstance();
    }

    protected IFilter getCreateSiblingContextMenuFilter() {
        return AcceptAllFilter.getInstance();
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.parentEditor.getEditorSite().getActionBarContributor() != null) {
            ((IMenuListener)this.parentEditor.getEditorSite().getActionBarContributor()).menuAboutToShow(manager);
        }
    }

    public EmfFormEditor<?> getEditor() {
        return this.parentEditor;
    }

    public void setButtonOption(int buttonOption) {
        this.buttonOption = buttonOption;
    }
}

