/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.evaluation.types;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.evaluation.types.IFunctionType;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class FunctionType
implements IFunctionType {
    private MethodDeclaration fMethod;
    private ModuleDeclaration fModule;
    private boolean fWrongCall = false;

    public FunctionType(ModuleDeclaration module, MethodDeclaration method) {
        this.fMethod = method;
        this.fModule = module;
    }

    public FunctionType(ModuleDeclaration module, MethodDeclaration method, boolean wrongCall) {
        this.fMethod = method;
        this.fModule = module;
        this.fWrongCall = wrongCall;
    }

    @Override
    public String getTypeName() {
        String add = "";
        if (this.fWrongCall) {
            add = " wrong arguments call";
        }
        if (this.fMethod != null) {
            return "function:" + this.fMethod.getName() + add;
        }
        return "function: !!unknown!!";
    }

    public ASTNode getFunction() {
        return this.fMethod;
    }

    @Override
    public boolean subtypeOf(IEvaluatedType type) {
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fMethod == null ? 0 : this.fMethod.hashCode());
        result = 31 * result + (this.fModule == null ? 0 : this.fModule.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionType other = (FunctionType)obj;
        if (this.fMethod == null ? other.fMethod != null : !this.fMethod.equals(other.fMethod)) {
            return false;
        }
        return !(this.fModule == null ? other.fModule != null : !this.fModule.equals(other.fModule));
    }
}

