/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.dltk.debug.core.model.AtomicScriptType;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptType;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugElement;
import org.eclipse.dltk.internal.debug.core.model.ScriptVariableWrapperValue;

public class ScriptVariableWrapper
extends ScriptDebugElement
implements IScriptVariable {
    final IDebugTarget target;
    private final String name;
    private IVariable[] children;
    private IScriptValue value = null;

    public ScriptVariableWrapper(IDebugTarget target, String name, IVariable[] children) {
        this.target = target;
        this.name = name;
        this.children = children;
    }

    public IVariable[] getChildren() throws DebugException {
        if (this.children == null) {
            return new IScriptVariable[0];
        }
        return (IScriptVariable[])this.children.clone();
    }

    public String getEvalName() {
        return this.name;
    }

    @Override
    public String getId() {
        return null;
    }

    public String getValueString() {
        return "";
    }

    public boolean hasChildren() {
        if (this.children == null) {
            return false;
        }
        return this.children.length > 0;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return "getReferenceTypeName";
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public boolean shouldHasChildren() {
        return false;
    }

    public IScriptType getType() {
        return new AtomicScriptType("getType");
    }

    public IScriptStackFrame getStackFrame() {
        return null;
    }

    public IValue getValue() throws DebugException {
        if (this.value == null) {
            this.value = new ScriptVariableWrapperValue(this);
        }
        return this.value;
    }

    public IDebugTarget getDebugTarget() {
        return this.target;
    }

    public void refreshValue(IVariable[] newChildren) {
        this.children = newChildren;
    }
}

