/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.ProjectRefreshOperation;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.corext.util.Resources;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class RefreshAction
extends SelectionDispatchAction {
    public RefreshAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.RefreshAction_label);
        this.setToolTipText(ActionMessages.RefreshAction_toolTip);
        DLTKPluginImages.setLocalImageDescriptors((IAction)this, "refresh_nav.gif");
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return true;
        }
        for (Object element : selection) {
            if (element instanceof IWorkingSet) continue;
            if (element instanceof IAdaptable) {
                IResource resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
                if (resource == null) {
                    return false;
                }
                if (resource.getType() != 4 || ((IProject)resource).isOpen()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public void run(IStructuredSelection selection) {
        final IResource[] resources = this.getResources(selection);
        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                SubMonitor progess = SubMonitor.convert((IProgressMonitor)monitor, (String)ActionMessages.RefreshAction_progressMessage, (int)(resources.length * 2));
                ArrayList<IModelElement> modelElements = new ArrayList<IModelElement>(5);
                HashSet<IProject> affectedProjects = new HashSet<IProject>();
                int r = 0;
                while (r < resources.length) {
                    IResource resource = resources[r];
                    if (resource.getType() == 4) {
                        RefreshAction.this.checkLocationDeleted((IProject)resource);
                        affectedProjects.add((IProject)resource);
                    } else if (resource.getType() == 8) {
                        IProject[] projects = ((IWorkspaceRoot)resource).getProjects();
                        int p = 0;
                        while (p < projects.length) {
                            RefreshAction.this.checkLocationDeleted(projects[p]);
                            affectedProjects.add(projects[p]);
                            ++p;
                        }
                    } else {
                        affectedProjects.add(resource.getProject());
                    }
                    resource.refreshLocal(2, (IProgressMonitor)progess.newChild(1));
                    IModelElement jElement = DLTKCore.create((IResource)resource);
                    if (jElement != null && jElement.exists()) {
                        modelElements.add(jElement);
                    }
                    ++r;
                }
                if (DLTKCore.DEBUG) {
                    System.err.println("Add refreshing of external archives...");
                }
                ArrayList<IScriptProject> scriptProjects = new ArrayList<IScriptProject>(affectedProjects.size());
                for (IProject project : affectedProjects) {
                    if (!project.exists() || !DLTKLanguageManager.hasScriptNature((IProject)project)) continue;
                    scriptProjects.add(DLTKCore.create((IProject)project));
                }
                if (!scriptProjects.isEmpty()) {
                    ProjectRefreshOperation modelRefresh = new ProjectRefreshOperation(scriptProjects.toArray(new IScriptProject[scriptProjects.size()]));
                    modelRefresh.run((IProgressMonitor)progess.newChild(resources.length));
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.RefreshAction_error_title, ActionMessages.RefreshAction_error_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IResource[] getResources(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
        }
        ArrayList<IResource> result = new ArrayList<IResource>(selection.size());
        this.getResources(result, selection.toArray());
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            if (!this.isDescendent(result, resource)) continue;
            iter.remove();
        }
        return result.toArray(new IResource[result.size()]);
    }

    private void getResources(List<IResource> result, Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            IResource resource;
            Object element = elements[i];
            if (element instanceof IWorkingSet) {
                this.getResources(result, ((IWorkingSet)element).getElements());
            } else if (element instanceof IAdaptable && (resource = (IResource)((IAdaptable)element).getAdapter(IResource.class)) != null && (resource.getType() != 4 || resource.getType() == 4 && ((IProject)resource).isOpen())) {
                result.add(resource);
            }
            ++i;
        }
    }

    private boolean isDescendent(List<IResource> candidates, IResource element) {
        IContainer parent = element.getParent();
        while (parent != null) {
            if (candidates.contains(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private void checkLocationDeleted(IProject project) throws CoreException {
        if (!project.exists()) {
            return;
        }
        URI location = project.getLocationURI();
        if (location == null) {
            return;
        }
        IFileStore store = EFS.getStore((URI)location);
        if (!store.fetchInfo().exists()) {
            final String message = Messages.format(ActionMessages.RefreshAction_locationDeleted_message, new Object[]{project.getName(), Resources.getLocationString((IResource)project)});
            final boolean[] result = new boolean[1];
            this.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = MessageDialog.openQuestion((Shell)RefreshAction.this.getShell(), (String)ActionMessages.RefreshAction_locationDeleted_title, (String)message);
                }
            });
            if (result[0]) {
                project.delete(true, true, null);
            }
        }
    }
}

