/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.resources.IResourcesRegistry;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.resources.ResourceByDefinitionKey;
import org.eclipse.e4.ui.css.swt.resources.SWTResourcesRegistry;
import org.eclipse.e4.ui.internal.workbench.PartServiceSaveHandler;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.SWTRenderersMessages;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.e4.ui.workbench.modeling.IWindowCloseHandler;
import org.eclipse.e4.ui.workbench.renderers.swt.CSSEngineHelper;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimmedPartLayout;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.EventHandler;

public class WBWRenderer
extends SWTPartRenderer {
    private static String ShellMinimizedTag = "shellMinimized";
    private static String ShellMaximizedTag = "shellMaximized";
    WindowSizeUpdateJob boundsJob;
    boolean ignoreSizeChanges = false;
    @Inject
    Logger logger;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IPresentationEngine engine;
    private EventHandler topWindowHandler;
    private EventHandler shellUpdater;
    private EventHandler visibilityHandler;
    private EventHandler sizeHandler;
    private ThemeDefinitionChangedHandler themeDefinitionChanged;
    @Inject
    private EModelService modelService;
    @Inject
    private IEclipseContext context;

    void clearSizeUpdate() {
        this.boundsJob = null;
    }

    private boolean closeDetachedWindow(MWindow window) {
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        List parts = this.modelService.findElements((MUIElement)window, null, MPart.class, null);
        for (MPart part : parts) {
            if (partService.savePart(part, true)) continue;
            return false;
        }
        for (MPart part : parts) {
            partService.hidePart(part);
        }
        return true;
    }

    @PostConstruct
    public void init() {
        this.topWindowHandler = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                if (!(event.getProperty("ChangedElement") instanceof MApplication)) {
                    return;
                }
                MWindow win = (MWindow)event.getProperty("NewValue");
                if (win == null || !win.getTags().contains("topLevel")) {
                    return;
                }
                win.setToBeRendered(true);
                if (win.getRenderer() != WBWRenderer.this) {
                    return;
                }
                Shell shell = (Shell)win.getWidget();
                if (shell.getMinimized()) {
                    shell.setMinimized(false);
                }
                shell.setActive();
                shell.moveAbove(null);
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", this.topWindowHandler);
        this.shellUpdater = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                Object objElement = event.getProperty("ChangedElement");
                if (!(event.getProperty("ChangedElement") instanceof MWindow)) {
                    return;
                }
                MWindow windowModel = (MWindow)objElement;
                if (windowModel.getRenderer() != WBWRenderer.this) {
                    return;
                }
                Shell theShell = (Shell)windowModel.getWidget();
                if (theShell == null) {
                    return;
                }
                String attName = (String)event.getProperty("AttName");
                if ("label".equals(attName) || "localizedLabel".equals(attName)) {
                    String newTitle = (String)event.getProperty("NewValue");
                    theShell.setText(newTitle);
                } else if ("iconURI".equals(attName)) {
                    theShell.setImage(WBWRenderer.this.getImage((MUILabel)windowModel));
                } else if ("tooltip".equals(attName) || "localizedTooltip".equals(attName)) {
                    String newTTip = (String)event.getProperty("NewValue");
                    theShell.setToolTipText(newTTip);
                }
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UILabel/*", this.shellUpdater);
        this.visibilityHandler = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                Object objElement = event.getProperty("ChangedElement");
                if (!(objElement instanceof MWindow)) {
                    return;
                }
                MWindow windowModel = (MWindow)objElement;
                if (windowModel.getRenderer() != WBWRenderer.this) {
                    return;
                }
                Shell theShell = (Shell)windowModel.getWidget();
                if (theShell == null) {
                    return;
                }
                String attName = (String)event.getProperty("AttName");
                if ("visible".equals(attName)) {
                    boolean isVisible = (Boolean)event.getProperty("NewValue");
                    theShell.setVisible(isVisible);
                }
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/visible/*", this.visibilityHandler);
        this.sizeHandler = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                if (WBWRenderer.this.ignoreSizeChanges) {
                    return;
                }
                Object objElement = event.getProperty("ChangedElement");
                if (!(objElement instanceof MWindow)) {
                    return;
                }
                MWindow windowModel = (MWindow)objElement;
                if (windowModel.getRenderer() != WBWRenderer.this) {
                    return;
                }
                Shell theShell = (Shell)windowModel.getWidget();
                if (theShell == null) {
                    return;
                }
                String attName = (String)event.getProperty("AttName");
                if ("x".equals(attName) || "y".equals(attName) || "width".equals(attName) || "height".equals(attName)) {
                    if (WBWRenderer.this.boundsJob == null) {
                        WBWRenderer.this.boundsJob = new WindowSizeUpdateJob();
                        WBWRenderer.this.boundsJob.windowsToUpdate.add(windowModel);
                        theShell.getDisplay().asyncExec((Runnable)WBWRenderer.this.boundsJob);
                    } else if (!WBWRenderer.this.boundsJob.windowsToUpdate.contains(windowModel)) {
                        WBWRenderer.this.boundsJob.windowsToUpdate.add(windowModel);
                    }
                }
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/basic/Window/*", this.sizeHandler);
        this.themeDefinitionChanged = new ThemeDefinitionChangedHandler();
        this.eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/themeDefinitionChanged", (EventHandler)this.themeDefinitionChanged);
    }

    @PreDestroy
    public void contextDisposed() {
        this.eventBroker.unsubscribe(this.topWindowHandler);
        this.eventBroker.unsubscribe(this.shellUpdater);
        this.eventBroker.unsubscribe(this.visibilityHandler);
        this.eventBroker.unsubscribe(this.sizeHandler);
        this.eventBroker.unsubscribe((EventHandler)this.themeDefinitionChanged);
        this.themeDefinitionChanged.dispose();
    }

    public Object createWidget(MUIElement element, Object parent) {
        Rectangle displayBounds;
        Shell wbwShell;
        int style;
        if (!(element instanceof MWindow) || parent != null && !(parent instanceof Control)) {
            return null;
        }
        MWindow wbwModel = (MWindow)element;
        MApplication appModel = (MApplication)wbwModel.getContext().get(MApplication.class);
        Boolean rtlMode = (Boolean)appModel.getTransientData().get("dir");
        int rtlStyle = rtlMode != null && rtlMode != false ? 0x4000000 : 0;
        Shell parentShell = parent == null ? null : ((Control)parent).getShell();
        int styleOverride = this.getStyleOverride((MUIElement)wbwModel) | rtlStyle;
        if (parentShell == null) {
            style = styleOverride == -1 ? 0x4F0 | rtlStyle : styleOverride;
            wbwShell = new Shell(Display.getCurrent(), style);
            wbwModel.getTags().add("topLevel");
        } else {
            style = 0x470 | rtlStyle;
            style = styleOverride == -1 ? style : styleOverride;
            wbwShell = new Shell(parentShell, style);
            wbwShell.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2) {
                        e.doit = false;
                    }
                }
            });
        }
        wbwShell.setBackgroundMode(1);
        Rectangle modelBounds = wbwShell.getBounds();
        if (wbwModel instanceof EObject) {
            EObject wbw = (EObject)wbwModel;
            EClass wbwclass = wbw.eClass();
            if (wbw.eIsSet(wbwclass.getEStructuralFeature("x"))) {
                modelBounds.x = wbwModel.getX();
            }
            if (wbw.eIsSet(wbwclass.getEStructuralFeature("y"))) {
                modelBounds.y = wbwModel.getY();
            }
            if (wbw.eIsSet(wbwclass.getEStructuralFeature("height"))) {
                modelBounds.height = wbwModel.getHeight();
            }
            if (wbw.eIsSet(wbwclass.getEStructuralFeature("width"))) {
                modelBounds.width = wbwModel.getWidth();
            }
        }
        if (!modelBounds.intersects(displayBounds = Display.getCurrent().getBounds())) {
            Rectangle clientArea = Display.getCurrent().getClientArea();
            modelBounds.x = clientArea.x;
            modelBounds.y = clientArea.y;
        }
        wbwShell.setBounds(modelBounds);
        this.setCSSInfo((MUIElement)wbwModel, wbwShell);
        IEclipseContext localContext = this.getContext((MUIElement)wbwModel);
        CSSEngineHelper helper = new CSSEngineHelper(localContext, (Control)wbwShell);
        TrimmedPartLayout tl = new TrimmedPartLayout((Composite)wbwShell);
        tl.gutterTop = helper.getMarginTop(0);
        tl.gutterBottom = helper.getMarginBottom(0);
        tl.gutterLeft = helper.getMarginLeft(0);
        tl.gutterRight = helper.getMarginRight(0);
        wbwShell.setLayout((Layout)tl);
        Shell newWidget = wbwShell;
        this.bindWidget(element, newWidget);
        localContext.set(Shell.class.getName(), (Object)wbwShell);
        localContext.set("localActiveShell", (Object)wbwShell);
        this.setCloseHandler(wbwModel);
        localContext.set(IShellProvider.class.getName(), (Object)new IShellProvider(){

            public Shell getShell() {
                return wbwShell;
            }
        });
        PartServiceSaveHandler saveHandler = new PartServiceSaveHandler(){

            public ISaveHandler.Save promptToSave(MPart dirtyPart) {
                Shell shell = (Shell)WBWRenderer.this.context.get("activeShell");
                Object[] elements = WBWRenderer.this.promptForSave(shell, Collections.singleton(dirtyPart));
                if (elements == null) {
                    return ISaveHandler.Save.CANCEL;
                }
                return elements.length == 0 ? ISaveHandler.Save.NO : ISaveHandler.Save.YES;
            }

            public ISaveHandler.Save[] promptToSave(Collection<MPart> dirtyParts) {
                ArrayList<MPart> parts = new ArrayList<MPart>(dirtyParts);
                Shell shell = (Shell)WBWRenderer.this.context.get("activeShell");
                Object[] response = new ISaveHandler.Save[dirtyParts.size()];
                Object[] elements = WBWRenderer.this.promptForSave(shell, parts);
                if (elements == null) {
                    Arrays.fill(response, ISaveHandler.Save.CANCEL);
                } else {
                    Arrays.fill(response, ISaveHandler.Save.NO);
                    int i = 0;
                    while (i < elements.length) {
                        response[parts.indexOf((Object)elements[i])] = ISaveHandler.Save.YES;
                        ++i;
                    }
                }
                return response;
            }
        };
        saveHandler.logger = this.logger;
        localContext.set(ISaveHandler.class, (Object)saveHandler);
        if (wbwModel.getLabel() != null) {
            wbwShell.setText(wbwModel.getLocalizedLabel());
        }
        if (wbwModel.getIconURI() != null && wbwModel.getIconURI().length() > 0) {
            wbwShell.setImage(this.getImage((MUILabel)wbwModel));
        } else {
            wbwShell.setImages(Window.getDefaultImages());
        }
        return newWidget;
    }

    private void setCloseHandler(MWindow window) {
        IEclipseContext context = window.getContext();
        if (window.getParent() == null) {
            context.set(IWindowCloseHandler.class.getName(), (Object)new IWindowCloseHandler(){

                public boolean close(MWindow window) {
                    return WBWRenderer.this.closeDetachedWindow(window);
                }
            });
        } else {
            context.set(IWindowCloseHandler.class.getName(), (Object)new IWindowCloseHandler(){

                public boolean close(MWindow window) {
                    EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
                    return partService.saveAll(true);
                }
            });
        }
    }

    @Override
    public void hookControllerLogic(MUIElement me) {
        super.hookControllerLogic(me);
        Widget widget = (Widget)me.getWidget();
        if (widget instanceof Shell && me instanceof MWindow) {
            final Shell shell = (Shell)widget;
            final MWindow w = (MWindow)me;
            shell.addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    if (shell.getMaximized()) {
                        return;
                    }
                    try {
                        WBWRenderer.this.ignoreSizeChanges = true;
                        w.setWidth(shell.getSize().x);
                        w.setHeight(shell.getSize().y);
                    }
                    finally {
                        WBWRenderer.this.ignoreSizeChanges = false;
                    }
                }

                public void controlMoved(ControlEvent e) {
                    if (shell.getMaximized()) {
                        return;
                    }
                    try {
                        WBWRenderer.this.ignoreSizeChanges = true;
                        w.setX(shell.getLocation().x);
                        w.setY(shell.getLocation().y);
                    }
                    finally {
                        WBWRenderer.this.ignoreSizeChanges = false;
                    }
                }
            });
            shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent e) {
                    e.doit = false;
                    MWindow window = (MWindow)e.widget.getData("modelElement");
                    IWindowCloseHandler closeHandler = (IWindowCloseHandler)window.getContext().get(IWindowCloseHandler.class.getName());
                    if (closeHandler == null || closeHandler.close(window)) {
                        WBWRenderer.this.cleanUp(window);
                    }
                }
            });
            shell.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    MElementContainer parentME = w.getParent();
                    if (parentME instanceof MApplication) {
                        MApplication app = (MApplication)parentME;
                        app.setSelectedElement((MUIElement)w);
                        w.getContext().activate();
                    } else if (parentME == null && (parentME = (MUIElement)((EObject)w).eContainer()) instanceof MContext) {
                        w.getContext().activate();
                    }
                    WBWRenderer.this.updateNonFocusState(26, w);
                }
            });
            shell.addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    WBWRenderer.this.updateNonFocusState(27, w);
                }
            });
        }
    }

    private void updateNonFocusState(int event, MWindow win) {
        MPerspective perspective = this.modelService.getActivePerspective(win);
        if (perspective == null) {
            return;
        }
        List stacks = this.modelService.findElements((MUIElement)perspective, null, MPartStack.class, Arrays.asList("active"));
        if (stacks.isEmpty()) {
            return;
        }
        MPartStack stack = (MPartStack)stacks.get(0);
        int tagsCount = stack.getTags().size();
        boolean hasNonFocusTag = stack.getTags().contains("noFocus");
        if (event == 26 && hasNonFocusTag) {
            stack.getTags().remove("noFocus");
        } else if (event == 27 && !hasNonFocusTag) {
            stack.getTags().add("noFocus");
        }
        if (tagsCount != stack.getTags().size()) {
            this.setCSSInfo((MUIElement)stack, stack.getWidget());
        }
    }

    private void cleanUp(MWindow window) {
        EObject parent = ((EObject)window).eContainer();
        if (parent instanceof MApplication) {
            MApplication application = (MApplication)parent;
            List children = application.getChildren();
            if (children.size() > 1) {
                window.setToBeRendered(false);
                children.remove(window);
            } else {
                this.engine.removeGui((MUIElement)window);
            }
        } else if (parent != null) {
            window.setToBeRendered(false);
            if (this.modelService.findElements((MUIElement)window, null, MPart.class, null).isEmpty()) {
                if (parent instanceof MWindow) {
                    ((MWindow)parent).getWindows().remove(window);
                } else if (parent instanceof MPerspective) {
                    ((MPerspective)parent).getWindows().remove(window);
                }
            }
        }
    }

    @Override
    public void processContents(MElementContainer<MUIElement> me) {
        Shell shell;
        if (!(me instanceof MWindow)) {
            return;
        }
        MWindow wbwModel = (MWindow)me;
        super.processContents(me);
        IPresentationEngine renderer = (IPresentationEngine)this.context.get(IPresentationEngine.class.getName());
        if (wbwModel.getMainMenu() != null) {
            renderer.createGui((MUIElement)wbwModel.getMainMenu(), me.getWidget(), null);
            shell = (Shell)me.getWidget();
            shell.setMenuBar((Menu)wbwModel.getMainMenu().getWidget());
        }
        for (MWindow dw : wbwModel.getWindows()) {
            renderer.createGui((MUIElement)dw, me.getWidget(), wbwModel.getContext());
        }
        if (wbwModel instanceof MTrimmedWindow) {
            shell = (Shell)wbwModel.getWidget();
            MTrimmedWindow tWindow = (MTrimmedWindow)wbwModel;
            ArrayList trimBars = new ArrayList(tWindow.getTrimBars());
            for (MTrimBar trimBar : trimBars) {
                renderer.createGui((MUIElement)trimBar, (Object)shell, wbwModel.getContext());
                if (trimBar.isVisible()) continue;
                trimBar.setVisible(true);
                trimBar.setVisible(false);
            }
        }
    }

    public Object getUIContainer(MUIElement element) {
        MElementContainer parent = element.getParent();
        if (parent == null) {
            parent = (MUIElement)((EObject)element).eContainer();
            return parent == null ? null : parent.getWidget();
        }
        Composite shellComp = (Composite)element.getParent().getWidget();
        TrimmedPartLayout tpl = (TrimmedPartLayout)shellComp.getLayout();
        return tpl.clientArea;
    }

    public void postProcess(MUIElement shellME) {
        super.postProcess(shellME);
        Shell shell = (Shell)shellME.getWidget();
        final MUIElement disposeME = shellME;
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Shell shell = (Shell)e.widget;
                if (disposeME != null) {
                    disposeME.getTags().remove(ShellMinimizedTag);
                    disposeME.getTags().remove(ShellMaximizedTag);
                    if (shell.getMinimized()) {
                        disposeME.getTags().add(ShellMinimizedTag);
                    }
                    if (shell.getMaximized()) {
                        disposeME.getTags().add(ShellMaximizedTag);
                    }
                }
            }
        });
        if (shellME.getTags().contains(ShellMaximizedTag)) {
            shell.setMaximized(true);
        } else if (shellME.getTags().contains(ShellMinimizedTag)) {
            shell.setMinimized(true);
        }
        shell.layout(true);
        this.forceLayout(shell);
        if (shellME.isVisible()) {
            shell.open();
        } else {
            shell.setVisible(false);
        }
    }

    private Object[] promptForSave(Shell parentShell, Collection<MPart> saveableParts) {
        SaveablePartPromptDialog dialog = new SaveablePartPromptDialog(parentShell, saveableParts);
        if (dialog.open() == 1) {
            return null;
        }
        return dialog.getCheckedElements();
    }

    private void applyDialogStyles(Control control) {
        IStylingEngine engine = (IStylingEngine)this.context.get(IStylingEngine.SERVICE_NAME);
        if (engine != null) {
            Shell shell = control.getShell();
            if (shell.getBackgroundMode() == 0) {
                shell.setBackgroundMode(1);
            }
            engine.style((Object)shell);
        }
    }

    private void forceLayout(Shell shell) {
        int i = 0;
        while (shell.isLayoutDeferred()) {
            shell.setLayoutDeferred(false);
            ++i;
        }
        while (i > 0) {
            shell.setLayoutDeferred(true);
            --i;
        }
    }

    class SaveablePartPromptDialog
    extends Dialog {
        private Collection<MPart> collection;
        private CheckboxTableViewer tableViewer;
        private Object[] checkedElements;

        SaveablePartPromptDialog(Shell shell, Collection<MPart> collection) {
            super(shell);
            this.checkedElements = new Object[0];
            this.collection = collection;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(SWTRenderersMessages.choosePartsToSaveTitle);
        }

        protected Control createDialogArea(Composite parent) {
            parent = (Composite)super.createDialogArea(parent);
            Label label = new Label(parent, 16384);
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            label.setText(SWTRenderersMessages.choosePartsToSave);
            this.tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2052);
            GridData data = new GridData(4, 4, true, true);
            data.heightHint = 250;
            data.widthHint = 300;
            this.tableViewer.getControl().setLayoutData((Object)data);
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((MPart)element).getLocalizedLabel();
                }
            });
            this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.tableViewer.setInput(this.collection);
            this.tableViewer.setAllChecked(true);
            return parent;
        }

        public void create() {
            super.create();
            WBWRenderer.this.applyDialogStyles((Control)this.getShell());
        }

        protected void okPressed() {
            this.checkedElements = this.tableViewer.getCheckedElements();
            super.okPressed();
        }

        public Object[] getCheckedElements() {
            return this.checkedElements;
        }

        protected boolean isResizable() {
            return true;
        }
    }

    protected static class ThemeDefinitionChangedHandler
    implements EventHandler {
        protected Set<Resource> unusedResources = new HashSet<Resource>();

        protected ThemeDefinitionChangedHandler() {
        }

        public void handleEvent(org.osgi.service.event.Event event) {
            Object element = event.getProperty("org.eclipse.e4.data");
            if (!(element instanceof MApplication)) {
                return;
            }
            HashSet<CSSEngine> engines = new HashSet<CSSEngine>();
            for (MWindow window : ((MApplication)element).getChildren()) {
                CSSEngine engine = this.getEngine(window);
                if (engine == null) continue;
                engines.add(engine);
            }
            for (CSSEngine engine : engines) {
                for (Object resource : this.removeResources(engine.getResourcesRegistry())) {
                    if (!(resource instanceof Resource) || ((Resource)resource).isDisposed()) continue;
                    this.unusedResources.add((Resource)resource);
                }
                engine.reapply();
            }
        }

        protected CSSEngine getEngine(MWindow window) {
            return WidgetElement.getEngine((Widget)((Widget)window.getWidget()));
        }

        protected List<Object> removeResources(IResourcesRegistry registry) {
            if (registry instanceof SWTResourcesRegistry) {
                return ((SWTResourcesRegistry)registry).removeResourcesByKeyTypeAndType(ResourceByDefinitionKey.class, new Class[]{Font.class, Color.class});
            }
            return Collections.emptyList();
        }

        public void dispose() {
            for (Resource resource : this.unusedResources) {
                if (resource.isDisposed()) continue;
                resource.dispose();
            }
            this.unusedResources.clear();
        }
    }

    private class WindowSizeUpdateJob
    implements Runnable {
        public List<MWindow> windowsToUpdate = new ArrayList<MWindow>();

        private WindowSizeUpdateJob() {
        }

        @Override
        public void run() {
            WBWRenderer.this.clearSizeUpdate();
            while (!this.windowsToUpdate.isEmpty()) {
                MWindow window = this.windowsToUpdate.remove(0);
                Shell shell = (Shell)window.getWidget();
                if (shell == null || shell.isDisposed()) continue;
                shell.setBounds(window.getX(), window.getY(), window.getWidth(), window.getHeight());
            }
        }
    }
}

