/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.ast.parser;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.dltk.ast.parser.AbstractSourceParser;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.koneki.ldt.core.LuaUtils;
import org.eclipse.koneki.ldt.core.internal.Activator;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaDLTKModelUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.LuaFileAPI;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaInternalContent;
import org.eclipse.koneki.ldt.core.internal.ast.parser.EncodingVisitor;
import org.eclipse.koneki.ldt.core.internal.ast.parser.ModelsBuilderLuaModule;
import org.eclipse.koneki.ldt.core.internal.ast.parser.OffsetFixer;
import org.eclipse.osgi.util.NLS;

public class LuaSourceParser
extends AbstractSourceParser {
    private static ModelsBuilderLuaModule astBuilder = new ModelsBuilderLuaModule();
    private static Map<IModelElement, IModuleDeclaration> cache = new Hashtable<IModelElement, IModuleDeclaration>();
    private static IElementChangedListener changedListener = new IElementChangedListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void elementChanged(ElementChangedEvent event) {
            Class<LuaSourceParser> clazz = LuaSourceParser.class;
            synchronized (LuaSourceParser.class) {
                IModelElementDelta delta = event.getDelta();
                this.processDelta(delta);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        private void processDelta(IModelElementDelta delta) {
            IModelElement element = delta.getElement();
            if (element.getElementType() == 5) {
                if (delta.getKind() == 2) {
                    cache.remove(element);
                } else if (delta.getKind() == 4 && delta.getFlags() == 65536) {
                    cache.remove(element);
                }
            }
            if (delta.getFlags() == 128 && delta.getAffectedChildren().length == 0) {
                for (IModelElement sourcemodule : new ArrayList(cache.keySet())) {
                    if (!LuaDLTKModelUtils.isAncestor(sourcemodule, element)) continue;
                    cache.remove(sourcemodule);
                }
            }
            if ((delta.getFlags() & 8) != 0) {
                IModelElementDelta[] affectedChildren = delta.getAffectedChildren();
                int i = 0;
                while (i < affectedChildren.length) {
                    IModelElementDelta child = affectedChildren[i];
                    this.processDelta(child);
                    ++i;
                }
            }
        }
    };

    static {
        DLTKCore.addElementChangedListener((IElementChangedListener)changedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModuleDeclaration parse(IModuleSource input, IProblemReporter reporter) {
        String source = input.getSourceContents();
        String moduleName = LuaUtils.getModuleFullName(input);
        LuaSourceRoot module = new LuaSourceRoot(source.length());
        OffsetFixer fixer = new OffsetFixer(source);
        Class<LuaSourceParser> clazz = LuaSourceParser.class;
        synchronized (LuaSourceParser.class) {
            try {
                module = astBuilder.buildAST(source, moduleName);
                if (module != null) {
                    module.traverse(new EncodingVisitor(fixer));
                }
            }
            catch (Exception e) {
                Activator.logWarning(NLS.bind((String)"Unable to parse file {0}.", (Object)input.getFileName()), e);
                if (module == null) {
                    module = new LuaSourceRoot(source.length());
                }
                module.setProblem(1, 1, 0, 0, "This file probably contains a syntax error.");
            }
            if (module != null) {
                if (module.hasError()) {
                    DefaultProblem problem = module.getProblem();
                    problem.setOriginatingFileName(input.getFileName());
                    reporter.reportProblem((IProblem)problem);
                    if (problem.getSourceEnd() < 0) {
                        try {
                            int line = problem.getSourceLineNumber();
                            Document document = new Document(source);
                            int endLineOffset = document.getLineOffset(line) + document.getLineLength(line) - 1;
                            problem.setSourceStart(fixer.getCharacterPosition(problem.getSourceStart()));
                            problem.setSourceEnd(endLineOffset);
                        }
                        catch (BadLocationException e) {
                            Activator.logWarning("Unable to retrive error offset", e);
                        }
                    } else {
                        problem.setSourceStart(fixer.getCharacterPosition(problem.getSourceStart()));
                        problem.setSourceEnd(fixer.getCharacterPosition(problem.getSourceEnd()));
                    }
                    if (input.getModelElement() != null) {
                        if (module.getFileapi() == null || module.getInternalContent() == null) {
                            LuaSourceRoot cached = (LuaSourceRoot)cache.get(input.getModelElement());
                            if (cached != null) {
                                cached.setError(true);
                                // ** MonitorExit[var7_7] (shouldn't be in output)
                                return cached;
                            }
                            module.setLuaFileApi(new LuaFileAPI());
                            module.setInternalContent(new LuaInternalContent());
                        } else {
                            cache.put(input.getModelElement(), (IModuleDeclaration)module);
                        }
                    }
                } else if (input.getModelElement() != null) {
                    cache.put(input.getModelElement(), (IModuleDeclaration)module);
                }
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return module;
        }
    }
}

