/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.commons.ui;

import java.lang.reflect.Method;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.koneki.commons.ui.widgets.InfoBanner;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public final class UIUtil {
    public static final int DATABINDING_DELAY = 500;
    public static final long FADE_RESCHEDULE_DELAY = 80L;
    public static final int FADE_IN_INCREMENT = 30;
    public static final int FADE_OUT_INCREMENT = -20;

    private UIUtil() {
    }

    public static void collectItemData(TreeItem[] items, Set<Object> allVisible) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            allVisible.add(item.getData());
            UIUtil.collectItemData(item.getItems(), allVisible);
            ++n2;
        }
    }

    public static boolean setAlpha(Shell shell, int value) {
        Method method = null;
        try {
            method = shell.getClass().getMethod("setAlpha", Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)shell, value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int getAlpha(Shell shell) {
        Method method = null;
        try {
            method = shell.getClass().getMethod("getAlpha", new Class[0]);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)shell, new Object[0]);
        }
        catch (Exception exception) {
            return 255;
        }
    }

    public static FadeJob fastFadeIn(Shell shell, IFadeListener listener) {
        return new FadeJob(shell, 60, 80L, listener);
    }

    public static FadeJob fadeIn(Shell shell, IFadeListener listener) {
        return new FadeJob(shell, 30, 80L, listener);
    }

    public static FadeJob fadeIn(Shell shell, int finalAlpha, IFadeListener listener) {
        return new FadeJob(shell, 30, 80L, finalAlpha, listener);
    }

    public static FadeJob fadeOut(Shell shell, IFadeListener listener) {
        return new FadeJob(shell, -20, 80L, listener);
    }

    public static void fade(Shell shell, boolean fadeIn, int increment, int speed) {
        block9: {
            try {
                Method method = shell.getClass().getMethod("setAlpha", Integer.TYPE);
                method.setAccessible(true);
                if (fadeIn) {
                    int i = 0;
                    while (i <= 120) {
                        method.invoke((Object)shell, i);
                        try {
                            Thread.sleep(speed);
                        }
                        catch (InterruptedException interruptedException) {}
                        i += increment;
                    }
                    break block9;
                }
                int i = 244;
                while (i >= 0) {
                    method.invoke((Object)shell, i);
                    try {
                        Thread.sleep(speed);
                    }
                    catch (InterruptedException interruptedException) {}
                    i -= increment;
                }
                method.invoke((Object)shell, 0);
            }
            catch (Exception exception) {}
        }
    }

    public static void setDefaultLocation(Shell parentShell, Shell shell, int location, int horizontalOffset, int verticalOffset) {
        int x = parentShell.getBounds().x;
        int y = parentShell.getBounds().y;
        int w = parentShell.getBounds().width;
        int h = parentShell.getBounds().height;
        int x2 = shell.getLocation().x;
        int y2 = shell.getLocation().y;
        int w2 = shell.getBounds().width;
        int h2 = shell.getBounds().height;
        switch (location) {
            case 0x1000000: {
                x2 = x + (w - w2) / 2 + horizontalOffset;
                y2 = y + (h - h2) / 2 + verticalOffset;
                break;
            }
            case 131072: {
                x2 = x + w + horizontalOffset;
                y2 = y + verticalOffset;
                break;
            }
            case 16384: {
                x2 = x - w2 - horizontalOffset;
                y2 = y + verticalOffset;
                break;
            }
        }
        shell.setLocation(x2, y2);
    }

    public static void centerShell(Shell shell) {
        Display display = shell.getDisplay();
        Monitor primaryMonitor = display.getPrimaryMonitor();
        Rectangle bounds = primaryMonitor.getBounds();
        int widthDiff = bounds.width - shell.getBounds().width;
        int heightDiff = bounds.height - shell.getBounds().height;
        int x = widthDiff / 2;
        int y = heightDiff / 2;
        shell.setLocation(x, y);
    }

    public static void setEnabled(Control control, boolean state) {
        if (control.isDisposed()) {
            return;
        }
        control.setEnabled(state);
        if (control instanceof Composite && !(control instanceof InfoBanner)) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                UIUtil.setEnabled(child, state);
                ++n2;
            }
        }
    }

    public static class FadeJob
    extends Job {
        private final Shell shell;
        private final int increment;
        private volatile boolean stopped;
        private volatile int currentAlpha;
        private final long delay;
        private final IFadeListener fadeListener;
        private final int finalAlpha;

        public FadeJob(Shell shell, int increment, long delay, IFadeListener fadeListener) {
            this(shell, increment, delay, 255, fadeListener);
        }

        public FadeJob(Shell shell, int increment, long delay, int finalAlpha, IFadeListener fadeListener) {
            super("Fading");
            this.finalAlpha = finalAlpha;
            if (increment < -finalAlpha || increment == 0 || increment > finalAlpha) {
                throw new IllegalArgumentException("-" + finalAlpha + " <= increment <= " + finalAlpha + " && increment != 0");
            }
            if (delay < 1L) {
                throw new IllegalArgumentException("delay must be > 0");
            }
            this.currentAlpha = UIUtil.getAlpha(shell);
            this.shell = shell;
            this.increment = increment;
            this.delay = delay;
            this.fadeListener = fadeListener;
            this.setSystem(true);
            this.schedule(delay);
        }

        protected void canceling() {
            this.stopped = true;
        }

        private void reschedule() {
            if (this.stopped) {
                return;
            }
            this.schedule(this.delay);
        }

        public void cancelAndWait(final boolean setAlpha) {
            if (this.stopped) {
                return;
            }
            this.cancel();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (setAlpha) {
                        UIUtil.setAlpha(FadeJob.this.shell, FadeJob.this.getLastAlpha());
                    }
                }
            });
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.stopped) {
                return Status.OK_STATUS;
            }
            this.currentAlpha += this.increment;
            if (this.currentAlpha <= 0) {
                this.currentAlpha = 0;
            } else if (this.currentAlpha >= this.finalAlpha) {
                this.currentAlpha = this.finalAlpha;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (FadeJob.this.stopped) {
                        return;
                    }
                    if (FadeJob.this.shell.isDisposed()) {
                        FadeJob.this.stopped = true;
                        return;
                    }
                    if (!UIUtil.setAlpha(FadeJob.this.shell, FadeJob.this.currentAlpha)) {
                        FadeJob.this.currentAlpha = FadeJob.this.getLastAlpha();
                        UIUtil.setAlpha(FadeJob.this.shell, FadeJob.this.currentAlpha);
                        FadeJob.this.stopped = true;
                    }
                    if (FadeJob.this.fadeListener != null) {
                        FadeJob.this.fadeListener.faded(FadeJob.this.shell, FadeJob.this.currentAlpha);
                    }
                }
            });
            if (this.currentAlpha == 0 || this.currentAlpha == this.finalAlpha) {
                this.stopped = true;
            }
            this.reschedule();
            return Status.OK_STATUS;
        }

        private int getLastAlpha() {
            return this.increment < 0 ? 0 : this.finalAlpha;
        }
    }

    public static interface IFadeListener {
        public void faded(Shell var1, int var2);
    }
}

