/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.commons.ui.dialogs;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.koneki.commons.ui.ColorRegistry;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RoundedCornerBorderedComposite
extends Composite {
    public static final Color DEFAULT_GRADIENT_BEGIN_COLOR = ColorRegistry.COLOR_LIGHT_GREY;
    public static final Color DEFAULT_GRADIENT_END_COLOR = ColorRegistry.COLOR_WHITE;
    public static final Color DEFAULT_BORDER_COLOR = ColorRegistry.COLOR_GREY;
    private Composite innerContent;
    private Color gradientBeginColor = DEFAULT_GRADIENT_BEGIN_COLOR;
    private Color gradientEndColor = DEFAULT_GRADIENT_END_COLOR;
    private Color borderColor = DEFAULT_BORDER_COLOR;
    private Image lastUsedBgImage;
    private Composite outerCircle;

    public RoundedCornerBorderedComposite(Composite parent) {
        super(parent, 0);
        this.createContents();
    }

    private void createContents() {
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo((Composite)this);
        this.outerCircle = new Composite((Composite)this, 524288);
        this.outerCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        this.outerCircle.setBackgroundMode(2);
        this.outerCircle.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                RoundedCornerBorderedComposite.this.drawWidget();
            }
        });
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.outerCircle.setLayout((Layout)layout);
        Composite outerContentCircle = new Composite(this.outerCircle, 0);
        outerContentCircle.setBackgroundMode(2);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        outerContentCircle.setLayout((Layout)layout);
        outerContentCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        outerContentCircle.setBackground(this.outerCircle.getBackground());
        Composite middleContentCircle = new Composite(outerContentCircle, 524288);
        middleContentCircle.setBackgroundMode(2);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 1;
        middleContentCircle.setLayout((Layout)layout);
        middleContentCircle.setLayoutData((Object)new GridData(4, 4, true, true));
        middleContentCircle.setBackground(this.getBorderColor());
        this.innerContent = new Composite(middleContentCircle, 524288);
        this.innerContent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.innerContent.setBackgroundMode(2);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        this.innerContent.setLayout((Layout)layout);
        this.innerContent.setBackground(DEFAULT_GRADIENT_END_COLOR);
        this.setNullBackground(this.outerCircle);
    }

    public Composite getContentComposite() {
        return this.innerContent;
    }

    public Color getGradientBeginColor() {
        return this.gradientBeginColor;
    }

    public void setGradientBeginColor(Color color) {
        this.gradientBeginColor = color;
    }

    public Color getGradientEndColor() {
        return this.gradientEndColor;
    }

    public void setGradientEndColor(Color color) {
        this.gradientEndColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        Color color2 = this.borderColor = color != null ? color : DEFAULT_BORDER_COLOR;
        if (!this.isDisposed()) {
            this.drawWidget();
        }
    }

    private void setNullBackground(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setBackground(null);
            if (c instanceof Composite) {
                this.setNullBackground((Composite)c);
            }
            ++n2;
        }
    }

    protected void drawWidget() {
        Rectangle clArea = this.outerCircle.getClientArea();
        this.lastUsedBgImage = new Image((Device)this.outerCircle.getDisplay(), clArea.width, clArea.height);
        GC gc = new GC((Drawable)this.lastUsedBgImage);
        this.drawGradient(gc, clArea);
        this.fixRegion(gc, clArea);
        gc.dispose();
        Image oldBGImage = this.outerCircle.getBackgroundImage();
        this.outerCircle.setBackgroundImage(this.lastUsedBgImage);
        if (oldBGImage != null) {
            oldBGImage.dispose();
        }
    }

    private void drawGradient(GC gc, Rectangle clArea) {
        gc.setForeground(this.getGradientBeginColor());
        gc.setBackground(this.getGradientEndColor());
        gc.fillGradientRectangle(clArea.x, clArea.y, clArea.width, clArea.height, true);
    }

    private void fixRegion(GC gc, Rectangle clArea) {
        gc.setForeground(this.getBorderColor());
        gc.drawPoint(2, 0);
        gc.drawPoint(3, 0);
        gc.drawPoint(1, 1);
        gc.drawPoint(0, 2);
        gc.drawPoint(0, 3);
        gc.drawPoint(clArea.width - 4, 0);
        gc.drawPoint(clArea.width - 3, 0);
        gc.drawPoint(clArea.width - 2, 1);
        gc.drawPoint(clArea.width - 1, 2);
        gc.drawPoint(clArea.width - 1, 3);
        gc.drawLine(3, 0, clArea.width - 4, 0);
        gc.drawPoint(2, clArea.height - 0);
        gc.drawPoint(3, clArea.height - 0);
        gc.drawPoint(1, clArea.height - 1);
        gc.drawPoint(0, clArea.height - 2);
        gc.drawPoint(0, clArea.height - 3);
        gc.drawLine(0, 3, 0, clArea.height - 4);
        gc.drawPoint(clArea.width - 4, clArea.height - 0);
        gc.drawPoint(clArea.width - 3, clArea.height - 0);
        gc.drawPoint(clArea.width - 2, clArea.height - 1);
        gc.drawPoint(clArea.width - 1, clArea.height - 2);
        gc.drawPoint(clArea.width - 1, clArea.height - 3);
        gc.drawLine(clArea.width - 1, 3, clArea.width - 1, clArea.height - 4);
        gc.drawLine(2, clArea.height - 1, clArea.width - 3, clArea.height - 1);
    }
}

