/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.commons.ui.dialogs;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ShellMover {
    private Control handle;
    private boolean headerIsClicked;
    private int startX;
    private int startY;
    private Shell toMove;
    private MouseAdapter mouseAdapter;
    private MouseMoveListener mouseMoveListener;

    public ShellMover(Shell toMove, Control shellHandle) {
        this.toMove = toMove;
        this.handle = shellHandle;
        this.hookListeners();
    }

    private void hookListeners() {
        this.mouseAdapter = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ShellMover.this.headerIsClicked = true;
                ShellMover.this.startX = e.x;
                ShellMover.this.startY = e.y;
            }

            public void mouseUp(MouseEvent e) {
                ShellMover.this.headerIsClicked = false;
            }
        };
        this.handle.addMouseListener((MouseListener)this.mouseAdapter);
        this.mouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (ShellMover.this.headerIsClicked) {
                    Point location = ShellMover.this.getShell().getLocation();
                    int difX = e.x - ShellMover.this.startX;
                    int difY = e.y - ShellMover.this.startY;
                    int newX = location.x + difX;
                    int newY = location.y + difY;
                    ShellMover.this.getShell().setLocation(newX, newY);
                }
            }
        };
        this.handle.addMouseMoveListener(this.mouseMoveListener);
    }

    protected Shell getShell() {
        return this.toMove;
    }

    public void dispose() {
        this.handle.removeMouseListener((MouseListener)this.mouseAdapter);
        this.handle.removeMouseMoveListener(this.mouseMoveListener);
    }
}

