/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.tema.core.extensions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.koneki.tema.core.extensions.ExtendedTemplateSite;
import org.eclipse.koneki.tema.core.internal.model.TemplateSite;
import org.eclipse.koneki.tema.core.model.ITemplateSite;

public final class ExtensionsManager {
    private static Map<String, ITemplateSite> SITES;
    private static boolean HAS_READ_EXTENSIONS;

    static {
        HAS_READ_EXTENSIONS = false;
    }

    private ExtensionsManager() {
    }

    public static void initialize() {
        if (SITES == null) {
            SITES = new HashMap<String, ITemplateSite>();
        }
        if (!SITES.isEmpty()) {
            SITES.clear();
        }
        IExtensionPoint ePoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.koneki.tema.core", "templateSites");
        IExtension[] extensions = ePoint.getExtensions();
        ExtensionsManager._retrieveExtendedSites(extensions);
        HAS_READ_EXTENSIONS = true;
    }

    public static Collection<ITemplateSite> getSites() {
        if (!HAS_READ_EXTENSIONS || SITES == null || SITES.isEmpty()) {
            ExtensionsManager.initialize();
        }
        return SITES.values();
    }

    public static void addRemoteTemplateSite(String name, String url) {
        if ("".equals(name) || "".equals(url) || SITES.containsKey(name)) {
            return;
        }
        try {
            URL siteURL = new URL(url);
            ExtendedTemplateSite site = new ExtendedTemplateSite(siteURL, name);
            ExtensionsManager.addTemplateSite(site);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
    }

    public static void addLocalTemplateSite(String name, String location, String pluginId) {
        if ("".equals(name) || "".equals(location) || SITES.containsKey(name)) {
            return;
        }
        URL siteURL = Platform.getBundle((String)pluginId).getEntry(location);
        if (siteURL == null) {
            return;
        }
        TemplateSite site = new TemplateSite(siteURL, name);
        ExtensionsManager.addTemplateSite(site);
    }

    public static void addTemplateSite(ITemplateSite site) {
        if (SITES == null) {
            ExtensionsManager.initialize();
        }
        SITES.put(site.getName(), site);
    }

    private static void _retrieveExtendedSites(IExtension[] extensions) {
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] config = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < config.length) {
                String name;
                IConfigurationElement ce = config[j];
                if ("remoteTemplateSite".equals(ce.getName())) {
                    name = ce.getAttribute("name");
                    String url = ce.getAttribute("url");
                    ExtensionsManager.addRemoteTemplateSite(name, url);
                } else if ("localTemplateSite".equals(ce.getName())) {
                    name = ce.getAttribute("name");
                    String location = ce.getAttribute("location");
                    String pluginId = ce.getDeclaringExtension().getNamespaceIdentifier();
                    ExtensionsManager.addLocalTemplateSite(name, location, pluginId);
                }
                ++j;
            }
            ++i;
        }
    }
}

