/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.tema.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class FileUtils {
    private FileUtils() {
    }

    public static void copyStream(InputStream from, File to) throws IOException {
        FileUtils.copyStream(from, to, true);
    }

    public static void copyStream(InputStream from, File to, boolean override) throws IOException {
        FileOutputStream fos = null;
        if (!to.exists() || override) {
            try {
                byte[] buf = new byte[8192];
                fos = new FileOutputStream(to);
                int i = 0;
                do {
                    if ((i = from.read(buf)) == -1) continue;
                    fos.write(buf, 0, i);
                } while (i != -1);
            }
            finally {
                if (from != null) {
                    from.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
        }
    }

    public static void copyFolder(File source, File target) throws IOException {
        FileUtils.copyFolder(source, target, true);
    }

    public static void copyFolder(File source, File target, boolean override) throws IOException {
        File[] roots = source.listFiles();
        target.mkdirs();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].isDirectory()) {
                FileUtils.copyFolder(roots[i], new File(String.valueOf(target.getAbsolutePath()) + File.separator + roots[i].getName()), override);
            } else {
                FileUtils.copyStream(new FileInputStream(roots[i]), new File(String.valueOf(target.getAbsolutePath()) + File.separator + roots[i].getName()), override);
            }
            ++i;
        }
    }

    public static void copyFile(File sourcePath, File fileDest) throws IOException {
        if (sourcePath.getAbsolutePath().equals(fileDest.getAbsolutePath())) {
            return;
        }
        FileInputStream source = new FileInputStream(sourcePath);
        new File(fileDest.getParent()).mkdirs();
        if (!fileDest.exists()) {
            fileDest.createNewFile();
        }
        FileOutputStream destination = new FileOutputStream(fileDest);
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = source.read(buf)) > 0) {
                destination.write(buf, 0, len);
            }
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void deleteDirectory(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                FileUtils.deleteDirectory(file);
            } else {
                file.delete();
            }
            ++i;
        }
        dir.delete();
    }

    public static void copyDirectoryContent(File srcFolder, File destFolder) throws IOException {
        File[] files = srcFolder.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                FileUtils.copyDirectory(file, destFolder);
            } else {
                FileUtils.copyFile(file, new File(String.valueOf(destFolder.getPath()) + File.separator + file.getName()));
            }
            ++i;
        }
    }

    public static void copyDirectory(File srcFolder, File destFolder) throws IOException {
        String destFolderPath = destFolder.getPath();
        File copiedSrcFolder = new File(String.valueOf(destFolderPath) + File.separator + srcFolder.getName());
        copiedSrcFolder.mkdirs();
        File[] files = srcFolder.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isDirectory()) {
                    FileUtils.copyDirectory(file, copiedSrcFolder);
                } else {
                    FileUtils.copyFile(file, new File(String.valueOf(copiedSrcFolder.getPath()) + File.separator + file.getName()));
                }
                ++i;
            }
        }
    }

    public static long getDirectorySize(File dir) {
        long result = 0L;
        if (dir == null || !dir.isDirectory()) {
            return 0L;
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            result = file.isDirectory() ? (result += FileUtils.getDirectorySize(file)) : (result += file.length());
            ++i;
        }
        return result;
    }
}

