/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildCommand;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildProcessManager;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DbgUtil;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.GenDirInfo;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.ProcessLauncher;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ParallelBuilder {
    public static final int STATUS_OK = 0;
    public static final int STATUS_ERROR = 1;
    public static final int STATUS_CANCELED = 2;
    public static final int STATUS_INVALID = -1;
    public static final long MAIN_LOOP_DELAY = 50L;
    private static final String BUILDER_MSG_HEADER = "InternalBuilder.msg.header";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    public static int lastThreadsUsed = 0;
    protected IPath cwd;
    protected GenDirInfo dirs;
    protected IProgressMonitor monitor;
    protected OutputStream out;
    protected OutputStream err;
    protected boolean resumeOnErrors;
    protected boolean buildIncrementally;
    protected HashSet<BuildQueueElement> unsorted = new HashSet();
    protected HashMap<IBuildStep, BuildQueueElement> queueHash = new HashMap();
    protected LinkedList<BuildQueueElement> queue = new LinkedList();

    public static int build(IBuildDescription des, IPath cwd, GenDirInfo dirs, OutputStream out, OutputStream err, IProgressMonitor monitor, boolean resumeOnErrors, boolean buildIncrementally) {
        IConfiguration cfg = des.getConfiguration();
        if (dirs == null) {
            dirs = new GenDirInfo(cfg);
        }
        if (cwd == null) {
            cwd = des.getDefaultBuildDirLocation();
        }
        int threads = 1;
        if (cfg instanceof Configuration) {
            threads = ((Configuration)cfg).getParallelNumber();
        }
        ParallelBuilder builder = new ParallelBuilder(cwd, dirs, out, err, monitor, resumeOnErrors, buildIncrementally);
        builder.enqueueAll(des);
        builder.sortQueue();
        monitor.beginTask("", builder.queue.size());
        BuildProcessManager buildProcessManager = new BuildProcessManager(out, err, true, threads);
        int status = builder.dispatch(buildProcessManager);
        lastThreadsUsed = buildProcessManager.getThreadsUsed();
        monitor.done();
        return status;
    }

    protected ParallelBuilder(IPath _cwd, GenDirInfo _dirs, OutputStream _out, OutputStream _err, IProgressMonitor _monitor, boolean _resumeOnErrors, boolean _buildIncrementally) {
        this.cwd = _cwd;
        this.dirs = _dirs;
        this.out = _out;
        this.err = _err;
        this.monitor = _monitor;
        this.resumeOnErrors = _resumeOnErrors;
        this.buildIncrementally = _buildIncrementally;
    }

    protected void enqueueAll(IBuildDescription des) {
        this.enqueueSteps(des.getInputStep(), 0);
    }

    protected void sortQueue() {
        for (BuildQueueElement elem : this.unsorted) {
            this.queue.add(elem);
        }
        this.unsorted.clear();
        this.unsorted = null;
        this.queueHash.clear();
        this.queueHash = null;
        Collections.sort(this.queue);
    }

    protected void enqueueSteps(IBuildStep step, int level) {
        IBuildResource[] resources = step.getOutputResources();
        int i = 0;
        while (i < resources.length) {
            IBuildStep[] steps = resources[i].getDependentSteps();
            int j = 0;
            while (j < steps.length) {
                IBuildStep st = steps[j];
                if (st != null && st.getBuildDescription().getOutputStep() != st) {
                    BuildQueueElement b = this.queueHash.get(st);
                    if (b != null) {
                        if (b.level < level) {
                            b.setLevel(level);
                        }
                    } else {
                        if (!(steps[j].isRemoved() || this.buildIncrementally && !steps[j].needsRebuild())) {
                            this.addElement(steps[j], level);
                        }
                        this.enqueueSteps(steps[j], level + 1);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected void addElement(IBuildStep step, int level) {
        BuildQueueElement elem = new BuildQueueElement(step, level);
        this.unsorted.add(elem);
        this.queueHash.put(step, elem);
    }

    protected int dispatch(BuildProcessManager mgr) {
        int maxProcesses = mgr.getMaxProcesses();
        Vector<ActiveBuildStep> active = new Vector<ActiveBuildStep>(Math.min(maxProcesses, 10), 10);
        int activeCount = 0;
        int maxLevel = 0;
        int status = 0;
        String errorMsg = null;
        block2: while (true) {
            if (this.monitor.isCanceled()) {
                status = 2;
                errorMsg = CCorePlugin.getResourceString((String)"CommandLauncher.error.commandCanceled");
                break;
            }
            ProcessLauncher launcher = mgr.queryStates();
            if (launcher != null) {
                status = launcher.queryState() == 2 ? 2 : -1;
                errorMsg = launcher.getErrorMessage();
                break;
            }
            boolean proceed = true;
            if (!mgr.hasEmpty()) {
                proceed = false;
            } else {
                for (ActiveBuildStep buildStep : active) {
                    ProcessLauncher pl = buildStep.getLauncher();
                    if (pl == null || pl.queryState() != 0) continue;
                    if (!this.resumeOnErrors && pl.getExitCode() != 0) {
                        status = 1;
                        break block2;
                    }
                    if (buildStep.isDone()) continue;
                    if (buildStep.launchNextCmd(mgr)) {
                        if (mgr.hasEmpty()) continue;
                        proceed = false;
                        break;
                    }
                    this.refreshOutputs(buildStep.getStep());
                    --activeCount;
                    this.monitor.worked(1);
                }
            }
            if (!proceed) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (this.queue.size() != 0 && activeCount < maxProcesses) {
                Iterator iter = this.queue.iterator();
                while (iter.hasNext()) {
                    BuildQueueElement elem = (BuildQueueElement)iter.next();
                    if (activeCount == maxProcesses || elem.getLevel() > maxLevel + 1) break;
                    boolean prereqBuilt = true;
                    IBuildResource[] iBuildResourceArray = elem.getStep().getInputResources();
                    int n = iBuildResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBuildResource bldRes = iBuildResourceArray[n2];
                        IBuildStep step = bldRes.getProducerStep();
                        boolean built = true;
                        if (step != step.getBuildDescription().getInputStep()) {
                            for (ActiveBuildStep buildStep : active) {
                                if (buildStep == null || !buildStep.getStep().equals(step) || buildStep.isDone()) continue;
                                built = false;
                                break;
                            }
                        }
                        if (!built) {
                            prereqBuilt = false;
                            break;
                        }
                        ++n2;
                    }
                    if (!prereqBuilt) continue;
                    IBuildStep step = elem.getStep();
                    iter.remove();
                    int i = 0;
                    while (i < maxProcesses) {
                        if (i >= active.size()) {
                            ActiveBuildStep buildStep = new ActiveBuildStep(step);
                            active.add(buildStep);
                            if (!buildStep.launchNextCmd(mgr)) break;
                            ++activeCount;
                            break;
                        }
                        if (((ActiveBuildStep)active.get(i)).isDone()) {
                            ActiveBuildStep buildStep = new ActiveBuildStep(step);
                            active.set(i, buildStep);
                            if (!buildStep.launchNextCmd(mgr)) break;
                            ++activeCount;
                            break;
                        }
                        ++i;
                    }
                    if (elem.getLevel() <= maxLevel) continue;
                    maxLevel = elem.getLevel();
                }
            }
            if (activeCount <= 0 && this.queue.size() == 0) break;
        }
        if (status != 0 && errorMsg != null) {
            this.printMessage(errorMsg, this.out);
        }
        return status;
    }

    protected void printMessage(String msg, OutputStream out) {
        if (out != null) {
            msg = String.valueOf(ManagedMakeMessages.getFormattedString(BUILDER_MSG_HEADER, msg)) + LINE_SEPARATOR;
            try {
                out.write(msg.getBytes());
                out.flush();
            }
            catch (IOException iOException) {}
        }
    }

    protected void refreshOutputs(IBuildStep step) {
        NullProgressMonitor mon = new NullProgressMonitor();
        IBuildResource[] outres = step.getOutputResources();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < outres.length) {
            IPath path = outres[i].getFullPath();
            if (path != null) {
                try {
                    root.getFile(path).refreshLocal(0, (IProgressMonitor)mon);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
    }

    protected class ActiveBuildStep {
        protected IPath stepCwd;
        protected GenDirInfo stepDirs;
        protected IBuildStep step;
        protected IBuildCommand[] cmds;
        protected int activeCmd;
        protected boolean done;
        protected ProcessLauncher launcher;

        public ActiveBuildStep(IBuildStep _step) {
            this.step = _step;
            this.stepDirs = ParallelBuilder.this.dirs == null ? new GenDirInfo(this.step.getBuildDescription().getConfiguration()) : ParallelBuilder.this.dirs;
            this.stepCwd = ParallelBuilder.this.cwd == null ? this.step.getBuildDescription().getDefaultBuildDirLocation() : ParallelBuilder.this.cwd;
            this.cmds = this.step.getCommands(this.stepCwd, null, null, true);
            this.activeCmd = -1;
            this.done = false;
            this.createOutDirs();
        }

        public boolean launchNextCmd(BuildProcessManager mgr) {
            if (ParallelBuilder.this.monitor.isCanceled()) {
                this.done = true;
                return false;
            }
            if (this.activeCmd + 1 >= this.cmds.length) {
                this.done = true;
            } else {
                IBuildCommand cmd = this.cmds[++this.activeCmd];
                this.launcher = mgr.launchProcess(cmd, this.stepCwd, ParallelBuilder.this.monitor);
                if (this.launcher != null) {
                    return true;
                }
                --this.activeCmd;
                this.done = true;
            }
            return false;
        }

        public boolean isDone() {
            return this.done;
        }

        public IBuildStep getStep() {
            return this.step;
        }

        public ProcessLauncher getLauncher() {
            return this.launcher;
        }

        protected void createOutDirs() {
            IBuildResource[] rcs = this.step.getOutputResources();
            int i = 0;
            while (i < rcs.length) {
                ParallelBuilder.this.dirs.createDir(rcs[i], (IProgressMonitor)new NullProgressMonitor());
                ++i;
            }
        }
    }

    protected class BuildQueueElement
    implements Comparable<BuildQueueElement> {
        protected IBuildStep step;
        protected int level;

        public BuildQueueElement(IBuildStep _step, int _level) {
            this.step = _step;
            this.level = _level;
        }

        public IBuildStep getStep() {
            return this.step;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int _level) {
            this.level = _level;
        }

        public int hashCode() {
            return this.step.hashCode();
        }

        @Override
        public int compareTo(BuildQueueElement elem) {
            if (elem == null) {
                throw new NullPointerException();
            }
            if (elem.getLevel() > this.level) {
                return -1;
            }
            if (elem.getLevel() < this.level) {
                return 1;
            }
            return 0;
        }

        public boolean check(IBuildStep _step, int _level) {
            if (this.level < _level && this.step.equals(_step)) {
                this.level = _level;
                return true;
            }
            return false;
        }

        public String toString() {
            return "[BuildQueueElement] " + DbgUtil.stepName(this.step) + " @ " + this.level;
        }
    }
}

