/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.ProcessClosure;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProcessLauncher {
    public static final int STATE_DONE = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_CANCELED = 2;
    public static final int STATE_ILLEGAL = -1;
    protected String[] cmd;
    protected String[] env;
    protected File cwd;
    protected OutputStream out;
    protected OutputStream err;
    protected IProgressMonitor monitor;
    protected boolean show;
    protected String error;
    protected String lineSeparator;
    protected Process process;
    protected ProcessClosure closure = null;
    protected int state;

    public String[] getCommandArray() {
        return this.cmd;
    }

    public String getCommandLine() {
        StringBuffer buf = new StringBuffer();
        if (this.cmd != null) {
            int i = 0;
            while (i < this.cmd.length) {
                buf.append(this.cmd[i]);
                buf.append(' ');
                ++i;
            }
            buf.append(this.lineSeparator);
        }
        return buf.toString();
    }

    public String[] getEnvironment() {
        return this.env;
    }

    public File getWorkingDir() {
        return this.cwd;
    }

    public String getErrorMessage() {
        return this.error;
    }

    public int getExitCode() {
        if (this.process == null || this.closure.isAlive()) {
            return 0;
        }
        try {
            return this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            return 0;
        }
    }

    public ProcessLauncher(IPath _cmd, String[] args, String[] _env, IPath _cwd, OutputStream _out, OutputStream _err, IProgressMonitor _monitor, boolean _show) {
        this.cmd = this.createCmdArray(_cmd.toOSString(), args);
        this.env = _env;
        this.cwd = _cwd.toFile();
        this.out = _out;
        this.err = _err;
        this.monitor = _monitor;
        this.show = _show;
        this.error = "";
        this.lineSeparator = System.getProperty("line.separator", "\n");
    }

    public void launch() {
        try {
            if (this.show) {
                this.printCommandLine();
            }
            this.state = 1;
            this.process = ProcessFactory.getFactory().exec(this.cmd, this.env, this.cwd);
            this.closure = new ProcessClosure(this.process, this.out, this.err);
            try {
                this.process.getOutputStream().close();
            }
            catch (IOException iOException) {}
            this.closure.runNonBlocking();
        }
        catch (IOException e) {
            this.error = e.getMessage();
            this.closure = null;
        }
    }

    public int queryState() {
        if (this.state == 1) {
            if (this.closure == null) {
                this.state = -1;
            } else if (this.monitor.isCanceled()) {
                this.closure.terminate();
                this.error = CCorePlugin.getResourceString((String)"CommandLauncher.error.commandCanceled");
                this.state = 2;
            } else if (!this.closure.isRunning()) {
                this.state = 0;
            }
        }
        return this.state;
    }

    protected String[] createCmdArray(String cmdPath, String[] cmdArgs) {
        String[] args = new String[1 + cmdArgs.length];
        args[0] = cmdPath;
        System.arraycopy(cmdArgs, 0, args, 1, cmdArgs.length);
        return args;
    }

    protected void printCommandLine() {
        if (this.out != null) {
            try {
                this.out.write(this.getCommandLine().getBytes());
                this.out.flush();
            }
            catch (IOException iOException) {}
        }
    }
}

