/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.dialogs;

import org.eclipse.cdt.internal.ui.refactoring.dialogs.LabeledTextField;
import org.eclipse.cdt.internal.ui.refactoring.dialogs.VisibilitySelectionPanel;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NameAndVisibilityComposite
extends Composite {
    private LabeledTextField constantName;
    private final String labelName;
    private final VisibilitySelectionPanel visibilityPanel;

    public NameAndVisibilityComposite(Composite parent, String labelName, String defaultName) {
        this(parent, labelName, VisibilityEnum.v_public, defaultName);
    }

    public NameAndVisibilityComposite(Composite parent, String labelName, VisibilityEnum defaultVisibility, String defaultName) {
        super(parent, 0);
        this.labelName = labelName;
        this.setLayout((Layout)new GridLayout());
        this.createNewMethodNameComposite(this, defaultName);
        this.visibilityPanel = new VisibilitySelectionPanel(this, defaultVisibility, 0);
    }

    public Text getConstantNameText() {
        return this.constantName.getText();
    }

    public Group getVisibiltyGroup() {
        return this.visibilityPanel.getGroup();
    }

    public void visibilityPanelsetVisible(boolean visible) {
        this.visibilityPanel.setVisible(visible);
    }

    private void createNewMethodNameComposite(Composite control, String defaultName) {
        Composite methodNameComposite = new Composite(control, 0);
        FillLayout compositeLayout = new FillLayout(256);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.horizontalAlignment = 4;
        methodNameComposite.setLayoutData((Object)gridData);
        methodNameComposite.setLayout((Layout)compositeLayout);
        this.constantName = new LabeledTextField(methodNameComposite, this.labelName, defaultName);
    }
}

