/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.remote.core.internal;

import com.jcraft.jsch.Session;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.connectorservice.ssh.SshConnectorService;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public final class RSEUtil {
    private RSEUtil() {
    }

    public static Session getCurrentSshSession(IConnectorService[] connectors) {
        IConnectorService[] iConnectorServiceArray = connectors;
        int n = connectors.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectorService connectorService = iConnectorServiceArray[n2];
            if (connectorService instanceof SshConnectorService) {
                SshConnectorService iConnectorService = (SshConnectorService)connectorService;
                return iConnectorService.getSession();
            }
            ++n2;
        }
        return null;
    }

    public static void waitForRSEInitialization() {
        try {
            RSECorePlugin.waitForInitCompletion();
        }
        catch (InterruptedException interruptedException) {}
    }

    public static IRemoteFileSubSystem getRemoteFileSubsystem(IHost host) {
        ISubSystem[] subSystems;
        if (host == null) {
            return null;
        }
        ISubSystem[] iSubSystemArray = subSystems = host.getSubSystems();
        int n = subSystems.length;
        int n2 = 0;
        while (n2 < n) {
            ISubSystem subsystem = iSubSystemArray[n2];
            if (subsystem instanceof IRemoteFileSubSystem) {
                return (IRemoteFileSubSystem)subsystem;
            }
            ++n2;
        }
        return null;
    }

    @Deprecated
    public static boolean fileExist(IRemoteFileSubSystem subsystem, IRemoteFile file) {
        try {
            IRemoteFile[] list = subsystem.list(file.getParentRemoteFile(), file.getName(), 0, (IProgressMonitor)new NullProgressMonitor());
            return list.length == 1;
        }
        catch (SystemMessageException systemMessageException) {
            return false;
        }
    }

    public static void uploadFiles(IRemoteFileSubSystem subsystem, IFolder sourceFolder, String destinationFolderPath, IProgressMonitor monitor) throws CoreException {
        IResource[] members = sourceFolder.members();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)members.length);
        if (members.length > 0) {
            int i = 0;
            while (i < members.length && !subMonitor.isCanceled()) {
                try {
                    IResource sourceMember = members[i];
                    if (sourceMember instanceof IFile) {
                        IFile sourceFile = (IFile)sourceMember;
                        String sourcePath = sourceFile.getLocation().toOSString();
                        String sourceEncoding = sourceFile.getCharset();
                        String destinationPath = String.valueOf(destinationFolderPath) + subsystem.getSeparator() + sourceFile.getName();
                        String destinationEncoding = subsystem.getRemoteEncoding();
                        subsystem.upload(sourcePath, sourceEncoding, destinationPath, destinationEncoding, (IProgressMonitor)subMonitor.newChild(3));
                    } else if (sourceMember instanceof IFolder) {
                        IFolder innerSourceFolder = (IFolder)sourceMember;
                        String innerDestinationFolderPath = String.valueOf(destinationFolderPath) + subsystem.getSeparator() + innerSourceFolder.getName();
                        IRemoteFile remoteFolder = subsystem.getRemoteFileObject(innerDestinationFolderPath, (IProgressMonitor)subMonitor.newChild(1));
                        subsystem.createFolder(remoteFolder, (IProgressMonitor)subMonitor.newChild(1));
                        RSEUtil.uploadFiles(subsystem, innerSourceFolder, innerDestinationFolderPath, (IProgressMonitor)subMonitor.newChild(1));
                    }
                }
                catch (SystemMessageException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.ldt.remote.core", "Unable to upload files", (Throwable)e));
                }
                ++i;
            }
        }
    }
}

