/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.ast.models;

import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;

public final class LuaDLTKModelUtils {
    private LuaDLTKModelUtils() {
    }

    public static boolean isAncestor(IModelElement element, IModelElement ancestor) {
        return ancestor != null && element != null && (ancestor.equals(element.getParent()) || LuaDLTKModelUtils.isAncestor(element.getParent(), ancestor));
    }

    private static boolean isModule(int flags) {
        return (flags & 0x400) != 0;
    }

    public static boolean isModule(IMember member) throws ModelException {
        return member instanceof IType && LuaDLTKModelUtils.isModule(member.getFlags());
    }

    public static boolean isModuleFunction(IMember member) throws ModelException {
        return member instanceof IMethod && LuaDLTKModelUtils.isModule(member.getFlags());
    }

    public static boolean isGlobalTable(IMember member) throws ModelException {
        return member instanceof IType && Flags.isPublic((int)member.getFlags());
    }

    public static boolean isLocalTable(IMember member) throws ModelException {
        return member instanceof IType && Flags.isPrivate((int)member.getFlags());
    }
}

