/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.mihini.tm.c.ui.generator;

import java.io.File;
import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.koneki.mihini.tm.c.ui.generator.BootstrapGenerator;
import org.eclipse.koneki.mihini.tm.c.ui.generator.Messages;
import org.eclipse.koneki.mihini.tm.core.softwarepackage.AbstractSoftwarePackageGenerator;

public class CSoftwarePackageGenerator
extends AbstractSoftwarePackageGenerator {
    public CSoftwarePackageGenerator(String applicationName, IProject project) {
        super(applicationName, project);
    }

    protected byte[] generateBootstrapFile(IProject project) throws CoreException {
        this.checkProject(project);
        String executableName = this.getFirstExecutablePath(project).getName();
        if (executableName == null || executableName.isEmpty()) {
            this.noExecutableFound(project);
        }
        byte[] bootstrapContent = new BootstrapGenerator().bootstrapToByteArray(executableName);
        return bootstrapContent;
    }

    protected HashMap<String, File> collectFiles(SubMonitor progressMonitor, IProject project) throws CoreException {
        this.checkProject(project);
        HashMap<String, File> fileList = new HashMap<String, File>();
        File executable = this.getFirstExecutablePath(project);
        if (executable == null) {
            this.noExecutableFound(project);
        }
        IPath executablePath = new Path("bin").append(executable.getName());
        fileList.put(executablePath.toPortableString(), executable);
        return fileList;
    }

    private void noExecutableFound(IProject project) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.mihini.tm.lua.ui", String.valueOf(Messages.CSoftwarePackageGenerator_error_no_executable) + project.getName()));
    }

    private void checkProject(IProject project) throws CoreException {
        if (!project.hasNature("org.eclipse.cdt.core.cnature")) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.mihini.tm.lua.ui", String.valueOf(Messages.CSoftwarePackageGenerator_error_not_cdt_project) + project.getName()));
        }
    }

    private File getFirstExecutablePath(IProject project) {
        ICOutputEntry[] outputDir;
        ICProjectDescription cprojectDesc = CCorePlugin.getDefault().getProjectDescription(project, false);
        ICConfigurationDescription config = cprojectDesc.getActiveConfiguration();
        ICOutputEntry[] iCOutputEntryArray = outputDir = config.getBuildSetting().getResolvedOutputDirectories();
        int n = outputDir.length;
        int n2 = 0;
        while (n2 < n) {
            File folder;
            ICOutputEntry dir = iCOutputEntryArray[n2];
            IPath dirPath = dir.getLocation();
            if (dirPath != null && (folder = dirPath.toFile()).isDirectory()) {
                File[] fileArray = folder.listFiles();
                int n3 = fileArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray[n4];
                    if (file.canExecute() && !file.isDirectory()) {
                        return file;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }
}

