/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.mihini.tm.core;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public abstract class AbstractRESTService {
    private static final int DEFAULT_TIMEOUT = 2000;
    private String host;
    private int port;
    private HttpClient httpClient;

    public AbstractRESTService(String host, int port) {
        this.setHost(host);
        this.setPort(port);
        this.setHttpClient((HttpClient)new DefaultHttpClient());
        HttpParams params = this.httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)2000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)2000);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected URI getURI(String path) throws URISyntaxException {
        return new URI("http", null, this.host, this.port, path, null, null);
    }

    protected URI getURI(String path, String query) throws URISyntaxException {
        return new URI("http", null, this.host, this.port, path, query, null);
    }

    protected String getErrorMessage(HttpResponse response) {
        return response.getStatusLine().toString();
    }
}

