/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.mihini.tm.core.softwarepackage;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.koneki.mihini.tm.core.Activator;
import org.eclipse.koneki.mihini.tm.core.softwarepackage.ManifestGenerator;
import org.eclipse.koneki.mihini.tm.core.softwarepackage.ManifestMode;
import org.eclipse.koneki.mihini.tm.core.softwarepackage.Messages;

public abstract class AbstractSoftwarePackageGenerator {
    protected static final String BINARIES_DIRECTORY = "bin";
    protected static final String MANIFEST_FILENAME = "Manifest";
    private static final String PACKAGE_EXT = ".tar";
    private IProject project;
    private String applicationName;

    public AbstractSoftwarePackageGenerator(String applicationName, IProject project) {
        this.applicationName = applicationName;
        this.project = project;
    }

    public void startGenerationInStream(final OutputStream ouputStream, final String version, final ManifestMode mode, IProgressMonitor monitor) throws CoreException {
        String error = null;
        switch (mode) {
            case INSTALL: {
                error = AbstractSoftwarePackageGenerator.validateInstallPackageGeneration(this.project, this.applicationName, version);
                break;
            }
            case UNINSTALL: {
                error = AbstractSoftwarePackageGenerator.validateUninstallPackageGeneration(this.applicationName);
                break;
            }
        }
        if (error != null) {
            this.throwException(error, null, 4);
        }
        Job writterJob = new Job("Software Package Generation"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        AbstractSoftwarePackageGenerator.this.writeProjectSourceTar(ouputStream, true, version, mode, monitor);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, "org.eclipse.koneki.mihini.tm.core", "Unable to generate Software Package.", (Throwable)e);
                        try {
                            ouputStream.close();
                        }
                        catch (IOException e2) {
                            Activator.logWarning("Unable to close Software Package archive.", e2);
                        }
                        return status;
                    }
                    catch (IOException e) {
                        Status status = new Status(4, "org.eclipse.koneki.mihini.tm.core", "Unable to generate Software Package.", (Throwable)e);
                        try {
                            ouputStream.close();
                        }
                        catch (IOException e3) {
                            Activator.logWarning("Unable to close Software Package archive.", e3);
                        }
                        return status;
                    }
                }
                finally {
                    try {
                        ouputStream.close();
                    }
                    catch (IOException e) {
                        Activator.logWarning("Unable to close Software Package archive.", e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        writterJob.schedule();
    }

    public IPath generateInTmp(String version, ManifestMode mode, IProgressMonitor monitor) throws CoreException {
        try {
            File tempFile = File.createTempFile(Long.toString(System.nanoTime()), PACKAGE_EXT);
            tempFile.deleteOnExit();
            return this.generate((IPath)new Path(tempFile.getPath()), version, mode, monitor);
        }
        catch (IOException e) {
            this.throwException("Unable to generate Software Package.", e, 4);
            return null;
        }
    }

    public IPath generateInOutputDir(IPath outputDirectory, String version, ManifestMode mode, IProgressMonitor monitor) throws CoreException {
        String error = AbstractSoftwarePackageGenerator.validateOutputPath(outputDirectory);
        if (error != null) {
            this.throwException(error, null, 4);
        }
        IPath filePath = outputDirectory.append(String.valueOf(this.applicationName) + PACKAGE_EXT);
        return this.generate(filePath, version, mode, monitor);
    }

    private IPath generate(IPath packagepath, String version, ManifestMode mode, IProgressMonitor monitor) throws CoreException {
        block17: {
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(packagepath.toFile());
                    String error = null;
                    switch (mode) {
                        case INSTALL: {
                            error = AbstractSoftwarePackageGenerator.validateInstallPackageGeneration(this.project, this.applicationName, version);
                            break;
                        }
                        case UNINSTALL: {
                            error = AbstractSoftwarePackageGenerator.validateUninstallPackageGeneration(this.applicationName);
                            break;
                        }
                    }
                    if (error != null) {
                        this.throwException(error, null, 4);
                    }
                    this.writeProjectSourceTar(fileOutputStream, true, version, mode, monitor);
                }
                catch (IOException e) {
                    this.throwException("Unable to generate Software Package.", e, 4);
                    if (fileOutputStream == null) break block17;
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException e2) {
                        Activator.logWarning("Unable to close Software Package archive.", e2);
                    }
                }
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException e) {
                        Activator.logWarning("Unable to close Software Package archive.", e);
                    }
                }
            }
        }
        return packagepath;
    }

    private void throwException(String message, Throwable t, int severity) throws CoreException {
        throw new CoreException((IStatus)new Status(severity, "org.eclipse.koneki.mihini.tm.core", message, t));
    }

    public static String validateUninstallPackageGeneration(String name) {
        String error = AbstractSoftwarePackageGenerator.validateName(name);
        if (error != null) {
            return error;
        }
        return null;
    }

    public static String validateInstallPackageGeneration(IProject project, String name, String version, IPath outputPath) {
        String error = AbstractSoftwarePackageGenerator.validateInstallPackageGeneration(project, name, version);
        if (error != null) {
            return error;
        }
        return AbstractSoftwarePackageGenerator.validateOutputPath(outputPath);
    }

    public static String validateInstallPackageGeneration(IProject project, String name, String version) {
        String error = AbstractSoftwarePackageGenerator.validateProject(project);
        if (error != null) {
            return error;
        }
        error = AbstractSoftwarePackageGenerator.validateName(name);
        if (error != null) {
            return error;
        }
        error = AbstractSoftwarePackageGenerator.validateVersion(version);
        if (error != null) {
            return error;
        }
        return error;
    }

    private static String validateName(String name) {
        Pattern pattern = Pattern.compile("[\\w]*");
        Matcher matcher = pattern.matcher(name);
        if (!matcher.matches()) {
            return "Name can only be composed of ASCII letters, digits and \"_\".";
        }
        return null;
    }

    private static String validateProject(IProject project) {
        if (project == null) {
            return "No project provided.";
        }
        if (!project.exists()) {
            return "Project does not exist.";
        }
        return null;
    }

    private static String validateOutputPath(IPath outputPath) {
        if (outputPath == null) {
            return "No destination provided.";
        }
        if (outputPath.isEmpty()) {
            return "Output directory is empty.";
        }
        File folder = outputPath.toFile();
        if (!folder.exists()) {
            return "Given directory does not exist.";
        }
        if (!folder.isDirectory()) {
            return "File path given instead of directory path.";
        }
        return null;
    }

    private static String validateVersion(String version) {
        if (version == null || version.isEmpty()) {
            return "No version provided";
        }
        return null;
    }

    private void writeManifest(OutputStream outputStream, String manifestVersion, ManifestMode mode) throws IOException {
        String manifestfileName = new Path(MANIFEST_FILENAME).toPortableString();
        TarArchiveEntry manifestEntry = new TarArchiveEntry(manifestfileName);
        byte[] manifestContent = new ManifestGenerator().manifestToByteArray(this.getApplicationName(), manifestVersion, BINARIES_DIRECTORY, mode);
        manifestEntry.setSize((long)manifestContent.length);
        IOUtils.write((byte[])manifestContent, (OutputStream)outputStream);
    }

    public void writeProjectSourceTar(OutputStream outputStream, boolean generateManifest, String manifestVersion, ManifestMode mode, IProgressMonitor monitor) throws CoreException, IOException {
        TarArchiveOutputStream tarOutputStream = new TarArchiveOutputStream(outputStream);
        SubMonitor progressMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        if (generateManifest) {
            if (progressMonitor.isCanceled()) {
                tarOutputStream.close();
                return;
            }
            ByteArrayOutputStream buffer = null;
            try {
                progressMonitor.setTaskName(MessageFormat.format(Messages.SoftwarePackageGeneratorCompressing, new Path(MANIFEST_FILENAME).toPortableString()));
                buffer = new ByteArrayOutputStream();
                this.writeManifest(buffer, manifestVersion, mode);
                String manifestfileName = new Path(MANIFEST_FILENAME).toPortableString();
                TarArchiveEntry manifestEntry = new TarArchiveEntry(manifestfileName);
                manifestEntry.setSize((long)buffer.size());
                tarOutputStream.putArchiveEntry((ArchiveEntry)manifestEntry);
                buffer.writeTo((OutputStream)tarOutputStream);
                tarOutputStream.closeArchiveEntry();
                progressMonitor.setWorkRemaining(100).worked(1);
            }
            finally {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException e) {
                        Activator.logWarning("Unable to close software package manifest generation buffer.", e);
                    }
                }
            }
        }
        if (ManifestMode.UNINSTALL == mode) {
            tarOutputStream.finish();
            return;
        }
        if (progressMonitor.isCanceled()) {
            return;
        }
        Map<String, File> fileList = this.collectFiles(progressMonitor, this.project);
        SubMonitor loopProgressMonitor = progressMonitor.setWorkRemaining(fileList.size() + 1);
        TarArchiveEntry rootArchiveEntry = new TarArchiveEntry(BINARIES_DIRECTORY + File.separator);
        tarOutputStream.putArchiveEntry((ArchiveEntry)rootArchiveEntry);
        tarOutputStream.closeArchiveEntry();
        if (progressMonitor.isCanceled()) {
            return;
        }
        String bootstrapArchiveName = new Path(BINARIES_DIRECTORY).append("run").toPortableString();
        loopProgressMonitor.setTaskName(Messages.bind((String)Messages.SoftwarePackageGeneratorCompressing, (Object)bootstrapArchiveName));
        TarArchiveEntry bootstrapEntry = new TarArchiveEntry(bootstrapArchiveName);
        byte[] bootstrapContent = this.generateBootstrapFile(this.project);
        bootstrapEntry.setSize((long)bootstrapContent.length);
        tarOutputStream.putArchiveEntry((ArchiveEntry)bootstrapEntry);
        IOUtils.write((byte[])bootstrapContent, (OutputStream)tarOutputStream);
        tarOutputStream.closeArchiveEntry();
        progressMonitor.worked(1);
        String[] entryNames = fileList.keySet().toArray(new String[fileList.size()]);
        int i = 0;
        while (i < entryNames.length && !loopProgressMonitor.isCanceled()) {
            String fileName = entryNames[i];
            File projectFile = fileList.get(fileName);
            TarArchiveEntry archiveEntry = (TarArchiveEntry)tarOutputStream.createArchiveEntry(projectFile, fileName);
            String message = Messages.bind((String)Messages.SoftwarePackageGeneratorCompressing, (Object)fileName);
            loopProgressMonitor.setTaskName(message);
            tarOutputStream.putArchiveEntry((ArchiveEntry)archiveEntry);
            if (!archiveEntry.isDirectory()) {
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(projectFile);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)tarOutputStream);
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            Activator.logWarning(MessageFormat.format("Unable to close file {0}", projectFile), e);
                        }
                    }
                    throw throwable;
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        Activator.logWarning(MessageFormat.format("Unable to close file {0}", projectFile), e);
                    }
                }
            }
            tarOutputStream.closeArchiveEntry();
            loopProgressMonitor.worked(1);
            ++i;
        }
        tarOutputStream.finish();
    }

    protected abstract Map<String, File> collectFiles(SubMonitor var1, IProject var2) throws CoreException;

    protected abstract byte[] generateBootstrapFile(IProject var1) throws CoreException;

    public String getApplicationName() {
        return this.applicationName;
    }
}

