/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.mihini.tm.core.softwarepackage;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.koneki.mihini.tm.core.AbstractRESTService;

public final class ApplicationContainer
extends AbstractRESTService {
    private static final String PATH_LIST_APPLICATION = "/application";
    private static final String PATH_LIST_APPLICATION_STATUS = "/application/{0}";
    private static final String PATH_LIST_APPLICATION_START = "/application/{0}/start";
    private static final String PATH_LIST_APPLICATION_STOP = "/application/{0}/stop";
    private static final String PATH_LIST_APPLICATION_CONFIGURE = "/application/{0}/configure";

    public ApplicationContainer(String host, int port) {
        super(host, port);
    }

    public Map<?, ?> list() throws CoreException {
        try {
            HttpGet request = new HttpGet(this.getURI(PATH_LIST_APPLICATION).toASCIIString());
            HttpResponse response = this.getHttpClient().execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                ApplicationContainer.throwException(MessageFormat.format("Unable to list applications. Status : {0}", this.getErrorMessage(response)), null, 4);
            }
            InputStream rstream = null;
            ObjectMapper objectMapper = new ObjectMapper();
            rstream = response.getEntity().getContent();
            Object readValue = objectMapper.readValue(rstream, Object.class);
            if (readValue instanceof Map) {
                return (Map)readValue;
            }
            return Collections.emptyMap();
        }
        catch (IOException e) {
            ApplicationContainer.throwException("Unable to list applications.", e, 4);
        }
        catch (URISyntaxException e) {
            ApplicationContainer.throwException("Unable to list applications.", e, 4);
        }
        return null;
    }

    public void start(String applicationId) throws CoreException {
        try {
            HttpPut request = new HttpPut(this.getURI(MessageFormat.format(PATH_LIST_APPLICATION_START, applicationId)).toASCIIString());
            ObjectMapper objectMapper = new ObjectMapper();
            request.setEntity((HttpEntity)new StringEntity(objectMapper.writeValueAsString((Object)"")));
            HttpResponse response = this.getHttpClient().execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                ApplicationContainer.throwException(MessageFormat.format("Unable to start application {0}. Status : {1}", applicationId, this.getErrorMessage(response)), null, 4);
            }
        }
        catch (IOException e) {
            ApplicationContainer.throwException(MessageFormat.format("Unable to start application {0}.", applicationId), e, 4);
        }
        catch (URISyntaxException e) {
            ApplicationContainer.throwException(MessageFormat.format("Unable to start application {0}.", applicationId), e, 4);
        }
    }

    public void stop(String applicationId) throws CoreException {
        try {
            HttpPut request = new HttpPut(this.getURI(MessageFormat.format(PATH_LIST_APPLICATION_STOP, applicationId)).toASCIIString());
            ObjectMapper objectMapper = new ObjectMapper();
            request.setEntity((HttpEntity)new StringEntity(objectMapper.writeValueAsString((Object)"")));
            HttpResponse response = this.getHttpClient().execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                ApplicationContainer.throwException(MessageFormat.format("Unable to stop application {0}. Status : {1}", applicationId, this.getErrorMessage(response)), null, 4);
            }
        }
        catch (IOException e) {
            ApplicationContainer.throwException(MessageFormat.format("Unable to stop application {0}.", applicationId), e, 4);
        }
        catch (URISyntaxException e) {
            ApplicationContainer.throwException(MessageFormat.format("Unable to stop application {0}.", applicationId), e, 4);
        }
    }

    public Map<?, ?> status(String applicationId) throws CoreException {
        try {
            HttpGet request = new HttpGet(this.getURI(MessageFormat.format(PATH_LIST_APPLICATION_STATUS, applicationId)).toASCIIString());
            HttpResponse response = this.getHttpClient().execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                MessageFormat.format("Unable to get status for application {0}. Status : {1}", applicationId, this.getErrorMessage(response), null, 4);
            }
            InputStream rstream = null;
            ObjectMapper objectMapper = new ObjectMapper();
            rstream = response.getEntity().getContent();
            Object readValue = objectMapper.readValue(rstream, Object.class);
            if (readValue instanceof Map) {
                return (Map)readValue;
            }
            return Collections.emptyMap();
        }
        catch (IOException e) {
            ApplicationContainer.throwException(MessageFormat.format("Unable to get status for application {0}.", applicationId), e, 4);
        }
        catch (URISyntaxException e) {
            ApplicationContainer.throwException(MessageFormat.format("Unable to get status for application {0}.", applicationId), e, 4);
        }
        return Collections.emptyMap();
    }

    public void configure(String applicationId, Boolean autostart) throws CoreException {
        try {
            HttpPut request = new HttpPut(this.getURI(MessageFormat.format(PATH_LIST_APPLICATION_CONFIGURE, applicationId)).toASCIIString());
            ObjectMapper objectMapper = new ObjectMapper();
            request.setEntity((HttpEntity)new StringEntity(objectMapper.writeValueAsString((Object)autostart)));
            HttpResponse response = this.getHttpClient().execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                ApplicationContainer.throwException(MessageFormat.format("Unable to configure application {0}. Status : {1}", applicationId, this.getErrorMessage(response)), null, 4);
            }
        }
        catch (IOException e) {
            ApplicationContainer.throwException(MessageFormat.format("Unable to configure application {0}.", applicationId), e, 4);
        }
        catch (URISyntaxException e) {
            ApplicationContainer.throwException(MessageFormat.format("Unable to configure application {0}.", applicationId), e, 4);
        }
    }

    private static void throwException(String message, Throwable t, int severity) throws CoreException {
        throw new CoreException((IStatus)new Status(severity, "org.eclipse.koneki.mihini.tm.core", message, t));
    }
}

