/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.mihini.tm.core.softwarepackage;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;
import org.eclipse.koneki.mihini.tm.core.Activator;
import org.eclipse.koneki.mihini.tm.core.softwarepackage.ManifestMode;

public class ManifestGenerator {
    public String manifestToString(String projectName, String manifestVersion, String binDirectory, ManifestMode mode) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeManifest(byteArrayOutputStream, projectName, manifestVersion, binDirectory, mode);
        }
        catch (IOException e) {
            Activator.logWarning("Unable to generate manifest.", e);
            return null;
        }
        return byteArrayOutputStream.toString();
    }

    public byte[] manifestToByteArray(String projectName, String manifestVersion, String binDirectory, ManifestMode mode) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeManifest(byteArrayOutputStream, projectName, manifestVersion, binDirectory, mode);
        }
        catch (IOException e) {
            Activator.logWarning("Unable to generate manifest.", e);
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void writeManifest(OutputStream outputStream, String projectName, String manifestVersion, String binDirectory, ManifestMode mode) throws IOException {
        IOUtils.write((String)"{", (OutputStream)outputStream);
        IOUtils.write((String)"\n", (OutputStream)outputStream);
        IOUtils.write((String)"\tcomponents =", (OutputStream)outputStream);
        IOUtils.write((String)"\n", (OutputStream)outputStream);
        IOUtils.write((String)"\t{", (OutputStream)outputStream);
        IOUtils.write((String)"\n", (OutputStream)outputStream);
        IOUtils.write((String)"\t\t{", (OutputStream)outputStream);
        IOUtils.write((String)"\n", (OutputStream)outputStream);
        String name = MessageFormat.format("\t\t\tname = \"@sys.appcon.{0}\",", projectName);
        IOUtils.write((String)name, (OutputStream)outputStream);
        IOUtils.write((String)"\n", (OutputStream)outputStream);
        if (mode == ManifestMode.INSTALL) {
            String location = MessageFormat.format("\t\t\tlocation = \"{0}\",", binDirectory);
            IOUtils.write((String)location, (OutputStream)outputStream);
        }
        IOUtils.write((String)"\n", (OutputStream)outputStream);
        if (mode == ManifestMode.INSTALL) {
            IOUtils.write((String)"\t\t\tdepends    = {},", (OutputStream)outputStream);
        } else {
            IOUtils.write((String)"\t\t\tdepends    = nil,", (OutputStream)outputStream);
        }
        IOUtils.write((String)"\n", (OutputStream)outputStream);
        if (mode == ManifestMode.INSTALL) {
            IOUtils.write((String)"\t\t\tprovides   = {},", (OutputStream)outputStream);
        } else {
            IOUtils.write((String)"\t\t\tprovides   = nil,", (OutputStream)outputStream);
        }
        IOUtils.write((String)"\n", (OutputStream)outputStream);
        IOUtils.write((String)"\t\t\tparameters = { purge=false, autostart=true },", (OutputStream)outputStream);
        IOUtils.write((String)"\n", (OutputStream)outputStream);
        if (mode == ManifestMode.INSTALL) {
            IOUtils.write((String)MessageFormat.format("\t\t\tversion = \"{0}\",", manifestVersion), (OutputStream)outputStream);
        } else {
            IOUtils.write((String)"\t\t\tversion = nil,", (OutputStream)outputStream);
        }
        IOUtils.write((String)"\n", (OutputStream)outputStream);
        IOUtils.write((String)"\t\t}", (OutputStream)outputStream);
        IOUtils.write((String)"\n", (OutputStream)outputStream);
        IOUtils.write((String)"\t}", (OutputStream)outputStream);
        IOUtils.write((String)"\n", (OutputStream)outputStream);
        IOUtils.write((String)"}", (OutputStream)outputStream);
        IOUtils.write((String)"\n", (OutputStream)outputStream);
    }
}

